/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.opensubtitles;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.util.RingBuffer;

class OpenSubtitlesConnectionCounter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSubtitlesConnectionCounter.class);
    private static final RingBuffer<Long> COUNTER = new RingBuffer(40);
    private static final int DURATION = 10500;

    private OpenSubtitlesConnectionCounter() {
        throw new IllegalAccessError();
    }

    static synchronized void trackConnections() throws InterruptedException {
        long oldestConnection;
        long currentTime = System.currentTimeMillis();
        if (COUNTER.count() == COUNTER.maxSize() && (oldestConnection = COUNTER.getTailItem().longValue()) > currentTime - 10500L) {
            LOGGER.debug("connection limit reached, throttling {}", COUNTER);
            do {
                OpenSubtitlesConnectionCounter.class.wait(10500L - (currentTime - oldestConnection));
            } while (oldestConnection > (currentTime = System.currentTimeMillis()) - 10500L);
        }
        currentTime = System.currentTimeMillis();
        COUNTER.add(currentTime);
    }
}

