/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.renderer;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

public class BorderTableCellRenderer
extends DefaultTableCellRenderer {
    private final Border border;

    public BorderTableCellRenderer() {
        this.border = BorderFactory.createEmptyBorder(0, 2, 0, 0);
        this.setOpaque(false);
    }

    public BorderTableCellRenderer(int top, int left, int bottom, int right) {
        this.border = BorderFactory.createEmptyBorder(top, left, bottom, right);
        this.setOpaque(false);
    }

    public BorderTableCellRenderer(Insets insets) {
        this.border = BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
        this.setOpaque(false);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setForeground(table.getForeground());
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
        }
        Component comp = super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
        Border defaultBorder = ((JComponent)comp).getBorder();
        this.setBorder(BorderFactory.createCompoundBorder(defaultBorder, this.border));
        if (value != null) {
            this.setValue(value.toString());
        } else {
            this.setValue("");
        }
        return this;
    }
}

