/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.clipinf;

import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.library.bluray.clipinf.HexStringByteAdapter;

@XmlType(propOrder={"pid", "streamType", "format", "flags", "color", "reserved", "isrc", "reserved2"})
public class StreamAttr {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamAttr.class);
    private short pid;
    private Byte streamType;
    private Byte format;
    private Byte flags;
    private Byte color;
    private byte reserved;
    private byte[] isrc = new byte[12];
    private int reserved2;

    public int size() {
        return 24;
    }

    public short getPid() {
        return this.pid;
    }

    public void setPid(short s) {
        this.pid = s;
    }

    @XmlJavaTypeAdapter(value=HexStringByteAdapter.class)
    public Byte getStreamType() {
        return this.streamType;
    }

    public void setStreamType(Byte by) {
        this.streamType = by;
    }

    @XmlJavaTypeAdapter(value=HexStringByteAdapter.class)
    public Byte getFormat() {
        return this.format;
    }

    public void setFormat(Byte by) {
        this.format = by;
    }

    @XmlJavaTypeAdapter(value=HexStringByteAdapter.class)
    public Byte getFlags() {
        return this.flags;
    }

    public void setFlags(Byte by) {
        this.flags = by;
    }

    @XmlJavaTypeAdapter(value=HexStringByteAdapter.class)
    public Byte getColor() {
        return this.color;
    }

    public void setColor(Byte by) {
        this.color = by;
    }

    public byte getReserved() {
        return this.reserved;
    }

    public void setReserved(byte by) {
        this.reserved = by;
    }

    public byte[] getIsrc() {
        return this.isrc;
    }

    public void setIsrc(byte[] byArray) {
        this.isrc = byArray;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(int n) {
        this.reserved2 = n;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        this.pid = dataInputStream.readShort();
        LOGGER.trace("StreamAttr pid=" + this.pid);
        byte by = dataInputStream.readByte();
        LOGGER.trace("StreamAttr length=" + by);
        this.streamType = dataInputStream.readByte();
        LOGGER.trace("StreamAttr streamType=" + this.streamType);
        this.format = dataInputStream.readByte();
        LOGGER.trace("StreamAttr format=" + this.format);
        this.flags = dataInputStream.readByte();
        LOGGER.trace("StreamAttr flags=" + this.flags);
        this.color = dataInputStream.readByte();
        LOGGER.trace("StreamAttr color=" + this.color);
        this.reserved = dataInputStream.readByte();
        LOGGER.trace("StreamAttr reserved=" + this.reserved);
        dataInputStream.read(this.isrc, 0, 12);
        this.reserved2 = dataInputStream.readInt();
        LOGGER.trace("StreamAttr reserved2=" + this.reserved2);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.getPid());
        dataOutputStream.writeByte(this.size() - 3);
        dataOutputStream.writeByte(this.getStreamType().byteValue());
        dataOutputStream.writeByte(this.getFormat().byteValue());
        dataOutputStream.writeByte(this.getFlags().byteValue());
        dataOutputStream.writeByte(this.getColor().byteValue());
        dataOutputStream.writeByte(this.getReserved());
        dataOutputStream.write(this.isrc, 0, 12);
        dataOutputStream.writeInt(this.getReserved2());
    }
}

