/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.panels;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.impl.gui.SortingState;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.movie.MovieComparator;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.HintManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TablePopupListener;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.actions.ClearFilterPresetAction;
import org.tinymediamanager.ui.actions.FilterPresetAction;
import org.tinymediamanager.ui.actions.RequestFocusAction;
import org.tinymediamanager.ui.components.button.SplitButton;
import org.tinymediamanager.ui.components.panel.TmmListPanel;
import org.tinymediamanager.ui.components.table.MouseKeyboardSortingStrategy;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.components.textfield.EnhancedTextField;
import org.tinymediamanager.ui.movies.MovieMatcherEditor;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.movies.MovieTableFormat;
import org.tinymediamanager.ui.movies.MovieTextMatcherEditor;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.actions.MovieEditAction;
import org.tinymediamanager.ui.movies.filters.IMovieUIFilter;

public class MovieListPanel
extends TmmListPanel {
    MovieSelectionModel selectionModel;
    private MovieList movieList;
    private TmmTable movieTable;
    private JLabel lblMovieCountFiltered;
    private JLabel lblMovieCountTotal;
    private SplitButton btnExtendedFilter;
    private JLabel lblSelectedCount;
    private JPopupMenu popupMenu;

    public MovieListPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.movieList = MovieModuleManager.getInstance().getMovieList();
        SortedList sortedMovies = new SortedList((EventList)GlazedListsSwing.swingThreadProxyList((EventList)((ObservableElementList)this.movieList.getMovies())), (Comparator)new MovieComparator());
        sortedMovies.setMode(1);
        this.setLayout((LayoutManager)new MigLayout("", "[200lp:n,grow][100lp:n,fill]", "[][200lp:300lp,grow]0[][]"));
        EnhancedTextField searchField = EnhancedTextField.createSearchTextField();
        this.add((Component)searchField, "cell 0 0,growx");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()), "search");
        this.getActionMap().put("search", new RequestFocusAction(searchField));
        MovieTextMatcherEditor textMatcherEditor = new MovieTextMatcherEditor(searchField);
        MovieMatcherEditor movieMatcherEditor = new MovieMatcherEditor();
        FilterList extendedFilteredMovies = new FilterList((EventList)sortedMovies, (MatcherEditor)movieMatcherEditor);
        FilterList textFilteredMovies = new FilterList((EventList)extendedFilteredMovies, (MatcherEditor)textMatcherEditor);
        this.selectionModel = new MovieSelectionModel((EventList<Movie>)textFilteredMovies, movieMatcherEditor);
        TmmTableModel<Movie> movieTableModel = new TmmTableModel<Movie>((EventList<Movie>)textFilteredMovies, new MovieTableFormat());
        this.movieTable = new TmmTable((TableModel)((Object)movieTableModel));
        this.movieTable.setName("movies.movieTable");
        this.movieTable.installComparatorChooser(sortedMovies, new MovieTableSortingStrategy());
        this.movieTable.getTableComparatorChooser().appendComparator(0, 0, false);
        this.movieTable.adjustColumnPreferredWidths(3);
        TmmUILayoutStore.getInstance().install(this.movieTable);
        movieTableModel.addTableModelListener(arg0 -> {
            this.lblMovieCountFiltered.setText(String.valueOf(movieTableModel.getRowCount()));
            ListSelectionModel selectionModel1 = this.movieTable.getSelectionModel();
            if (selectionModel1.isSelectionEmpty() && movieTableModel.getRowCount() > 0) {
                selectionModel1.setSelectionInterval(0, 0);
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        this.movieTable.configureScrollPane(scrollPane);
        this.add((Component)scrollPane, "cell 0 1 2 1,grow");
        this.btnExtendedFilter = new SplitButton(TmmResourceBundle.getString("movieextendedsearch.filter"));
        this.btnExtendedFilter.setToolTipText(TmmResourceBundle.getString("movieextendedsearch.options"));
        this.btnExtendedFilter.getActionButton().addActionListener(e -> MovieUIModule.getInstance().setFilterDialogVisible(true));
        this.btnExtendedFilter.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JPopupMenu popupMenu = MovieListPanel.this.btnExtendedFilter.getPopupMenu();
                popupMenu.removeAll();
                MovieModuleManager.getInstance().getSettings().getMovieUiFilterPresets().keySet().stream().sorted().forEach(uiFilter -> {
                    FilterPresetAction action = new FilterPresetAction((String)uiFilter){

                        @Override
                        protected void processAction(ActionEvent e) {
                            MovieUIModule.getInstance().getSelectionModel().setFilterValues(MovieModuleManager.getInstance().getSettings().getMovieUiFilterPresets().get(this.presetName));
                        }
                    };
                    popupMenu.add(action);
                });
                if (popupMenu.getSubElements().length != 0) {
                    popupMenu.addSeparator();
                }
                popupMenu.add(new ClearFilterPresetAction(){

                    @Override
                    protected void processAction(ActionEvent e) {
                        MovieUIModule.getInstance().getSelectionModel().setFilterValues(Collections.emptyList());
                    }
                });
                popupMenu.pack();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        HintManager.getInstance().addHint(TmmResourceBundle.getString("hintmanager.rightclick"), this.movieTable, 1);
        this.selectionModel.addPropertyChangeListener("filterChanged", evt -> this.updateFilterIndicator());
        this.add((Component)this.btnExtendedFilter, "cell 1 0");
        JSeparator separator = new JSeparator();
        this.add((Component)separator, "cell 0 2 2 1, growx");
        JPanel panelTotals = new JPanel();
        this.add((Component)panelTotals, "cell 0 3 2 1,grow");
        panelTotals.setLayout((LayoutManager)new MigLayout("insets 0", "[100lp:n,grow][100lp:n,grow,right]", "[]"));
        JLabel lblMovieCount = new JLabel(TmmResourceBundle.getString("tmm.movies") + ":");
        panelTotals.add((Component)lblMovieCount, "cell 0 0");
        this.lblMovieCountFiltered = new JLabel("");
        panelTotals.add((Component)this.lblMovieCountFiltered, "cell 0 0");
        JLabel lblMovieCountOf = new JLabel(TmmResourceBundle.getString("tmm.of"));
        panelTotals.add((Component)lblMovieCountOf, "cell 0 0");
        this.lblMovieCountTotal = new JLabel("");
        panelTotals.add((Component)this.lblMovieCountTotal, "cell 0 0");
        this.lblSelectedCount = new JLabel("");
        panelTotals.add((Component)this.lblSelectedCount, "cell 1 0");
        this.selectionModel.addPropertyChangeListener("selectedMovies", evt -> this.updateSelectionSums());
        this.lblMovieCountFiltered.setText(String.valueOf(movieTableModel.getRowCount()));
        this.initDataBindings();
        MovieModuleManager.getInstance().getSettings().addPropertyChangeListener(e -> {
            switch (e.getPropertyName()) {
                case "movieCheckMetadata": 
                case "movieCheckArtwork": {
                    this.movieTable.invalidate();
                    break;
                }
            }
        });
    }

    private void updateSelectionSums() {
        String selectedMovies = TmmResourceBundle.getString("movie.selected").replace("{}", String.valueOf(this.selectionModel.getSelectedMovies(true).size()));
        double videoFileSize = (double)this.selectionModel.getSelectedMovies(true).stream().mapToLong(Movie::getVideoFilesize).sum() / 1.0E9;
        double totalFileSize = (double)this.selectionModel.getSelectedMovies(true).stream().mapToLong(MediaEntity::getTotalFilesize).sum() / 1.0E9;
        String text = String.format("%s (%.2f G)", selectedMovies, totalFileSize);
        this.lblSelectedCount.setText(text);
        String selectedMoviesHint = selectedMovies + " (" + TmmResourceBundle.getString("tmm.selected.hint1").replace("{}", String.format("%.2f G", videoFileSize)) + " / " + TmmResourceBundle.getString("tmm.selected.hint2").replace("{}", String.format("%.2f G", totalFileSize)) + ")";
        this.lblSelectedCount.setToolTipText(selectedMoviesHint);
    }

    private void updateFilterIndicator() {
        boolean active = false;
        if (this.selectionModel.isFiltersActive()) {
            for (IMovieUIFilter filter : this.selectionModel.getMatcherEditor().getFilters()) {
                switch (filter.getFilterState()) {
                    case ACTIVE: 
                    case ACTIVE_NEGATIVE: {
                        active = true;
                        break;
                    }
                }
                if (!active) continue;
                break;
            }
        }
        if (active) {
            this.btnExtendedFilter.getActionButton().setIcon(IconManager.FILTER_ACTIVE);
        } else {
            this.btnExtendedFilter.getActionButton().setIcon(null);
        }
    }

    public void init() {
        ListSelectionModel selectionModel;
        this.updateFilterIndicator();
        this.movieTable.setSelectionModel((ListSelectionModel)this.selectionModel.getSelectionModel());
        if (MovieModuleManager.getInstance().getMovieList().getMovies() != null && !MovieModuleManager.getInstance().getMovieList().getMovies().isEmpty() && (selectionModel = this.movieTable.getSelectionModel()).isSelectionEmpty()) {
            int selectionIndex = this.movieTable.convertRowIndexToModel(0);
            selectionModel.setSelectionInterval(selectionIndex, selectionIndex);
        }
        this.addKeyListener();
        SwingUtilities.invokeLater(() -> this.movieTable.requestFocus());
    }

    private void addKeyListener() {
        this.movieTable.addKeyListener(new KeyListener(){
            private long lastKeypress = 0L;
            private String searchTerm = "";

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (!keyEvent.isConsumed() && keyEvent.getKeyChar() == '\n') {
                    new MovieEditAction().actionPerformed(new ActionEvent(keyEvent, 0, ""));
                    keyEvent.consume();
                    return;
                }
                long now = System.currentTimeMillis();
                if (now - this.lastKeypress > 500L) {
                    this.searchTerm = "";
                }
                this.lastKeypress = now;
                if (keyEvent.getKeyChar() != '\uffff') {
                    this.searchTerm = this.searchTerm + keyEvent.getKeyChar();
                    this.searchTerm = this.searchTerm.toLowerCase();
                    keyEvent.consume();
                }
                if (StringUtils.isNotBlank((CharSequence)this.searchTerm)) {
                    boolean titleColumn = true;
                    TableColumn tableColumn = MovieListPanel.this.movieTable.getColumnModel().getColumn(0);
                    if ("originalTitle".equals(tableColumn.getIdentifier())) {
                        titleColumn = false;
                    }
                    TableModel model = MovieListPanel.this.movieTable.getModel();
                    for (int i = 0; i < model.getRowCount(); ++i) {
                        if (!(model.getValueAt(i, 0) instanceof Movie)) continue;
                        Movie movie = (Movie)model.getValueAt(i, 0);
                        String title = titleColumn ? movie.getTitleSortable().toLowerCase(Locale.ROOT) : movie.getOriginalTitleSortable().toLowerCase(Locale.ROOT);
                        if (!title.startsWith(this.searchTerm)) continue;
                        MovieListPanel.this.movieTable.getSelectionModel().setSelectionInterval(i, i);
                        MovieListPanel.this.movieTable.scrollRectToVisible(new Rectangle(MovieListPanel.this.movieTable.getCellRect(i, 0, true)));
                        break;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }
        });
        InputMap inputMap = this.movieTable.getInputMap(0);
        ActionMap actionMap = this.movieTable.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(525, 0), "popup");
        actionMap.put("popup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MovieListPanel.this.popupMenu != null) {
                    Rectangle rect = MovieListPanel.this.movieTable.getCellRect(MovieListPanel.this.movieTable.getSelectedRow(), 0, false);
                    MovieListPanel.this.popupMenu.show(MovieListPanel.this.movieTable, rect.x + rect.width / 2, rect.y + rect.height / 2);
                }
            }
        });
    }

    public MovieSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
        if (popupMenu != null) {
            this.setComponentPopupMenu(popupMenu);
        }
        this.movieTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && !e.isConsumed() && e.getButton() == 1) {
                    MovieEditAction editAction = new MovieEditAction();
                    editAction.actionPerformed(null);
                }
            }
        });
        this.movieTable.addMouseListener(new TablePopupListener(popupMenu, this.movieTable));
    }

    protected void initDataBindings() {
        BeanProperty movieListBeanProperty = BeanProperty.create((String)"movieCount");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieList, (Property)movieListBeanProperty, (Object)this.lblMovieCountTotal, (Property)jLabelBeanProperty);
        autoBinding.bind();
    }

    private static class MovieTableSortingStrategy
    extends MouseKeyboardSortingStrategy {
        private boolean titleClicked = false;

        private MovieTableSortingStrategy() {
        }

        @Override
        public void columnClicked(SortingState sortingState, int column, int clicks, boolean shift, boolean control) {
            if (column == 0) {
                this.titleClicked = true;
            } else if (!control) {
                this.titleClicked = false;
            }
            super.columnClicked(sortingState, column, clicks, shift, control);
        }

        @Override
        public void finalHook(SortingState sortingState) {
            if (!this.titleClicked) {
                SortingState.SortingColumn sortingColumn = (SortingState.SortingColumn)sortingState.getColumns().get(0);
                sortingState.getRecentlyClickedColumns().remove(sortingColumn);
                sortingState.appendComparator(0, 0, false);
            }
        }
    }
}

