/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.core.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.verapdf.processor.BatchFileProcessor;

public class LogsFileHandler
extends FileHandler {
    private static final Logger LOGGER = Logger.getLogger(LogsFileHandler.class.getCanonicalName());
    public static final String SUFFIX = LogManager.getLogManager().getProperty(LogsFileHandler.class.getName() + ".pattern") == null ? ".log" : LogManager.getLogManager().getProperty(LogsFileHandler.class.getName() + ".pattern");
    private static final List<String> logFilePaths = new ArrayList<String>();

    public LogsFileHandler() throws IOException, SecurityException {
        this(SUFFIX);
    }

    public LogsFileHandler(String pattern) throws IOException, SecurityException {
        super(LogsFileHandler.getLogFile());
    }

    public LogsFileHandler(String pattern, boolean append) throws IOException, SecurityException {
        super(LogsFileHandler.getLogFile(), append);
    }

    public LogsFileHandler(String pattern, int limit, int count) throws IOException, SecurityException {
        super(LogsFileHandler.getLogFile(), limit, count);
    }

    public LogsFileHandler(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        super(LogsFileHandler.getLogFile(), limit, count, append);
    }

    public static long getPID() {
        return Long.parseLong(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
    }

    public static String getLogFile() throws IOException {
        long pid = LogsFileHandler.getPID();
        for (String filePath : logFilePaths) {
            if (!filePath.contains("logs" + pid)) continue;
            return filePath;
        }
        logFilePaths.add(Files.createTempFile("logs" + LogsFileHandler.getPID(), SUFFIX, new FileAttribute[0]).toString());
        return logFilePaths.get(logFilePaths.size() - 1);
    }

    public static void configLogs() {
        InputStream loggersConfig = BatchFileProcessor.class.getClassLoader().getResourceAsStream("org/verapdf/processor/logging.properties");
        try {
            LogManager.getLogManager().readConfiguration(loggersConfig);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Logging is not configured (console output only)");
        }
    }

    public static void createNewLogFile() throws IOException {
        File logs = new File(LogsFileHandler.getLogFile());
        if (!logs.exists()) {
            logs.createNewFile();
            logs.deleteOnExit();
        } else {
            try (PrintWriter writer = new PrintWriter(logs);){
                writer.print("");
            }
        }
    }

    public static void setLoggingLevel(Level level) {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        rootLogger.setLevel(level);
        for (Handler handler : handlers) {
            handler.setLevel(level);
        }
    }
}

