/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.operators;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSNumber;
import org.verapdf.gf.model.factory.operators.RenderingMode;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.pd.PDExtGState;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.font.PDFont;

public class GraphicState
implements Cloneable {
    private PDColorSpace fillColorSpace;
    private PDColorSpace strokeColorSpace;
    private PDColorSpace fillLastPatternUnderlyingColorSpace = null;
    private PDColorSpace strokeLastPatternUnderlyingColorSpace = null;
    private RenderingMode renderingMode = RenderingMode.FILL;
    private PDFont font;
    private boolean overprintingFlagStroke = false;
    private boolean overprintingFlagNonStroke = false;
    private int opm = 0;
    private GraphicState initialGraphicState = null;
    private boolean processColorOperators = true;
    private Double scaleFactor = null;

    private GraphicState() {
    }

    public GraphicState(PDResourcesHandler resourcesHandler) {
        this.fillColorSpace = resourcesHandler.getColorSpace(ASAtom.DEVICEGRAY);
        this.strokeColorSpace = resourcesHandler.getColorSpace(ASAtom.DEVICEGRAY);
    }

    public PDColorSpace getFillColorSpace() {
        return this.fillColorSpace;
    }

    public void setFillColorSpace(PDColorSpace fillColorSpace) {
        this.fillColorSpace = fillColorSpace;
    }

    public PDColorSpace getStrokeColorSpace() {
        return this.strokeColorSpace;
    }

    public void setStrokeColorSpace(PDColorSpace strokeColorSpace) {
        this.strokeColorSpace = strokeColorSpace;
    }

    public PDColorSpace getFillLastPatternUnderlyingColorSpace() {
        return this.fillLastPatternUnderlyingColorSpace;
    }

    public void setFillLastPatternUnderlyingColorSpace(PDColorSpace fillLastPatternUnderlyingColorSpace) {
        this.fillLastPatternUnderlyingColorSpace = fillLastPatternUnderlyingColorSpace;
    }

    public PDColorSpace getStrokeLastPatternUnderlyingColorSpace() {
        return this.strokeLastPatternUnderlyingColorSpace;
    }

    public void setStrokeLastPatternUnderlyingColorSpace(PDColorSpace strokeLastPatternUnderlyingColorSpace) {
        this.strokeLastPatternUnderlyingColorSpace = strokeLastPatternUnderlyingColorSpace;
    }

    public RenderingMode getRenderingMode() {
        return this.renderingMode;
    }

    public void setRenderingMode(RenderingMode renderingMode) {
        this.renderingMode = renderingMode;
    }

    public PDFont getFont() {
        return this.font;
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public Double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(Double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public boolean isOverprintingFlagStroke() {
        return this.overprintingFlagStroke;
    }

    public void setOverprintingFlagStroke(boolean overprintingFlagStroke) {
        this.overprintingFlagStroke = overprintingFlagStroke;
    }

    public boolean isOverprintingFlagNonStroke() {
        return this.overprintingFlagNonStroke;
    }

    public void setOverprintingFlagNonStroke(boolean overprintingFlagNonStroke) {
        this.overprintingFlagNonStroke = overprintingFlagNonStroke;
    }

    public int getOpm() {
        return this.opm;
    }

    public void setOpm(int opm) {
        this.opm = opm;
    }

    public GraphicState getInitialGraphicState() {
        return this.initialGraphicState;
    }

    public void setInitialGraphicState(GraphicState initialGraphicState) {
        this.initialGraphicState = initialGraphicState.clone();
    }

    public boolean isProcessColorOperators() {
        return this.processColorOperators;
    }

    public void disableColorOperators() {
        this.processColorOperators = false;
    }

    public void copyProperties(GraphicState graphicState) {
        this.fillColorSpace = graphicState.getFillColorSpace();
        this.strokeColorSpace = graphicState.getStrokeColorSpace();
        this.fillLastPatternUnderlyingColorSpace = graphicState.getFillLastPatternUnderlyingColorSpace();
        this.strokeLastPatternUnderlyingColorSpace = graphicState.getStrokeLastPatternUnderlyingColorSpace();
        this.renderingMode = graphicState.getRenderingMode();
        this.font = graphicState.getFont();
        this.overprintingFlagStroke = graphicState.isOverprintingFlagStroke();
        this.overprintingFlagNonStroke = graphicState.isOverprintingFlagNonStroke();
        this.opm = graphicState.getOpm();
        this.initialGraphicState = graphicState.getInitialGraphicState();
        this.processColorOperators = graphicState.isProcessColorOperators();
    }

    public void copyPropertiesFormExtGState(PDExtGState extGState) {
        if (extGState != null) {
            Long opm;
            Boolean oFNS;
            Boolean oFS;
            COSNumber fontSize;
            PDFont font = extGState.getFont();
            if (font != null) {
                this.font = font;
            }
            if ((fontSize = extGState.getCOSFontSize()) != null) {
                this.scaleFactor = fontSize.getReal();
            }
            if ((oFS = extGState.getStrokingOverprintControl()) != null) {
                this.overprintingFlagStroke = oFS;
            }
            if ((oFNS = extGState.getNonStrokingOverprintControl()) != null) {
                this.overprintingFlagNonStroke = oFNS;
            }
            if ((opm = extGState.getOverprintMode()) != null) {
                this.opm = opm.intValue();
            }
        }
    }

    protected GraphicState clone() {
        GraphicState clone = new GraphicState();
        clone.fillColorSpace = this.fillColorSpace;
        clone.strokeColorSpace = this.strokeColorSpace;
        clone.fillLastPatternUnderlyingColorSpace = this.fillLastPatternUnderlyingColorSpace;
        clone.strokeLastPatternUnderlyingColorSpace = this.strokeLastPatternUnderlyingColorSpace;
        clone.renderingMode = this.renderingMode;
        clone.font = this.font;
        clone.scaleFactor = this.scaleFactor;
        clone.overprintingFlagStroke = this.overprintingFlagStroke;
        clone.overprintingFlagNonStroke = this.overprintingFlagNonStroke;
        clone.opm = this.opm;
        clone.initialGraphicState = this.initialGraphicState;
        clone.processColorOperators = this.processColorOperators;
        return clone;
    }
}

