/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import java.io.StringReader;
import javax.xml.parsers.SAXParserFactory;
import org.freeplane.core.util.HtmlProcessor;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.XmlUtils;
import org.xml.sax.InputSource;

public class RichTextModel {
    private String contentType = null;
    private String text = null;
    private String xml = null;

    private static void validateXml(String xml) throws Exception {
        SAXParserFactory.newInstance().newSAXParser().getXMLReader().parse(new InputSource(new StringReader(xml)));
    }

    public RichTextModel() {
    }

    public RichTextModel(String contentType, String text, String xml) {
        this.contentType = contentType;
        this.text = text;
        this.xml = xml != null ? xml.trim() : null;
    }

    public String getText() {
        return this.text;
    }

    public String getXml() {
        return this.xml;
    }

    public final void setText(String newContent) {
        if (newContent == null) {
            this.xml = null;
            this.text = null;
            return;
        }
        if (HtmlUtils.isHtml(newContent)) {
            String html = XmlUtils.replaceAscii0BySpace(newContent);
            HtmlProcessor htmlProcessor = new HtmlProcessor(html);
            try {
                if (htmlProcessor.isOk()) {
                    String xhtml = htmlProcessor.cleanXhtml().trim();
                    RichTextModel.validateXml(xhtml);
                    this.xml = xhtml;
                    this.text = htmlProcessor.cleanHtml();
                    return;
                }
            }
            catch (Exception e) {
                LogUtils.severe("Can not create xhtml", e);
            }
            this.setText(" " + newContent);
        } else {
            this.text = newContent;
            this.xml = "<text>" + HtmlUtils.toXMLEscapedText(newContent) + "</text>";
        }
    }

    public final void setXml(String newContent) {
        if (newContent == null) {
            this.xml = null;
            this.text = null;
            return;
        }
        String trimmed = newContent.trim();
        if (HtmlUtils.isHtml(newContent)) {
            this.xml = trimmed;
            this.text = HtmlUtils.toHtml(trimmed);
        } else if (trimmed.startsWith("<text>") && trimmed.endsWith("</text>")) {
            this.xml = trimmed;
            this.text = HtmlUtils.toXMLUnescapedText(trimmed.substring("<text>".length(), trimmed.length() - "</text>".length()));
        } else if (trimmed.equals("<text/>")) {
            this.xml = trimmed;
            this.text = "";
        } else {
            this.setText(newContent);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String format) {
        this.contentType = format;
    }

    public boolean isEmpty() {
        return this.contentType == null && this.text == null && this.xml == null;
    }

    public String getTextOr(String fallback) {
        return this.text == null ? fallback : this.text;
    }
}

