/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Utils;

public class SelectNonBranchingWaySequences {
    private final Set<Node> outerNodes;
    private final Set<Node> nodes;

    public SelectNonBranchingWaySequences(Collection<Way> ways) {
        if (ways.isEmpty()) {
            this.outerNodes = null;
            this.nodes = null;
        } else {
            this.nodes = new TreeSet<Node>();
            this.outerNodes = new TreeSet<Node>();
            for (Way way : ways) {
                this.addNodes(way);
            }
        }
    }

    private void addNodes(Node node) {
        if (node == null) {
            return;
        }
        if (!this.nodes.add(node)) {
            this.outerNodes.remove(node);
        } else {
            this.outerNodes.add(node);
        }
    }

    private void addNodes(Way way) {
        this.addNodes(way.firstNode());
        this.addNodes(way.lastNode());
    }

    public boolean canExtend() {
        return !Utils.isEmpty(this.outerNodes);
    }

    private static Way findWay(Collection<OsmPrimitive> selection, Node node) {
        Way foundWay = null;
        for (Way way : node.getParentWays()) {
            if (way.getNodesCount() < 2 || !way.isFirstLastNode(node) || !way.isSelectable() || selection.contains(way)) continue;
            if (foundWay != null) {
                return null;
            }
            foundWay = way;
        }
        return foundWay;
    }

    private Way findWay(Collection<OsmPrimitive> selection) {
        return this.outerNodes.stream().map(node -> SelectNonBranchingWaySequences.findWay(selection, node)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void extend(DataSet data) {
        if (!this.canExtend()) {
            return;
        }
        Collection<OsmPrimitive> currentSelection = data.getSelected();
        Way way = this.findWay(currentSelection);
        if (way == null) {
            return;
        }
        boolean selectionChanged = false;
        LinkedList<OsmPrimitive> selection = new LinkedList<OsmPrimitive>(currentSelection);
        while (selection.add(way)) {
            selectionChanged = true;
            this.addNodes(way);
            way = this.findWay(selection);
            if (way != null) continue;
        }
        if (selectionChanged) {
            data.setSelected(selection);
        }
    }
}

