/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.prompt;

import java.awt.Color;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.Painters;
import org.jdesktop.swingx.plaf.TextUIWrapper;

public final class PromptSupport {
    public static final String PROMPT = "promptText";
    public static final String FOREGROUND = "promptForeground";
    public static final String BACKGROUND = "promptBackground";
    public static final String BACKGROUND_PAINTER = "promptBackgroundPainter";
    public static final String FOCUS_BEHAVIOR = "focusBehavior";
    public static final String FONT_STYLE = "promptFontStyle";

    private PromptSupport() {
    }

    public static void init(String promptText, Color promptForeground, Color promptBackground, JTextComponent textComponent) {
        if (promptText != null && promptText.length() > 0) {
            PromptSupport.setPrompt(promptText, textComponent);
        }
        if (promptForeground != null) {
            PromptSupport.setForeground(promptForeground, textComponent);
        }
        if (promptBackground != null) {
            PromptSupport.setBackground(promptBackground, textComponent);
        }
    }

    public static FocusBehavior getFocusBehavior(JTextComponent textComponent) {
        FocusBehavior fb = (FocusBehavior)((Object)textComponent.getClientProperty(FOCUS_BEHAVIOR));
        if (fb == null) {
            fb = FocusBehavior.HIDE_PROMPT;
        }
        return fb;
    }

    public static void setFocusBehavior(FocusBehavior focusBehavior, JTextComponent textComponent) {
        textComponent.putClientProperty(FOCUS_BEHAVIOR, (Object)focusBehavior);
        if (textComponent.isFocusOwner()) {
            textComponent.repaint();
        }
    }

    public static String getPrompt(JTextComponent textComponent) {
        return (String)textComponent.getClientProperty(PROMPT);
    }

    public static void setPrompt(String promptText, JTextComponent textComponent) {
        TextUIWrapper.getDefaultWrapper().install(textComponent, true);
        if (textComponent.getToolTipText() == null || textComponent.getToolTipText().equals(PromptSupport.getPrompt(textComponent))) {
            textComponent.setToolTipText(promptText);
        }
        textComponent.putClientProperty(PROMPT, promptText);
        textComponent.repaint();
    }

    public static Color getForeground(JTextComponent textComponent) {
        if (textComponent.getClientProperty(FOREGROUND) == null) {
            return textComponent.getDisabledTextColor();
        }
        return (Color)textComponent.getClientProperty(FOREGROUND);
    }

    public static void setForeground(Color promptTextColor, JTextComponent textComponent) {
        textComponent.putClientProperty(FOREGROUND, promptTextColor);
        textComponent.repaint();
    }

    public static Color getBackground(JTextComponent textComponent) {
        if (textComponent.getClientProperty(BACKGROUND) == null) {
            return textComponent.getBackground();
        }
        return (Color)textComponent.getClientProperty(BACKGROUND);
    }

    public static void setBackground(Color background, JTextComponent textComponent) {
        TextUIWrapper.getDefaultWrapper().install(textComponent, true);
        textComponent.putClientProperty(BACKGROUND, background);
        textComponent.repaint();
    }

    public static <T extends JTextComponent> Painter<? super T> getBackgroundPainter(T textComponent) {
        Painter<Object> painter = (Painter<Object>)textComponent.getClientProperty(BACKGROUND_PAINTER);
        if (painter == null) {
            painter = Painters.EMPTY_PAINTER;
        }
        return painter;
    }

    public static <T extends JTextComponent> void setBackgroundPainter(Painter<? super T> background, T textComponent) {
        TextUIWrapper.getDefaultWrapper().install(textComponent, true);
        textComponent.putClientProperty(BACKGROUND_PAINTER, background);
        textComponent.repaint();
    }

    public static void setFontStyle(Integer fontStyle, JTextComponent textComponent) {
        textComponent.putClientProperty(FONT_STYLE, fontStyle);
        textComponent.revalidate();
        textComponent.repaint();
    }

    public static Integer getFontStyle(JTextComponent textComponent) {
        return (Integer)textComponent.getClientProperty(FONT_STYLE);
    }

    public static enum FocusBehavior {
        SHOW_PROMPT,
        HIGHLIGHT_PROMPT,
        HIDE_PROMPT;

    }
}

