/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class ChatScreen
extends Screen {
    public static final double MOUSE_SCROLL_SPEED = 7.0;
    private static final Component USAGE_TEXT = Component.translatable("chat_screen.usage");
    private static final int TOOLTIP_MAX_WIDTH = 210;
    private String historyBuffer = "";
    private int historyPos = -1;
    protected EditBox input;
    protected String initial;
    protected boolean isDraft;
    protected ExitReason exitReason = ExitReason.INTERRUPTED;
    CommandSuggestions commandSuggestions;

    public ChatScreen(String p_95579_, boolean p_430033_) {
        super(Component.translatable("chat_screen.title"));
        this.initial = p_95579_;
        this.isDraft = p_430033_;
    }

    @Override
    protected void init() {
        this.historyPos = this.minecraft.gui.getChat().getRecentChat().size();
        this.input = new EditBox(this.minecraft.fontFilterFishy, 4, this.height - 12, this.width - 4, 12, Component.translatable("chat.editBox")){

            protected MutableComponent createNarrationMessage() {
                return super.createNarrationMessage().append(ChatScreen.this.commandSuggestions.getNarrationMessage());
            }
        };
        this.input.setMaxLength(256);
        this.input.setBordered(false);
        this.input.setValue(this.initial);
        this.input.setResponder(this::onEdited);
        this.input.addFormatter(this::formatChat);
        this.input.setCanLoseFocus(false);
        this.addRenderableWidget(this.input);
        this.commandSuggestions = new CommandSuggestions(this.minecraft, (Screen)this, this.input, this.font, false, false, 1, 10, true, -805306368);
        this.commandSuggestions.setAllowHiding(false);
        this.commandSuggestions.setAllowSuggestions(false);
        this.commandSuggestions.updateCommandInfo();
    }

    @Override
    protected void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.input);
    }

    @Override
    public void resize(Minecraft p_95600_, int p_95601_, int p_95602_) {
        this.initial = this.input.getValue();
        this.init(p_95600_, p_95601_, p_95602_);
    }

    @Override
    public void onClose() {
        this.exitReason = ExitReason.INTENTIONAL;
        super.onClose();
    }

    @Override
    public void removed() {
        this.minecraft.gui.getChat().resetChatScroll();
        this.initial = this.input.getValue();
        if (this.shouldDiscardDraft() || StringUtils.isBlank((CharSequence)this.initial)) {
            this.minecraft.gui.getChat().discardDraft();
        } else if (!this.isDraft) {
            this.minecraft.gui.getChat().saveAsDraft(this.initial);
        }
    }

    protected boolean shouldDiscardDraft() {
        return this.exitReason != ExitReason.INTERRUPTED && (this.exitReason != ExitReason.INTENTIONAL || (Boolean)this.minecraft.options.saveChatDrafts().get() == false);
    }

    private void onEdited(String p_95611_) {
        this.commandSuggestions.setAllowSuggestions(true);
        this.commandSuggestions.updateCommandInfo();
        this.isDraft = false;
    }

    @Override
    public boolean keyPressed(KeyEvent p_426273_) {
        if (this.commandSuggestions.keyPressed(p_426273_)) {
            return true;
        }
        if (this.isDraft && p_426273_.key() == 259) {
            this.input.setValue("");
            this.isDraft = false;
            return true;
        }
        if (super.keyPressed(p_426273_)) {
            return true;
        }
        if (p_426273_.isConfirmation()) {
            this.handleChatInput(this.input.getValue(), true);
            this.exitReason = ExitReason.DONE;
            if (this.minecraft.screen == this) {
                this.minecraft.setScreen(null);
            }
            return true;
        }
        switch (p_426273_.key()) {
            case 264: {
                this.moveInHistory(1);
                break;
            }
            case 265: {
                this.moveInHistory(-1);
                break;
            }
            case 266: {
                this.minecraft.gui.getChat().scrollChat(this.minecraft.gui.getChat().getLinesPerPage() - 1);
                break;
            }
            case 267: {
                this.minecraft.gui.getChat().scrollChat(-this.minecraft.gui.getChat().getLinesPerPage() + 1);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean mouseScrolled(double p_95581_, double p_95582_, double p_95583_, double p_300876_) {
        if (this.commandSuggestions.mouseScrolled(p_300876_ = Mth.clamp(p_300876_, -1.0, 1.0))) {
            return true;
        }
        if (!this.minecraft.hasShiftDown()) {
            p_300876_ *= 7.0;
        }
        this.minecraft.gui.getChat().scrollChat((int)p_300876_);
        return true;
    }

    public boolean mouseClicked(MouseButtonEvent p_429485_, boolean p_423918_) {
        if (this.commandSuggestions.mouseClicked(p_429485_)) {
            return true;
        }
        if (p_429485_.button() == 0) {
            ChatComponent chatcomponent = this.minecraft.gui.getChat();
            if (chatcomponent.handleChatQueueClicked(p_429485_.x(), p_429485_.y())) {
                return true;
            }
            Style style = this.getComponentStyleAt(p_429485_.x(), p_429485_.y());
            if (style != null && this.handleComponentClicked(style)) {
                this.initial = this.input.getValue();
                return true;
            }
        }
        return super.mouseClicked(p_429485_, p_423918_);
    }

    @Override
    public void insertText(String p_95606_, boolean p_95607_) {
        if (p_95607_) {
            this.input.setValue(p_95606_);
        } else {
            this.input.insertText(p_95606_);
        }
    }

    public void moveInHistory(int p_95589_) {
        int i = this.historyPos + p_95589_;
        int j = this.minecraft.gui.getChat().getRecentChat().size();
        if ((i = Mth.clamp(i, 0, j)) != this.historyPos) {
            if (i == j) {
                this.historyPos = j;
                this.input.setValue(this.historyBuffer);
            } else {
                if (this.historyPos == j) {
                    this.historyBuffer = this.input.getValue();
                }
                this.input.setValue((String)this.minecraft.gui.getChat().getRecentChat().get(i));
                this.commandSuggestions.setAllowSuggestions(false);
                this.historyPos = i;
            }
        }
    }

    @Nullable
    private FormattedCharSequence formatChat(String p_429271_, int p_423659_) {
        return this.isDraft ? FormattedCharSequence.forward(p_429271_, Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(true)) : null;
    }

    @Override
    public void render(GuiGraphics p_282470_, int p_282674_, int p_282014_, float p_283132_) {
        p_282470_.fill(2, this.height - 14, this.width - 2, this.height - 2, this.minecraft.options.getBackgroundColor(Integer.MIN_VALUE));
        this.minecraft.gui.getChat().render(p_282470_, this.minecraft.gui.getGuiTicks(), p_282674_, p_282014_, true);
        super.render(p_282470_, p_282674_, p_282014_, p_283132_);
        this.commandSuggestions.render(p_282470_, p_282674_, p_282014_);
        GuiMessageTag guimessagetag = this.minecraft.gui.getChat().getMessageTagAt((double)p_282674_, (double)p_282014_);
        if (guimessagetag != null && guimessagetag.text() != null) {
            p_282470_.setTooltipForNextFrame(this.font, this.font.split(guimessagetag.text(), 210), p_282674_, p_282014_);
        } else {
            Style style = this.getComponentStyleAt(p_282674_, p_282014_);
            p_282470_.renderComponentHoverEffect(this.font, style, p_282674_, p_282014_);
        }
    }

    @Override
    public void renderBackground(GuiGraphics p_298203_, int p_299897_, int p_297752_, float p_300216_) {
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public boolean isAllowedInPortal() {
        return true;
    }

    @Override
    protected void updateNarrationState(NarrationElementOutput p_169238_) {
        p_169238_.add(NarratedElementType.TITLE, this.getTitle());
        p_169238_.add(NarratedElementType.USAGE, USAGE_TEXT);
        String s = this.input.getValue();
        if (!s.isEmpty()) {
            p_169238_.nest().add(NarratedElementType.TITLE, (Component)Component.translatable("chat_screen.message", s));
        }
    }

    @Nullable
    private Style getComponentStyleAt(double p_232702_, double p_232703_) {
        return this.minecraft.gui.getChat().getClickedComponentStyleAt(p_232702_, p_232703_);
    }

    public void handleChatInput(String p_242400_, boolean p_242161_) {
        if (!(p_242400_ = this.normalizeChatMessage(p_242400_)).isEmpty()) {
            if (p_242161_) {
                this.minecraft.gui.getChat().addRecentChat(p_242400_);
            }
            if (p_242400_.startsWith("/")) {
                this.minecraft.player.connection.sendCommand(p_242400_.substring(1));
            } else {
                this.minecraft.player.connection.sendChat(p_242400_);
            }
        }
    }

    public String normalizeChatMessage(String p_232707_) {
        return StringUtil.trimChatMessage(StringUtils.normalizeSpace((String)p_232707_.trim()));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static enum ExitReason {
        INTENTIONAL,
        INTERRUPTED,
        DONE;

    }

    @FunctionalInterface
    @OnlyIn(value=Dist.CLIENT)
    public static interface ChatConstructor<T extends ChatScreen> {
        public T create(String var1, boolean var2);
    }
}

