/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model.multipart;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class MultiPartModel
implements BlockStateModel {
    private final SharedBakedState shared;
    private final BlockState blockState;
    @Nullable
    private List<BlockStateModel> models;
    private boolean cacheKey = false;
    @Nullable
    private Collection<ChunkSectionLayer> cache;

    MultiPartModel(SharedBakedState p_391554_, BlockState p_397918_) {
        this.shared = p_391554_;
        this.blockState = p_397918_;
    }

    @Override
    public TextureAtlasSprite particleIcon() {
        return this.shared.particleIcon;
    }

    public TextureAtlasSprite particleIcon(ModelData data) {
        return this.shared.firstModel.particleIcon(data);
    }

    @Override
    public void collectParts(RandomSource p_391247_, List<BlockModelPart> p_397207_) {
        if (this.models == null) {
            this.models = this.shared.selectModels(this.blockState);
        }
        long i = p_391247_.nextLong();
        for (BlockStateModel blockstatemodel : this.models) {
            p_391247_.setSeed(i);
            blockstatemodel.collectParts(p_391247_, p_397207_);
        }
    }

    public void collectParts(RandomSource rand, List<BlockModelPart> dest, ModelData extraData, ChunkSectionLayer renderType) {
        if (this.models == null) {
            this.models = this.shared.selectModels(this.blockState);
        }
        long i = rand.nextLong();
        for (BlockStateModel blockstatemodel : this.models) {
            rand.setSeed(i);
            blockstatemodel.collectParts(rand, dest, extraData, renderType);
        }
    }

    public Collection<ChunkSectionLayer> getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        if (this.models == null) {
            this.models = this.shared.selectModels(this.blockState);
        }
        if (this.cache == null || this.cacheKey != ItemBlockRenderTypes.isFancy()) {
            EnumSet<ChunkSectionLayer> tmp = EnumSet.noneOf(ChunkSectionLayer.class);
            for (BlockStateModel model : this.models) {
                tmp.addAll(model.getRenderTypes(state, rand, data));
            }
            this.cache = tmp;
        }
        return !this.cache.isEmpty() ? this.cache : BlockStateModel.super.getRenderTypes(state, rand, data);
    }

    @OnlyIn(value=Dist.CLIENT)
    static final class SharedBakedState {
        private final List<Selector<BlockStateModel>> selectors;
        final TextureAtlasSprite particleIcon;
        final BlockStateModel firstModel;
        private final Map<BitSet, List<BlockStateModel>> subsets = new ConcurrentHashMap<BitSet, List<BlockStateModel>>();

        private static BlockStateModel getFirstModel(List<Selector<BlockStateModel>> p_392132_) {
            if (p_392132_.isEmpty()) {
                throw new IllegalArgumentException("Model must have at least one selector");
            }
            return p_392132_.getFirst().model();
        }

        public SharedBakedState(List<Selector<BlockStateModel>> p_393647_) {
            this.selectors = p_393647_;
            this.firstModel = SharedBakedState.getFirstModel(p_393647_);
            this.particleIcon = this.firstModel.particleIcon();
        }

        public List<BlockStateModel> selectModels(BlockState p_392405_) {
            BitSet bitset = new BitSet();
            for (int i = 0; i < this.selectors.size(); ++i) {
                if (!this.selectors.get((int)i).condition.test(p_392405_)) continue;
                bitset.set(i);
            }
            return this.subsets.computeIfAbsent(bitset, p_394548_ -> {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int j = 0; j < this.selectors.size(); ++j) {
                    if (!p_394548_.get(j)) continue;
                    builder.add((Object)((BlockStateModel)this.selectors.get((int)j).model));
                }
                return builder.build();
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Unbaked
    implements BlockStateModel.UnbakedRoot {
        final List<Selector<BlockStateModel.Unbaked>> selectors;
        private final ModelBaker.SharedOperationKey<SharedBakedState> sharedStateKey = new ModelBaker.SharedOperationKey<SharedBakedState>(){

            @Override
            public SharedBakedState compute(ModelBaker p_391510_) {
                ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)selectors.size());
                for (Selector<BlockStateModel.Unbaked> selector : selectors) {
                    builder.add(selector.with(((BlockStateModel.Unbaked)selector.model).bake(p_391510_)));
                }
                return new SharedBakedState((List<Selector<BlockStateModel>>)builder.build());
            }
        };

        public Unbaked(List<Selector<BlockStateModel.Unbaked>> p_396159_) {
            this.selectors = p_396159_;
        }

        @Override
        public Object visualEqualityGroup(BlockState p_395674_) {
            IntArrayList intlist = new IntArrayList();
            for (int i = 0; i < this.selectors.size(); ++i) {
                if (!this.selectors.get((int)i).condition.test(p_395674_)) continue;
                intlist.add(i);
            }
            @OnlyIn(value=Dist.CLIENT)
            record Key(Unbaked model, IntList selectors) {
            }
            return new Key(this, (IntList)intlist);
        }

        public void resolveDependencies(ResolvableModel.Resolver p_397107_) {
            this.selectors.forEach(p_394441_ -> ((BlockStateModel.Unbaked)p_394441_.model).resolveDependencies(p_397107_));
        }

        @Override
        public BlockStateModel bake(BlockState p_397109_, ModelBaker p_397052_) {
            SharedBakedState multipartmodel$sharedbakedstate = p_397052_.compute(this.sharedStateKey);
            return new MultiPartModel(multipartmodel$sharedbakedstate, p_397109_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Selector<T>(Predicate<BlockState> condition, T model) {
        public <S> Selector<S> with(S p_393772_) {
            return new Selector<S>(this.condition, p_393772_);
        }
    }
}

