/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture.atlas;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.slf4j.Logger;

@FunctionalInterface
@OnlyIn(value=Dist.CLIENT)
public interface SpriteResourceLoader {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static SpriteResourceLoader create(Set<MetadataSectionType<?>> p_423718_) {
        return (p_421043_, p_421044_) -> {
            SpriteContents contents;
            FrameSize framesize;
            NativeImage nativeimage;
            List<MetadataSectionType.WithValue<?>> list;
            Optional<AnimationMetadataSection> optional;
            try {
                ResourceMetadata resourcemetadata = p_421044_.metadata();
                optional = resourcemetadata.getSection(AnimationMetadataSection.TYPE);
                list = resourcemetadata.getTypedSections(p_423718_);
            }
            catch (Exception exception) {
                LOGGER.error("Unable to parse metadata from {}", (Object)p_421043_, (Object)exception);
                return null;
            }
            try (InputStream inputstream = p_421044_.open();){
                nativeimage = NativeImage.read((InputStream)inputstream);
            }
            catch (IOException ioexception) {
                LOGGER.error("Using missing texture, unable to load {}", (Object)p_421043_, (Object)ioexception);
                return null;
            }
            if (optional.isPresent()) {
                framesize = ((AnimationMetadataSection)optional.get()).calculateFrameSize(nativeimage.getWidth(), nativeimage.getHeight());
                if (!Mth.isMultipleOf(nativeimage.getWidth(), framesize.width()) || !Mth.isMultipleOf(nativeimage.getHeight(), framesize.height())) {
                    LOGGER.error("Image {} size {},{} is not multiple of frame size {},{}", new Object[]{p_421043_, nativeimage.getWidth(), nativeimage.getHeight(), framesize.width(), framesize.height()});
                    nativeimage.close();
                    return null;
                }
            } else {
                framesize = new FrameSize(nativeimage.getWidth(), nativeimage.getHeight());
            }
            if ((contents = ForgeHooksClient.loadSpriteContents((ResourceLocation)p_421043_, (Resource)p_421044_, (FrameSize)framesize, (NativeImage)nativeimage, list)) != null) {
                return contents;
            }
            return new SpriteContents(p_421043_, framesize, nativeimage, optional, list);
        };
    }

    @Nullable
    public SpriteContents loadSprite(ResourceLocation var1, Resource var2);
}

