/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dialog.Dialog;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.PlayerEquipment;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.extensions.IForgePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.PlayerEquipmentInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public abstract class Player
extends Avatar
implements ContainerUser,
IForgePlayer {
    public static final int MAX_HEALTH = 20;
    public static final int SLEEP_DURATION = 100;
    public static final int WAKE_UP_DURATION = 10;
    public static final int ENDER_SLOT_OFFSET = 200;
    public static final int HELD_ITEM_SLOT = 499;
    public static final int CRAFTING_SLOT_OFFSET = 500;
    public static final float DEFAULT_BLOCK_INTERACTION_RANGE = 4.5f;
    public static final float DEFAULT_ENTITY_INTERACTION_RANGE = 3.0f;
    private static final int CURRENT_IMPULSE_CONTEXT_RESET_GRACE_TIME_TICKS = 40;
    private static final EntityDataAccessor<Float> DATA_PLAYER_ABSORPTION_ID = SynchedEntityData.defineId(Player.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_SCORE_ID = SynchedEntityData.defineId(Player.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<OptionalInt> DATA_SHOULDER_PARROT_LEFT = SynchedEntityData.defineId(Player.class, EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    private static final EntityDataAccessor<OptionalInt> DATA_SHOULDER_PARROT_RIGHT = SynchedEntityData.defineId(Player.class, EntityDataSerializers.OPTIONAL_UNSIGNED_INT);
    public static final int CLIENT_LOADED_TIMEOUT_TIME = 60;
    private static final short DEFAULT_SLEEP_TIMER = 0;
    private static final float DEFAULT_EXPERIENCE_PROGRESS = 0.0f;
    private static final int DEFAULT_EXPERIENCE_LEVEL = 0;
    private static final int DEFAULT_TOTAL_EXPERIENCE = 0;
    private static final int NO_ENCHANTMENT_SEED = 0;
    private static final int DEFAULT_SELECTED_SLOT = 0;
    private static final int DEFAULT_SCORE = 0;
    private static final boolean DEFAULT_IGNORE_FALL_DAMAGE_FROM_CURRENT_IMPULSE = false;
    private static final int DEFAULT_CURRENT_IMPULSE_CONTEXT_RESET_GRACE_TIME = 0;
    final Inventory inventory;
    protected PlayerEnderChestContainer enderChestInventory = new PlayerEnderChestContainer();
    public final InventoryMenu inventoryMenu;
    public AbstractContainerMenu containerMenu;
    protected FoodData foodData = new FoodData();
    protected int jumpTriggerTime;
    private boolean clientLoaded = false;
    protected int clientLoadedTimeoutTimer = 60;
    public int takeXpDelay;
    private int sleepCounter = 0;
    protected boolean wasUnderwater;
    private final Abilities abilities = new Abilities();
    public int experienceLevel = 0;
    public int totalExperience = 0;
    public float experienceProgress = 0.0f;
    protected int enchantmentSeed = 0;
    protected final float defaultFlySpeed = 0.02f;
    private int lastLevelUpTime;
    private final GameProfile gameProfile;
    private boolean reducedDebugInfo;
    private ItemStack lastItemInMainHand = ItemStack.EMPTY;
    private final ItemCooldowns cooldowns = this.createItemCooldowns();
    private Optional<GlobalPos> lastDeathLocation = Optional.empty();
    @Nullable
    public FishingHook fishing;
    protected float hurtDir;
    @Nullable
    public Vec3 currentImpulseImpactPos;
    @Nullable
    public Entity currentExplosionCause;
    private boolean ignoreFallDamageFromCurrentImpulse = false;
    private int currentImpulseContextResetGraceTime = 0;
    private final Collection<MutableComponent> prefixes = new LinkedList<MutableComponent>();
    private final Collection<MutableComponent> suffixes = new LinkedList<MutableComponent>();
    @Nullable
    private Pose forcedPose;
    private Component displayname = null;
    private final LazyOptional<IItemHandler> playerMainHandler;
    private final LazyOptional<IItemHandler> playerEquipmentHandler;
    private final LazyOptional<IItemHandler> playerJoinedHandler;

    public Player(Level p_250508_, GameProfile p_252153_) {
        super((EntityType<? extends LivingEntity>)EntityType.PLAYER, p_250508_);
        this.setUUID(p_252153_.id());
        this.gameProfile = p_252153_;
        this.inventory = new Inventory(this, this.equipment);
        this.inventoryMenu = new InventoryMenu(this.inventory, !p_250508_.isClientSide(), this);
        this.containerMenu = this.inventoryMenu;
        this.playerMainHandler = LazyOptional.of(() -> new PlayerMainInvWrapper(this.inventory));
        this.playerEquipmentHandler = LazyOptional.of(() -> new PlayerEquipmentInvWrapper(this.inventory));
        this.playerJoinedHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{new PlayerMainInvWrapper(this.inventory), new PlayerEquipmentInvWrapper(this.inventory)}));
    }

    @Override
    protected EntityEquipment createEquipment() {
        return new PlayerEquipment(this);
    }

    public boolean blockActionRestricted(Level p_36188_, BlockPos p_36189_, GameType p_36190_) {
        if (!p_36190_.isBlockPlacingRestricted()) {
            return false;
        }
        if (p_36190_ == GameType.SPECTATOR) {
            return true;
        }
        if (this.mayBuild()) {
            return false;
        }
        ItemStack itemstack = this.getMainHandItem();
        return itemstack.isEmpty() || !itemstack.canBreakBlockInAdventureMode(new BlockInWorld(p_36188_, p_36189_, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, 0.1f).add(Attributes.ATTACK_SPEED).add(Attributes.LUCK).add(Attributes.BLOCK_INTERACTION_RANGE, 4.5).add(Attributes.ENTITY_INTERACTION_RANGE, 3.0).add(Attributes.BLOCK_BREAK_SPEED).add(Attributes.SUBMERGED_MINING_SPEED).add(Attributes.SNEAKING_SPEED).add(Attributes.MINING_EFFICIENCY).add(Attributes.SWEEPING_DAMAGE_RATIO).add(Attributes.WAYPOINT_TRANSMIT_RANGE, 6.0E7).add(Attributes.WAYPOINT_RECEIVE_RANGE, 6.0E7).add(Attributes.ATTACK_KNOCKBACK);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_335298_) {
        super.defineSynchedData(p_335298_);
        p_335298_.define(DATA_PLAYER_ABSORPTION_ID, Float.valueOf(0.0f));
        p_335298_.define(DATA_SCORE_ID, 0);
        p_335298_.define(DATA_SHOULDER_PARROT_LEFT, OptionalInt.empty());
        p_335298_.define(DATA_SHOULDER_PARROT_RIGHT, OptionalInt.empty());
    }

    @Override
    public void tick() {
        ForgeEventFactory.onPlayerPreTick((Player)this);
        this.noPhysics = this.isSpectator();
        if (this.isSpectator() || this.isPassenger()) {
            this.setOnGround(false);
        }
        if (this.takeXpDelay > 0) {
            --this.takeXpDelay;
        }
        if (this.isSleeping()) {
            ++this.sleepCounter;
            if (this.sleepCounter > 100) {
                this.sleepCounter = 100;
            }
            if (!this.level().isClientSide() && !ForgeEventFactory.onSleepingTimeCheck((Player)this, this.getSleepingPos())) {
                this.stopSleepInBed(false, true);
            }
        } else if (this.sleepCounter > 0) {
            ++this.sleepCounter;
            if (this.sleepCounter >= 110) {
                this.sleepCounter = 0;
            }
        }
        this.updateIsUnderwater();
        super.tick();
        int i = 29999999;
        double d0 = Mth.clamp(this.getX(), -2.9999999E7, 2.9999999E7);
        double d1 = Mth.clamp(this.getZ(), -2.9999999E7, 2.9999999E7);
        if (d0 != this.getX() || d1 != this.getZ()) {
            this.setPos(d0, this.getY(), d1);
        }
        ++this.attackStrengthTicker;
        ItemStack itemstack = this.getMainHandItem();
        if (!ItemStack.matches(this.lastItemInMainHand, itemstack)) {
            if (!ItemStack.isSameItem(this.lastItemInMainHand, itemstack)) {
                this.resetAttackStrengthTicker();
            }
            this.lastItemInMainHand = itemstack.copy();
        }
        if (!this.isEyeInFluid(FluidTags.WATER) && this.isEquipped(Items.TURTLE_HELMET)) {
            this.turtleHelmetTick();
        }
        this.cooldowns.tick();
        this.updatePlayerPose();
        if (this.currentImpulseContextResetGraceTime > 0) {
            --this.currentImpulseContextResetGraceTime;
        }
        ForgeEventFactory.onPlayerPostTick((Player)this);
    }

    @Override
    protected float getMaxHeadRotationRelativeToBody() {
        return this.isBlocking() ? 15.0f : super.getMaxHeadRotationRelativeToBody();
    }

    public boolean isSecondaryUseActive() {
        return this.isShiftKeyDown();
    }

    protected boolean wantsToStopRiding() {
        return this.isShiftKeyDown();
    }

    protected boolean isStayingOnGroundSurface() {
        return this.isShiftKeyDown();
    }

    protected boolean updateIsUnderwater() {
        this.wasUnderwater = this.isEyeInFluid(FluidTags.WATER);
        return this.wasUnderwater;
    }

    @Override
    public void onAboveBubbleColumn(boolean p_397973_, BlockPos p_391484_) {
        if (!this.getAbilities().flying) {
            super.onAboveBubbleColumn(p_397973_, p_391484_);
        }
    }

    @Override
    public void onInsideBubbleColumn(boolean p_369072_) {
        if (!this.getAbilities().flying) {
            super.onInsideBubbleColumn(p_369072_);
        }
    }

    private void turtleHelmetTick() {
        this.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 200, 0, false, false, true));
    }

    private boolean isEquipped(Item p_365145_) {
        for (EquipmentSlot equipmentslot : EquipmentSlot.VALUES) {
            ItemStack itemstack = this.getItemBySlot(equipmentslot);
            Equippable equippable = (Equippable)itemstack.get(DataComponents.EQUIPPABLE);
            if (!itemstack.is(p_365145_) || equippable == null || equippable.slot() != equipmentslot) continue;
            return true;
        }
        return false;
    }

    protected ItemCooldowns createItemCooldowns() {
        return new ItemCooldowns();
    }

    protected void updatePlayerPose() {
        if (this.forcedPose != null) {
            this.setPose(this.forcedPose);
            return;
        }
        if (this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.SWIMMING)) {
            Pose pose = this.getDesiredPose();
            Pose pose1 = this.isSpectator() || this.isPassenger() || this.canPlayerFitWithinBlocksAndEntitiesWhen(pose) ? pose : (this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.CROUCHING) ? Pose.CROUCHING : Pose.SWIMMING);
            this.setPose(pose1);
        }
    }

    private Pose getDesiredPose() {
        if (this.isSleeping()) {
            return Pose.SLEEPING;
        }
        if (this.isSwimming()) {
            return Pose.SWIMMING;
        }
        if (this.isFallFlying()) {
            return Pose.FALL_FLYING;
        }
        if (this.isAutoSpinAttack()) {
            return Pose.SPIN_ATTACK;
        }
        return this.isShiftKeyDown() && !this.abilities.flying ? Pose.CROUCHING : Pose.STANDING;
    }

    protected boolean canPlayerFitWithinBlocksAndEntitiesWhen(Pose p_297636_) {
        return this.level().noCollision(this, this.getDimensions(p_297636_).makeBoundingBox(this.position()).deflate(1.0E-7));
    }

    @Override
    protected SoundEvent getSwimSound() {
        return SoundEvents.PLAYER_SWIM;
    }

    @Override
    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.PLAYER_SPLASH;
    }

    @Override
    protected SoundEvent getSwimHighSpeedSplashSound() {
        return SoundEvents.PLAYER_SPLASH_HIGH_SPEED;
    }

    @Override
    public int getDimensionChangingDelay() {
        return 10;
    }

    @Override
    public void playSound(SoundEvent p_36137_, float p_36138_, float p_36139_) {
        this.level().playSound((Entity)this, this.getX(), this.getY(), this.getZ(), p_36137_, this.getSoundSource(), p_36138_, p_36139_);
    }

    public void playNotifySound(SoundEvent p_36140_, SoundSource p_36141_, float p_36142_, float p_36143_) {
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.PLAYERS;
    }

    @Override
    protected int getFireImmuneTicks() {
        return 20;
    }

    @Override
    public void handleEntityEvent(byte p_36120_) {
        if (p_36120_ == 9) {
            this.completeUsingItem();
        } else if (p_36120_ == 23) {
            this.setReducedDebugInfo(false);
        } else if (p_36120_ == 22) {
            this.setReducedDebugInfo(true);
        } else {
            super.handleEntityEvent(p_36120_);
        }
    }

    public void closeContainer() {
        this.containerMenu = this.inventoryMenu;
    }

    protected void doCloseContainer() {
    }

    @Override
    public void rideTick() {
        if (!this.level().isClientSide() && this.wantsToStopRiding() && this.isPassenger()) {
            this.stopRiding();
            this.setShiftKeyDown(false);
        } else {
            super.rideTick();
        }
    }

    @Override
    public void aiStep() {
        if (this.jumpTriggerTime > 0) {
            --this.jumpTriggerTime;
        }
        this.tickRegeneration();
        this.inventory.tick();
        if (this.abilities.flying && !this.isPassenger()) {
            this.resetFallDistance();
        }
        super.aiStep();
        this.updateSwingTime();
        this.yHeadRot = this.getYRot();
        this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
        if (this.getHealth() > 0.0f && !this.isSpectator()) {
            AABB aabb = this.isPassenger() && !this.getVehicle().isRemoved() ? this.getBoundingBox().minmax(this.getVehicle().getBoundingBox()).inflate(1.0, 0.0, 1.0) : this.getBoundingBox().inflate(1.0, 0.5, 1.0);
            List list = this.level().getEntities(this, aabb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.getType() == EntityType.EXPERIENCE_ORB) {
                    list1.add(entity);
                    continue;
                }
                if (entity.isRemoved()) continue;
                this.touch(entity);
            }
            if (!list1.isEmpty()) {
                this.touch((Entity)Util.getRandom(list1, this.random));
            }
        }
        this.handleShoulderEntities();
    }

    protected void tickRegeneration() {
    }

    public void handleShoulderEntities() {
    }

    protected void removeEntitiesOnShoulder() {
    }

    private void touch(Entity p_36278_) {
        p_36278_.playerTouch(this);
    }

    public int getScore() {
        return this.entityData.get(DATA_SCORE_ID);
    }

    public void setScore(int p_36398_) {
        this.entityData.set(DATA_SCORE_ID, p_36398_);
    }

    public void increaseScore(int p_36402_) {
        int i = this.getScore();
        this.entityData.set(DATA_SCORE_ID, i + p_36402_);
    }

    public void startAutoSpinAttack(int p_204080_, float p_344736_, ItemStack p_343326_) {
        this.autoSpinAttackTicks = p_204080_;
        this.autoSpinAttackDmg = p_344736_;
        this.autoSpinAttackItemStack = p_343326_;
        if (!this.level().isClientSide()) {
            this.removeEntitiesOnShoulder();
            this.setLivingEntityFlag(4, true);
        }
    }

    @Override
    @Nonnull
    public ItemStack getWeaponItem() {
        return this.isAutoSpinAttack() && this.autoSpinAttackItemStack != null ? this.autoSpinAttackItemStack : super.getWeaponItem();
    }

    @Override
    public void die(DamageSource p_36152_) {
        Level level;
        if (ForgeEventFactory.onLivingDeath((LivingEntity)this, (DamageSource)p_36152_)) {
            return;
        }
        super.die(p_36152_);
        this.reapplyPosition();
        if (!this.isSpectator() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.dropAllDeathLoot(serverlevel, p_36152_);
        }
        if (p_36152_ != null) {
            this.setDeltaMovement(-Mth.cos((this.getHurtDir() + this.getYRot()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -Mth.sin((this.getHurtDir() + this.getYRot()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.setDeltaMovement(0.0, 0.1, 0.0);
        }
        this.awardStat(Stats.DEATHS);
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_DEATH));
        this.resetStat(Stats.CUSTOM.get(Stats.TIME_SINCE_REST));
        this.clearFire();
        this.setSharedFlagOnFire(false);
        this.setLastDeathLocation(Optional.of(GlobalPos.of(this.level().dimension(), this.blockPosition())));
    }

    @Override
    protected void dropEquipment(ServerLevel p_369623_) {
        super.dropEquipment(p_369623_);
        if (!p_369623_.getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            this.destroyVanishingCursedItems();
            this.inventory.dropAll();
        }
    }

    protected void destroyVanishingCursedItems() {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty() || !EnchantmentHelper.has(itemstack, EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.inventory.removeItemNoUpdate(i);
        }
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_36310_) {
        return p_36310_.type().effects().sound();
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.PLAYER_DEATH;
    }

    public void handleCreativeModeItemDrop(ItemStack p_369068_) {
    }

    @Nullable
    public ItemEntity drop(ItemStack p_36177_, boolean p_36178_) {
        return ForgeHooks.onPlayerTossEvent((Player)this, (ItemStack)p_36177_, (boolean)p_36178_);
    }

    public float getDestroySpeed(BlockState p_36282_) {
        return this.getDestroySpeed(p_36282_, null);
    }

    public float getDestroySpeed(BlockState p_36282_, @Nullable BlockPos pos) {
        float f = this.inventory.getSelectedItem().getDestroySpeed(p_36282_);
        if (f > 1.0f) {
            f += (float)this.getAttributeValue(Attributes.MINING_EFFICIENCY);
        }
        if (MobEffectUtil.hasDigSpeed(this)) {
            f *= 1.0f + (float)(MobEffectUtil.getDigSpeedAmplification(this) + 1) * 0.2f;
        }
        if (this.hasEffect(MobEffects.MINING_FATIGUE)) {
            float f1 = switch (this.getEffect(MobEffects.MINING_FATIGUE).getAmplifier()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            f *= f1;
        }
        f *= (float)this.getAttributeValue(Attributes.BLOCK_BREAK_SPEED);
        if (this.isEyeInFluid(FluidTags.WATER)) {
            f *= (float)this.getAttribute(Attributes.SUBMERGED_MINING_SPEED).getValue();
        }
        if (!this.onGround()) {
            f /= 5.0f;
        }
        f = ForgeEventFactory.getBreakSpeed((Player)this, (BlockState)p_36282_, (float)f, (BlockPos)pos);
        return f;
    }

    public boolean hasCorrectToolForDrops(BlockState p_36299_) {
        boolean vanilla = !p_36299_.requiresCorrectToolForDrops() || this.inventory.getSelectedItem().isCorrectToolForDrops(p_36299_);
        return ForgeEventFactory.doPlayerHarvestCheck((Player)this, (BlockState)p_36299_, (boolean)vanilla);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_410352_) {
        super.readAdditionalSaveData(p_410352_);
        this.setUUID(this.gameProfile.id());
        this.inventory.load(p_410352_.listOrEmpty("Inventory", ItemStackWithSlot.CODEC));
        this.inventory.setSelectedSlot(p_410352_.getIntOr("SelectedItemSlot", 0));
        this.sleepCounter = p_410352_.getShortOr("SleepTimer", (short)0);
        this.experienceProgress = p_410352_.getFloatOr("XpP", 0.0f);
        this.experienceLevel = p_410352_.getIntOr("XpLevel", 0);
        this.totalExperience = p_410352_.getIntOr("XpTotal", 0);
        this.enchantmentSeed = p_410352_.getIntOr("XpSeed", 0);
        if (this.enchantmentSeed == 0) {
            this.enchantmentSeed = this.random.nextInt();
        }
        this.setScore(p_410352_.getIntOr("Score", 0));
        this.foodData.readAdditionalSaveData(p_410352_);
        p_410352_.read("abilities", Abilities.Packed.CODEC).ifPresent(this.abilities::apply);
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(this.abilities.getWalkingSpeed());
        this.enderChestInventory.fromSlots(p_410352_.listOrEmpty("EnderItems", ItemStackWithSlot.CODEC));
        this.setLastDeathLocation(p_410352_.read("LastDeathLocation", GlobalPos.CODEC));
        this.currentImpulseImpactPos = p_410352_.read("current_explosion_impact_pos", Vec3.CODEC).orElse(null);
        this.ignoreFallDamageFromCurrentImpulse = p_410352_.getBooleanOr("ignore_fall_damage_from_current_explosion", false);
        this.currentImpulseContextResetGraceTime = p_410352_.getIntOr("current_impulse_context_reset_grace_time", 0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_406026_) {
        super.addAdditionalSaveData(p_406026_);
        NbtUtils.addCurrentDataVersion(p_406026_);
        this.inventory.save(p_406026_.list("Inventory", ItemStackWithSlot.CODEC));
        p_406026_.putInt("SelectedItemSlot", this.inventory.getSelectedSlot());
        p_406026_.putShort("SleepTimer", (short)this.sleepCounter);
        p_406026_.putFloat("XpP", this.experienceProgress);
        p_406026_.putInt("XpLevel", this.experienceLevel);
        p_406026_.putInt("XpTotal", this.totalExperience);
        p_406026_.putInt("XpSeed", this.enchantmentSeed);
        p_406026_.putInt("Score", this.getScore());
        this.foodData.addAdditionalSaveData(p_406026_);
        p_406026_.store("abilities", Abilities.Packed.CODEC, this.abilities.pack());
        this.enderChestInventory.storeAsSlots(p_406026_.list("EnderItems", ItemStackWithSlot.CODEC));
        this.lastDeathLocation.ifPresent(p_405554_ -> p_406026_.store("LastDeathLocation", GlobalPos.CODEC, p_405554_));
        p_406026_.storeNullable("current_explosion_impact_pos", Vec3.CODEC, this.currentImpulseImpactPos);
        p_406026_.putBoolean("ignore_fall_damage_from_current_explosion", this.ignoreFallDamageFromCurrentImpulse);
        p_406026_.putInt("current_impulse_context_reset_grace_time", this.currentImpulseContextResetGraceTime);
    }

    @Override
    public boolean isInvulnerableTo(ServerLevel p_360775_, DamageSource p_36249_) {
        if (super.isInvulnerableTo(p_360775_, p_36249_)) {
            return true;
        }
        if (p_36249_.is(DamageTypeTags.IS_DROWNING)) {
            return !p_360775_.getGameRules().getBoolean(GameRules.RULE_DROWNING_DAMAGE);
        }
        if (p_36249_.is(DamageTypeTags.IS_FALL)) {
            return !p_360775_.getGameRules().getBoolean(GameRules.RULE_FALL_DAMAGE);
        }
        if (p_36249_.is(DamageTypeTags.IS_FIRE)) {
            return !p_360775_.getGameRules().getBoolean(GameRules.RULE_FIRE_DAMAGE);
        }
        return p_36249_.is(DamageTypeTags.IS_FREEZING) ? !p_360775_.getGameRules().getBoolean(GameRules.RULE_FREEZE_DAMAGE) : false;
    }

    @Override
    public boolean hurtServer(ServerLevel p_369360_, DamageSource p_364544_, float p_368576_) {
        if (!ForgeHooks.onPlayerAttack((LivingEntity)this, (DamageSource)p_364544_, (float)p_368576_)) {
            return false;
        }
        if (this.isInvulnerableTo(p_369360_, p_364544_)) {
            return false;
        }
        if (this.abilities.invulnerable && !p_364544_.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        this.noActionTime = 0;
        if (this.isDeadOrDying()) {
            return false;
        }
        this.removeEntitiesOnShoulder();
        if (p_364544_.scalesWithDifficulty()) {
            if (p_369360_.getDifficulty() == Difficulty.PEACEFUL) {
                p_368576_ = 0.0f;
            }
            if (p_369360_.getDifficulty() == Difficulty.EASY) {
                p_368576_ = Math.min(p_368576_ / 2.0f + 1.0f, p_368576_);
            }
            if (p_369360_.getDifficulty() == Difficulty.HARD) {
                p_368576_ = p_368576_ * 3.0f / 2.0f;
            }
        }
        return p_368576_ == 0.0f ? false : super.hurtServer(p_369360_, p_364544_, p_368576_);
    }

    @Override
    protected void blockUsingItem(ServerLevel p_395321_, LivingEntity p_395720_) {
        super.blockUsingItem(p_395321_, p_395720_);
        ItemStack itemstack = this.getItemBlockingWith();
        BlocksAttacks blocksattacks = itemstack != null ? (BlocksAttacks)itemstack.get(DataComponents.BLOCKS_ATTACKS) : null;
        float f = p_395720_.getSecondsToDisableBlocking();
        if (f > 0.0f && blocksattacks != null) {
            blocksattacks.disable(p_395321_, this, f, itemstack);
        }
    }

    @Override
    public boolean canBeSeenAsEnemy() {
        return !this.getAbilities().invulnerable && super.canBeSeenAsEnemy();
    }

    public boolean canHarmPlayer(Player p_36169_) {
        PlayerTeam team = this.getTeam();
        PlayerTeam team1 = p_36169_.getTeam();
        if (team == null) {
            return true;
        }
        return !team.isAlliedTo(team1) ? true : ((Team)team).isAllowFriendlyFire();
    }

    @Override
    protected void hurtArmor(DamageSource p_36251_, float p_36252_) {
        this.doHurtEquipment(p_36251_, p_36252_, EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD);
    }

    @Override
    protected void hurtHelmet(DamageSource p_150103_, float p_150104_) {
        this.doHurtEquipment(p_150103_, p_150104_, EquipmentSlot.HEAD);
    }

    @Override
    protected void actuallyHurt(ServerLevel p_365751_, DamageSource p_36312_, float p_36313_) {
        if (!this.isInvulnerableTo(p_365751_, p_36312_)) {
            if ((p_36313_ = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)p_36312_, (float)p_36313_)) <= 0.0f) {
                return;
            }
            p_36313_ = this.getDamageAfterArmorAbsorb(p_36312_, p_36313_);
            p_36313_ = this.getDamageAfterMagicAbsorb(p_36312_, p_36313_);
            float f1 = Math.max(p_36313_ - this.getAbsorptionAmount(), 0.0f);
            this.setAbsorptionAmount(this.getAbsorptionAmount() - (p_36313_ - f1));
            f1 = ForgeHooks.onLivingDamage((LivingEntity)this, (DamageSource)p_36312_, (float)f1);
            float f = p_36313_ - f1;
            if (f > 0.0f && f < 3.4028235E37f) {
                this.awardStat(Stats.DAMAGE_ABSORBED, Math.round(f * 10.0f));
            }
            if (f1 != 0.0f) {
                this.causeFoodExhaustion(p_36312_.getFoodExhaustion());
                this.getCombatTracker().recordDamage(p_36312_, f1);
                this.setHealth(this.getHealth() - f1);
                if (f1 < 3.4028235E37f) {
                    this.awardStat(Stats.DAMAGE_TAKEN, Math.round(f1 * 10.0f));
                }
                this.gameEvent(GameEvent.ENTITY_DAMAGE);
            }
        }
    }

    public boolean isTextFilteringEnabled() {
        return false;
    }

    public void openTextEdit(SignBlockEntity p_36193_, boolean p_277837_) {
    }

    public void openMinecartCommandBlock(BaseCommandBlock p_36182_) {
    }

    public void openCommandBlock(CommandBlockEntity p_36191_) {
    }

    public void openStructureBlock(StructureBlockEntity p_36194_) {
    }

    public void openTestBlock(TestBlockEntity p_396402_) {
    }

    public void openTestInstanceBlock(TestInstanceBlockEntity p_391756_) {
    }

    public void openJigsawBlock(JigsawBlockEntity p_36192_) {
    }

    public void openHorseInventory(AbstractHorse p_36167_, Container p_36168_) {
    }

    public OptionalInt openMenu(@Nullable MenuProvider p_36150_) {
        return OptionalInt.empty();
    }

    public void openDialog(Holder<Dialog> p_410470_) {
    }

    public void sendMerchantOffers(int p_36121_, MerchantOffers p_36122_, int p_36123_, int p_36124_, boolean p_36125_, boolean p_36126_) {
    }

    public void openItemGui(ItemStack p_36174_, InteractionHand p_36175_) {
    }

    public InteractionResult interactOn(Entity p_36158_, InteractionHand p_36159_) {
        if (this.isSpectator()) {
            if (p_36158_ instanceof MenuProvider) {
                this.openMenu((MenuProvider)((Object)p_36158_));
            }
            return InteractionResult.PASS;
        }
        PlayerInteractEvent.EntityInteract event = new PlayerInteractEvent.EntityInteract(this, p_36159_, p_36158_);
        if (PlayerInteractEvent.EntityInteract.BUS.post((Event)event)) {
            return event.getCancellationResult();
        }
        ItemStack itemstack = this.getItemInHand(p_36159_);
        ItemStack itemstack1 = itemstack.copy();
        InteractionResult interactionresult = p_36158_.interact(this, p_36159_);
        if (interactionresult.consumesAction()) {
            if (this.hasInfiniteMaterials() && itemstack == this.getItemInHand(p_36159_) && itemstack.getCount() < itemstack1.getCount()) {
                itemstack.setCount(itemstack1.getCount());
            }
            if (!this.abilities.instabuild && itemstack.isEmpty()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)this, (ItemStack)itemstack1, (EquipmentSlot)p_36159_.asEquipmentSlot());
            }
            return interactionresult;
        }
        if (!itemstack.isEmpty() && p_36158_ instanceof LivingEntity) {
            InteractionResult interactionresult1;
            if (this.hasInfiniteMaterials()) {
                itemstack = itemstack1;
            }
            if ((interactionresult1 = itemstack.interactLivingEntity(this, (LivingEntity)p_36158_, p_36159_)).consumesAction()) {
                this.level().gameEvent(GameEvent.ENTITY_INTERACT, p_36158_.position(), GameEvent.Context.of(this));
                if (itemstack.isEmpty() && !this.hasInfiniteMaterials()) {
                    ForgeEventFactory.onPlayerDestroyItem((Player)this, (ItemStack)itemstack1, (EquipmentSlot)p_36159_.asEquipmentSlot());
                    this.setItemInHand(p_36159_, ItemStack.EMPTY);
                }
                return interactionresult1;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void removeVehicle() {
        super.removeVehicle();
        this.boardingCooldown = 0;
    }

    @Override
    protected boolean isImmobile() {
        return super.isImmobile() || this.isSleeping();
    }

    @Override
    public boolean isAffectedByFluids() {
        return !this.abilities.flying;
    }

    @Override
    protected Vec3 maybeBackOffFromEdge(Vec3 p_36201_, MoverType p_36202_) {
        float f = this.maxUpStep();
        if (!this.abilities.flying && !(p_36201_.y > 0.0) && (p_36202_ == MoverType.SELF || p_36202_ == MoverType.PLAYER) && this.isStayingOnGroundSurface() && this.isAboveGround(f)) {
            double d0;
            double d1 = p_36201_.z;
            double d2 = 0.05;
            double d3 = Math.signum(d0) * 0.05;
            double d4 = Math.signum(d1) * 0.05;
            for (d0 = p_36201_.x; d0 != 0.0 && this.canFallAtLeast(d0, 0.0, f); d0 -= d3) {
                if (!(Math.abs(d0) <= 0.05)) continue;
                d0 = 0.0;
                break;
            }
            while (d1 != 0.0 && this.canFallAtLeast(0.0, d1, f)) {
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    break;
                }
                d1 -= d4;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.canFallAtLeast(d0, d1, f)) {
                d0 = Math.abs(d0) <= 0.05 ? 0.0 : (d0 -= d3);
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    continue;
                }
                d1 -= d4;
            }
            return new Vec3(d0, p_36201_.y, d1);
        }
        return p_36201_;
    }

    private boolean isAboveGround(float p_328745_) {
        return this.onGround() || this.fallDistance < (double)p_328745_ && !this.canFallAtLeast(0.0, 0.0, (double)p_328745_ - this.fallDistance);
    }

    private boolean canFallAtLeast(double p_333341_, double p_331138_, double p_396282_) {
        AABB aabb = this.getBoundingBox();
        return this.level().noCollision(this, new AABB(aabb.minX + 1.0E-7 + p_333341_, aabb.minY - p_396282_ - 1.0E-7, aabb.minZ + 1.0E-7 + p_331138_, aabb.maxX - 1.0E-7 + p_333341_, aabb.minY, aabb.maxZ - 1.0E-7 + p_331138_));
    }

    public void attack(Entity p_36347_) {
        if (!ForgeHooks.onPlayerAttackTarget((Player)this, (Entity)p_36347_)) {
            return;
        }
        if (p_36347_.isAttackable() && !p_36347_.skipAttackInteraction(this)) {
            Projectile projectile;
            float f = this.isAutoSpinAttack() ? this.autoSpinAttackDmg : (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
            ItemStack itemstack = this.getWeaponItem();
            DamageSource damagesource = Optional.ofNullable(itemstack.getItem().getDamageSource(this)).orElse(this.damageSources().playerAttack(this));
            float f1 = this.getEnchantedDamage(p_36347_, f, damagesource) - f;
            float f2 = this.getAttackStrengthScale(0.5f);
            f *= 0.2f + f2 * f2 * 0.8f;
            f1 *= f2;
            this.resetAttackStrengthTicker();
            if (p_36347_.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && p_36347_ instanceof Projectile && (projectile = (Projectile)p_36347_).deflect(ProjectileDeflection.AIM_DEFLECT, this, EntityReference.of(this), true)) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, this.getSoundSource());
            } else if (f > 0.0f || f1 > 0.0f) {
                double d1;
                double d0;
                boolean flag;
                boolean flag3;
                boolean bl = flag3 = f2 > 0.9f;
                if (this.isSprinting() && flag3) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_KNOCKBACK, this.getSoundSource(), 1.0f, 1.0f);
                    flag = true;
                } else {
                    flag = false;
                }
                f += itemstack.getItem().getAttackDamageBonus(p_36347_, f, damagesource);
                boolean flag1 = flag3 && this.fallDistance > 0.0 && !this.onGround() && !this.onClimbable() && !this.isInWater() && !this.isMobilityRestricted() && !this.isPassenger() && p_36347_ instanceof LivingEntity && !this.isSprinting();
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)this, (Entity)p_36347_, (boolean)flag1, (float)(flag1 ? 1.5f : 1.0f));
                boolean bl2 = flag1 = hitResult != null;
                if (flag1) {
                    f *= hitResult.getDamageModifier();
                }
                float f3 = f + f1;
                boolean flag2 = false;
                if (flag3 && !flag1 && !flag && this.onGround() && (d0 = this.getKnownMovement().horizontalDistanceSqr()) < Mth.square(d1 = (double)this.getSpeed() * 2.5) && this.getItemInHand(InteractionHand.MAIN_HAND).canPerformAction(ToolActions.SWORD_SWEEP)) {
                    flag2 = true;
                }
                float f5 = 0.0f;
                if (p_36347_ instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)p_36347_;
                    f5 = livingentity.getHealth();
                }
                Vec3 vec3 = p_36347_.getDeltaMovement();
                boolean flag4 = p_36347_.hurtOrSimulate(damagesource, f3);
                if (flag4) {
                    Object armorstand;
                    float f4 = this.getKnockback(p_36347_, damagesource) + (flag ? 1.0f : 0.0f);
                    if (f4 > 0.0f) {
                        if (p_36347_ instanceof LivingEntity) {
                            LivingEntity livingentity1 = (LivingEntity)p_36347_;
                            livingentity1.knockback(f4 * 0.5f, Mth.sin(this.getYRot() * ((float)Math.PI / 180)), -Mth.cos(this.getYRot() * ((float)Math.PI / 180)));
                        } else {
                            p_36347_.push(-Mth.sin(this.getYRot() * ((float)Math.PI / 180)) * f4 * 0.5f, 0.1, Mth.cos(this.getYRot() * ((float)Math.PI / 180)) * f4 * 0.5f);
                        }
                        this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
                        this.setSprinting(false);
                    }
                    if (flag2) {
                        float f6 = 1.0f + (float)this.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) * f;
                        for (LivingEntity livingentity2 : this.level().getEntitiesOfClass(LivingEntity.class, this.getItemInHand(InteractionHand.MAIN_HAND).getSweepHitBox(this, p_36347_))) {
                            ServerLevel serverlevel;
                            if (livingentity2 == this || livingentity2 == p_36347_ || this.isAlliedTo(livingentity2) || livingentity2 instanceof ArmorStand && ((ArmorStand)(armorstand = (ArmorStand)livingentity2)).isMarker() || !(this.distanceToSqr(livingentity2) < 9.0)) continue;
                            float f8 = this.getEnchantedDamage(livingentity2, f6, damagesource) * f2;
                            Level level = this.level();
                            if (!(level instanceof ServerLevel) || !livingentity2.hurtServer(serverlevel = (ServerLevel)level, damagesource, f8)) continue;
                            livingentity2.knockback(0.4f, Mth.sin(this.getYRot() * ((float)Math.PI / 180)), -Mth.cos(this.getYRot() * ((float)Math.PI / 180)));
                            EnchantmentHelper.doPostAttackEffects(serverlevel, livingentity2, damagesource);
                        }
                        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, this.getSoundSource(), 1.0f, 1.0f);
                        this.sweepAttack();
                    }
                    if (p_36347_ instanceof ServerPlayer && p_36347_.hurtMarked) {
                        ((ServerPlayer)p_36347_).connection.send(new ClientboundSetEntityMotionPacket(p_36347_));
                        p_36347_.hurtMarked = false;
                        p_36347_.setDeltaMovement(vec3);
                    }
                    if (flag1) {
                        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, this.getSoundSource(), 1.0f, 1.0f);
                        this.crit(p_36347_);
                    }
                    if (!flag1 && !flag2) {
                        if (flag3) {
                            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_STRONG, this.getSoundSource(), 1.0f, 1.0f);
                        } else {
                            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_WEAK, this.getSoundSource(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.magicCrit(p_36347_);
                    }
                    this.setLastHurtMob(p_36347_);
                    Entity entity = p_36347_;
                    if (p_36347_ instanceof PartEntity) {
                        PartEntity pe = (PartEntity)p_36347_;
                        entity = pe.getParent();
                    }
                    boolean flag5 = false;
                    armorstand = this.level();
                    if (armorstand instanceof ServerLevel) {
                        ServerLevel serverlevel1 = (ServerLevel)armorstand;
                        if (entity instanceof LivingEntity) {
                            LivingEntity livingentity3 = (LivingEntity)entity;
                            flag5 = itemstack.hurtEnemy(livingentity3, this);
                        }
                        EnchantmentHelper.doPostAttackEffects(serverlevel1, p_36347_, damagesource);
                    }
                    if (!this.level().isClientSide() && !itemstack.isEmpty() && entity instanceof LivingEntity) {
                        if (flag5) {
                            itemstack.postHurtEnemy((LivingEntity)entity, this);
                        }
                        if (itemstack.isEmpty()) {
                            if (itemstack == this.getMainHandItem()) {
                                this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                            } else {
                                this.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
                            }
                        }
                    }
                    if (p_36347_ instanceof LivingEntity) {
                        float f7 = f5 - ((LivingEntity)p_36347_).getHealth();
                        this.awardStat(Stats.DAMAGE_DEALT, Math.round(f7 * 10.0f));
                        if (this.level() instanceof ServerLevel && f7 > 2.0f) {
                            int i = (int)((double)f7 * 0.5);
                            ((ServerLevel)this.level()).sendParticles(ParticleTypes.DAMAGE_INDICATOR, p_36347_.getX(), p_36347_.getY(0.5), p_36347_.getZ(), i, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(0.1f);
                } else {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_NODAMAGE, this.getSoundSource(), 1.0f, 1.0f);
                }
            }
            this.resetAttackStrengthTicker();
        }
    }

    protected float getEnchantedDamage(Entity p_344881_, float p_345044_, DamageSource p_343261_) {
        return p_345044_;
    }

    @Override
    protected void doAutoAttackOnTouch(LivingEntity p_36355_) {
        this.attack(p_36355_);
    }

    public void crit(Entity p_36156_) {
    }

    public void magicCrit(Entity p_36253_) {
    }

    public void sweepAttack() {
        double d0 = -Mth.sin(this.getYRot() * ((float)Math.PI / 180));
        double d1 = Mth.cos(this.getYRot() * ((float)Math.PI / 180));
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles(ParticleTypes.SWEEP_ATTACK, this.getX() + d0, this.getY(0.5), this.getZ() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public void respawn() {
    }

    @Override
    public void remove(Entity.RemovalReason p_150097_) {
        super.remove(p_150097_);
        this.inventoryMenu.removed(this);
        if (this.hasContainerOpen()) {
            this.doCloseContainer();
        }
    }

    @Override
    public boolean isClientAuthoritative() {
        return true;
    }

    @Override
    protected boolean isLocalClientAuthoritative() {
        return this.isLocalPlayer();
    }

    public boolean isLocalPlayer() {
        return false;
    }

    @Override
    public boolean canSimulateMovement() {
        return !this.level().isClientSide() || this.isLocalPlayer();
    }

    @Override
    public boolean isEffectiveAi() {
        return !this.level().isClientSide() || this.isLocalPlayer();
    }

    public GameProfile getGameProfile() {
        return this.gameProfile;
    }

    public NameAndId nameAndId() {
        return new NameAndId(this.gameProfile);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Abilities getAbilities() {
        return this.abilities;
    }

    @Override
    public boolean hasInfiniteMaterials() {
        return this.abilities.instabuild;
    }

    public boolean preventsBlockDrops() {
        return this.abilities.instabuild;
    }

    public void updateTutorialInventoryAction(ItemStack p_150098_, ItemStack p_150099_, ClickAction p_150100_) {
    }

    public boolean hasContainerOpen() {
        return this.containerMenu != this.inventoryMenu;
    }

    public boolean canDropItems() {
        return true;
    }

    public Either<BedSleepingProblem, Unit> startSleepInBed(BlockPos p_36203_) {
        this.startSleeping(p_36203_);
        this.sleepCounter = 0;
        return Either.right((Object)((Object)Unit.INSTANCE));
    }

    public void stopSleepInBed(boolean p_36226_, boolean p_36227_) {
        ForgeEventFactory.onPlayerWakeup((Player)this, (boolean)p_36226_, (boolean)p_36227_);
        super.stopSleeping();
        if (this.level() instanceof ServerLevel && p_36227_) {
            ((ServerLevel)this.level()).updateSleepingPlayerList();
        }
        this.sleepCounter = p_36226_ ? 0 : 100;
    }

    @Override
    public void stopSleeping() {
        this.stopSleepInBed(true, true);
    }

    public boolean isSleepingLongEnough() {
        return this.isSleeping() && this.sleepCounter >= 100;
    }

    public int getSleepTimer() {
        return this.sleepCounter;
    }

    public void displayClientMessage(Component p_36216_, boolean p_36217_) {
    }

    public void awardStat(ResourceLocation p_36221_) {
        this.awardStat(Stats.CUSTOM.get(p_36221_));
    }

    public void awardStat(ResourceLocation p_36223_, int p_36224_) {
        this.awardStat(Stats.CUSTOM.get(p_36223_), p_36224_);
    }

    public void awardStat(Stat<?> p_36247_) {
        this.awardStat(p_36247_, 1);
    }

    public void awardStat(Stat<?> p_36145_, int p_36146_) {
    }

    public void resetStat(Stat<?> p_36144_) {
    }

    public int awardRecipes(Collection<RecipeHolder<?>> p_36213_) {
        return 0;
    }

    public void triggerRecipeCrafted(RecipeHolder<?> p_298309_, List<ItemStack> p_283609_) {
    }

    public void awardRecipesByKey(List<ResourceKey<Recipe<?>>> p_312830_) {
    }

    public int resetRecipes(Collection<RecipeHolder<?>> p_36263_) {
        return 0;
    }

    @Override
    public void travel(Vec3 p_36359_) {
        if (this.isPassenger()) {
            super.travel(p_36359_);
        } else {
            if (this.isSwimming()) {
                double d1;
                double d0 = this.getLookAngle().y;
                double d = d1 = d0 < -0.2 ? 0.085 : 0.06;
                if (d0 <= 0.0 || this.jumping || !this.level().getFluidState(BlockPos.containing(this.getX(), this.getY() + 1.0 - 0.1, this.getZ())).isEmpty()) {
                    Vec3 vec3 = this.getDeltaMovement();
                    this.setDeltaMovement(vec3.add(0.0, (d0 - vec3.y) * d1, 0.0));
                }
            }
            if (this.getAbilities().flying) {
                double d2 = this.getDeltaMovement().y;
                super.travel(p_36359_);
                this.setDeltaMovement(this.getDeltaMovement().with(Direction.Axis.Y, d2 * 0.6));
            } else {
                super.travel(p_36359_);
            }
        }
    }

    @Override
    protected boolean canGlide() {
        return !this.abilities.flying && super.canGlide();
    }

    @Override
    public void updateSwimming() {
        if (this.abilities.flying) {
            this.setSwimming(false);
        } else {
            super.updateSwimming();
        }
    }

    protected boolean freeAt(BlockPos p_36351_) {
        return !this.level().getBlockState(p_36351_).isSuffocating(this.level(), p_36351_);
    }

    @Override
    public float getSpeed() {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    @Override
    public boolean causeFallDamage(double p_391627_, float p_150093_, DamageSource p_150095_) {
        double d0;
        boolean flag;
        if (this.abilities.mayfly) {
            ForgeEventFactory.onPlayerFall((Player)this, (float)p_150093_, (float)p_150093_);
            return false;
        }
        if (p_391627_ >= 2.0) {
            this.awardStat(Stats.FALL_ONE_CM, (int)Math.round(p_391627_ * 100.0));
        }
        boolean bl = flag = this.currentImpulseImpactPos != null && this.ignoreFallDamageFromCurrentImpulse;
        if (flag) {
            boolean flag1;
            d0 = Math.min(p_391627_, this.currentImpulseImpactPos.y - this.getY());
            boolean bl2 = flag1 = d0 <= 0.0;
            if (flag1) {
                this.resetCurrentImpulseContext();
            } else {
                this.tryResetCurrentImpulseContext();
            }
        } else {
            d0 = p_391627_;
        }
        if (d0 > 0.0 && super.causeFallDamage(d0, p_150093_, p_150095_)) {
            this.resetCurrentImpulseContext();
            return true;
        }
        this.propagateFallToPassengers(p_391627_, p_150093_, p_150095_);
        return false;
    }

    public boolean tryToStartFallFlying() {
        if (!this.isFallFlying() && this.canGlide() && !this.isInWater()) {
            this.startFallFlying();
            return true;
        }
        return false;
    }

    public void startFallFlying() {
        this.setSharedFlag(7, true);
    }

    @Override
    protected void doWaterSplashEffect() {
        if (!this.isSpectator()) {
            super.doWaterSplashEffect();
        }
    }

    @Override
    protected void playStepSound(BlockPos p_282121_, BlockState p_282194_) {
        if (this.isInWater()) {
            this.waterSwimSound();
            this.playMuffledStepSound(p_282194_, p_282121_);
        } else {
            BlockPos blockpos = this.getPrimaryStepSoundBlockPos(p_282121_);
            if (!p_282121_.equals(blockpos)) {
                BlockState blockstate = this.level().getBlockState(blockpos);
                if (blockstate.is(BlockTags.COMBINATION_STEP_SOUND_BLOCKS)) {
                    this.playCombinationStepSounds(blockstate, p_282194_, blockpos, p_282121_);
                } else {
                    super.playStepSound(blockpos, blockstate);
                }
            } else {
                super.playStepSound(p_282121_, p_282194_);
            }
        }
    }

    @Override
    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.PLAYER_SMALL_FALL, SoundEvents.PLAYER_BIG_FALL);
    }

    @Override
    public boolean killedEntity(ServerLevel p_219735_, LivingEntity p_219736_, DamageSource p_426979_) {
        this.awardStat(Stats.ENTITY_KILLED.get(p_219736_.getType()));
        return true;
    }

    @Override
    public void makeStuckInBlock(BlockState p_36196_, Vec3 p_36197_) {
        if (!this.abilities.flying) {
            super.makeStuckInBlock(p_36196_, p_36197_);
        }
        this.tryResetCurrentImpulseContext();
    }

    public void giveExperiencePoints(int p_36291_) {
        PlayerXpEvent.XpChange event = ForgeEventFactory.onPlayerXpChange((Player)this, (int)p_36291_);
        if (event == null) {
            return;
        }
        p_36291_ = event.getAmount();
        this.increaseScore(p_36291_);
        this.experienceProgress += (float)p_36291_ / (float)this.getXpNeededForNextLevel();
        this.totalExperience = Mth.clamp(this.totalExperience + p_36291_, 0, Integer.MAX_VALUE);
        while (this.experienceProgress < 0.0f) {
            float f = this.experienceProgress * (float)this.getXpNeededForNextLevel();
            if (this.experienceLevel > 0) {
                this.giveExperienceLevels(-1);
                this.experienceProgress = 1.0f + f / (float)this.getXpNeededForNextLevel();
                continue;
            }
            this.giveExperienceLevels(-1);
            this.experienceProgress = 0.0f;
        }
        while (this.experienceProgress >= 1.0f) {
            this.experienceProgress = (this.experienceProgress - 1.0f) * (float)this.getXpNeededForNextLevel();
            this.giveExperienceLevels(1);
            this.experienceProgress /= (float)this.getXpNeededForNextLevel();
        }
    }

    public int getEnchantmentSeed() {
        return this.enchantmentSeed;
    }

    public void onEnchantmentPerformed(ItemStack p_36172_, int p_36173_) {
        this.giveExperienceLevels(-p_36173_);
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experienceProgress = 0.0f;
            this.totalExperience = 0;
        }
        this.enchantmentSeed = this.random.nextInt();
    }

    public void giveExperienceLevels(int p_36276_) {
        PlayerXpEvent.LevelChange event = ForgeEventFactory.onPlayerLevelChange((Player)this, (int)p_36276_);
        if (event == null) {
            return;
        }
        p_36276_ = event.getLevels();
        this.experienceLevel = IntMath.saturatedAdd((int)this.experienceLevel, (int)p_36276_);
        if (this.experienceLevel < 0) {
            this.experienceLevel = 0;
            this.experienceProgress = 0.0f;
            this.totalExperience = 0;
        }
        if (p_36276_ > 0 && this.experienceLevel % 5 == 0 && (float)this.lastLevelUpTime < (float)this.tickCount - 100.0f) {
            float f = this.experienceLevel > 30 ? 1.0f : (float)this.experienceLevel / 30.0f;
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_LEVELUP, this.getSoundSource(), f * 0.75f, 1.0f);
            this.lastLevelUpTime = this.tickCount;
        }
    }

    public int getXpNeededForNextLevel() {
        if (this.experienceLevel >= 30) {
            return 112 + (this.experienceLevel - 30) * 9;
        }
        return this.experienceLevel >= 15 ? 37 + (this.experienceLevel - 15) * 5 : 7 + this.experienceLevel * 2;
    }

    public void causeFoodExhaustion(float p_36400_) {
        if (!this.abilities.invulnerable && !this.level().isClientSide()) {
            this.foodData.addExhaustion(p_36400_);
        }
    }

    public Optional<WardenSpawnTracker> getWardenSpawnTracker() {
        return Optional.empty();
    }

    public FoodData getFoodData() {
        return this.foodData;
    }

    public boolean canEat(boolean p_36392_) {
        return this.abilities.invulnerable || p_36392_ || this.foodData.needsFood();
    }

    public boolean isHurt() {
        return this.getHealth() > 0.0f && this.getHealth() < this.getMaxHealth();
    }

    public boolean mayBuild() {
        return this.abilities.mayBuild;
    }

    public boolean mayUseItemAt(BlockPos p_36205_, Direction p_36206_, ItemStack p_36207_) {
        if (this.abilities.mayBuild) {
            return true;
        }
        BlockPos blockpos = p_36205_.relative(p_36206_.getOpposite());
        BlockInWorld blockinworld = new BlockInWorld(this.level(), blockpos, false);
        return p_36207_.canPlaceOnBlockInAdventureMode(blockinworld);
    }

    @Override
    protected int getBaseExperienceReward(ServerLevel p_361105_) {
        return !p_361105_.getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) && !this.isSpectator() ? Math.min(this.experienceLevel * 7, 100) : 0;
    }

    @Override
    protected boolean isAlwaysExperienceDropper() {
        return true;
    }

    @Override
    public boolean shouldShowName() {
        return true;
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return this.abilities.flying || this.onGround() && this.isDiscrete() ? Entity.MovementEmission.NONE : Entity.MovementEmission.ALL;
    }

    public void onUpdateAbilities() {
    }

    @Override
    public Component getName() {
        return Component.literal(this.gameProfile.name());
    }

    @Override
    public String getPlainTextName() {
        return this.gameProfile.name();
    }

    public PlayerEnderChestContainer getEnderChestInventory() {
        return this.enderChestInventory;
    }

    @Override
    protected boolean doesEmitEquipEvent(EquipmentSlot p_219741_) {
        return p_219741_.getType() == EquipmentSlot.Type.HUMANOID_ARMOR;
    }

    public boolean addItem(ItemStack p_36357_) {
        return this.inventory.add(p_36357_);
    }

    @Nullable
    public abstract GameType gameMode();

    @Override
    public boolean isSpectator() {
        return this.gameMode() == GameType.SPECTATOR;
    }

    @Override
    public boolean canBeHitByProjectile() {
        return !this.isSpectator() && super.canBeHitByProjectile();
    }

    @Override
    public boolean isSwimming() {
        return !this.abilities.flying && !this.isSpectator() && super.isSwimming();
    }

    public boolean isCreative() {
        return this.gameMode() == GameType.CREATIVE;
    }

    @Override
    public boolean isPushedByFluid() {
        return !this.abilities.flying;
    }

    @Override
    public Component getDisplayName() {
        if (this.displayname == null) {
            this.displayname = ForgeEventFactory.getPlayerDisplayName((Player)this, (Component)this.getName());
        }
        MutableComponent mutablecomponent = Component.literal("");
        mutablecomponent = this.prefixes.stream().reduce(mutablecomponent, MutableComponent::append);
        mutablecomponent = mutablecomponent.append(PlayerTeam.formatNameForTeam(this.getTeam(), this.displayname));
        mutablecomponent = this.suffixes.stream().reduce(mutablecomponent, MutableComponent::append);
        return this.decorateDisplayNameComponent(mutablecomponent);
    }

    private MutableComponent decorateDisplayNameComponent(MutableComponent p_36219_) {
        String s = this.getGameProfile().name();
        return p_36219_.withStyle(p_421906_ -> p_421906_.withClickEvent(new ClickEvent.SuggestCommand("/tell " + s + " ")).withHoverEvent(this.createHoverEvent()).withInsertion(s));
    }

    @Override
    public String getScoreboardName() {
        return this.getGameProfile().name();
    }

    @Override
    protected void internalSetAbsorptionAmount(float p_301235_) {
        this.getEntityData().set(DATA_PLAYER_ABSORPTION_ID, Float.valueOf(p_301235_));
    }

    @Override
    public float getAbsorptionAmount() {
        return this.getEntityData().get(DATA_PLAYER_ABSORPTION_ID).floatValue();
    }

    @Override
    public SlotAccess getSlot(int p_150112_) {
        if (p_150112_ == 499) {
            return new SlotAccess(){

                @Override
                public ItemStack get() {
                    return Player.this.containerMenu.getCarried();
                }

                @Override
                public boolean set(ItemStack p_333834_) {
                    Player.this.containerMenu.setCarried(p_333834_);
                    return true;
                }
            };
        }
        final int i = p_150112_ - 500;
        if (i >= 0 && i < 4) {
            return new SlotAccess(){

                @Override
                public ItemStack get() {
                    return Player.this.inventoryMenu.getCraftSlots().getItem(i);
                }

                @Override
                public boolean set(ItemStack p_333999_) {
                    Player.this.inventoryMenu.getCraftSlots().setItem(i, p_333999_);
                    Player.this.inventoryMenu.slotsChanged(Player.this.inventory);
                    return true;
                }
            };
        }
        if (p_150112_ >= 0 && p_150112_ < this.inventory.getNonEquipmentItems().size()) {
            return SlotAccess.forContainer(this.inventory, p_150112_);
        }
        int j = p_150112_ - 200;
        return j >= 0 && j < this.enderChestInventory.getContainerSize() ? SlotAccess.forContainer(this.enderChestInventory, j) : super.getSlot(p_150112_);
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public void setReducedDebugInfo(boolean p_36394_) {
        this.reducedDebugInfo = p_36394_;
    }

    @Override
    public void setRemainingFireTicks(int p_36353_) {
        super.setRemainingFireTicks(this.abilities.invulnerable ? Math.min(p_36353_, 1) : p_36353_);
    }

    protected static Optional<Parrot.Variant> extractParrotVariant(CompoundTag p_427462_) {
        EntityType entitytype;
        if (!p_427462_.isEmpty() && (entitytype = (EntityType)p_427462_.read("id", EntityType.CODEC).orElse(null)) == EntityType.PARROT) {
            return p_427462_.read("Variant", Parrot.Variant.LEGACY_CODEC);
        }
        return Optional.empty();
    }

    protected static OptionalInt convertParrotVariant(Optional<Parrot.Variant> p_430527_) {
        return p_430527_.map(p_421904_ -> OptionalInt.of(p_421904_.getId())).orElse(OptionalInt.empty());
    }

    private static Optional<Parrot.Variant> convertParrotVariant(OptionalInt p_429721_) {
        return p_429721_.isPresent() ? Optional.of(Parrot.Variant.byId(p_429721_.getAsInt())) : Optional.empty();
    }

    public void setShoulderParrotLeft(Optional<Parrot.Variant> p_429312_) {
        this.entityData.set(DATA_SHOULDER_PARROT_LEFT, Player.convertParrotVariant(p_429312_));
    }

    public Optional<Parrot.Variant> getShoulderParrotLeft() {
        return Player.convertParrotVariant(this.entityData.get(DATA_SHOULDER_PARROT_LEFT));
    }

    public void setShoulderParrotRight(Optional<Parrot.Variant> p_425770_) {
        this.entityData.set(DATA_SHOULDER_PARROT_RIGHT, Player.convertParrotVariant(p_425770_));
    }

    public Optional<Parrot.Variant> getShoulderParrotRight() {
        return Player.convertParrotVariant(this.entityData.get(DATA_SHOULDER_PARROT_RIGHT));
    }

    public float getCurrentItemAttackStrengthDelay() {
        return (float)(1.0 / this.getAttributeValue(Attributes.ATTACK_SPEED) * 20.0);
    }

    public float getAttackStrengthScale(float p_36404_) {
        return Mth.clamp(((float)this.attackStrengthTicker + p_36404_) / this.getCurrentItemAttackStrengthDelay(), 0.0f, 1.0f);
    }

    public void resetAttackStrengthTicker() {
        this.attackStrengthTicker = 0;
    }

    public ItemCooldowns getCooldowns() {
        return this.cooldowns;
    }

    @Override
    protected float getBlockSpeedFactor() {
        return !this.abilities.flying && !this.isFallFlying() ? super.getBlockSpeedFactor() : 1.0f;
    }

    @Override
    public float getLuck() {
        return (float)this.getAttributeValue(Attributes.LUCK);
    }

    public boolean canUseGameMasterBlocks() {
        return this.abilities.instabuild && this.getPermissionLevel() >= 2;
    }

    public int getPermissionLevel() {
        return 0;
    }

    public boolean hasPermissions(int p_370047_) {
        return this.getPermissionLevel() >= p_370047_;
    }

    @Override
    public ImmutableList<Pose> getDismountPoses() {
        return ImmutableList.of((Object)Pose.STANDING, (Object)Pose.CROUCHING, (Object)Pose.SWIMMING);
    }

    @Override
    public ItemStack getProjectile(ItemStack p_36349_) {
        if (!(p_36349_.getItem() instanceof ProjectileWeaponItem)) {
            return ItemStack.EMPTY;
        }
        Predicate<ItemStack> predicate = ((ProjectileWeaponItem)p_36349_.getItem()).getSupportedHeldProjectiles();
        ItemStack itemstack = ProjectileWeaponItem.getHeldProjectile(this, predicate);
        if (!itemstack.isEmpty()) {
            return ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)p_36349_, (ItemStack)itemstack);
        }
        predicate = ((ProjectileWeaponItem)p_36349_.getItem()).getAllSupportedProjectiles();
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack1 = this.inventory.getItem(i);
            if (!predicate.test(itemstack1)) continue;
            return ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)p_36349_, (ItemStack)itemstack1);
        }
        ItemStack vanilla = this.abilities.instabuild ? new ItemStack(Items.ARROW) : ItemStack.EMPTY;
        return ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)p_36349_, (ItemStack)vanilla);
    }

    @Override
    public Vec3 getRopeHoldPosition(float p_36374_) {
        double d0 = 0.22 * (this.getMainArm() == HumanoidArm.RIGHT ? -1.0 : 1.0);
        float f = Mth.lerp(p_36374_ * 0.5f, this.getXRot(), this.xRotO) * ((float)Math.PI / 180);
        float f1 = Mth.lerp(p_36374_, this.yBodyRotO, this.yBodyRot) * ((float)Math.PI / 180);
        if (this.isFallFlying() || this.isAutoSpinAttack()) {
            float f2;
            Vec3 vec31 = this.getViewVector(p_36374_);
            Vec3 vec3 = this.getDeltaMovement();
            double d6 = vec3.horizontalDistanceSqr();
            double d3 = vec31.horizontalDistanceSqr();
            if (d6 > 0.0 && d3 > 0.0) {
                double d4 = (vec3.x * vec31.x + vec3.z * vec31.z) / Math.sqrt(d6 * d3);
                double d5 = vec3.x * vec31.z - vec3.z * vec31.x;
                f2 = (float)(Math.signum(d5) * Math.acos(d4));
            } else {
                f2 = 0.0f;
            }
            return this.getPosition(p_36374_).add(new Vec3(d0, -0.11, 0.85).zRot(-f2).xRot(-f).yRot(-f1));
        }
        if (this.isVisuallySwimming()) {
            return this.getPosition(p_36374_).add(new Vec3(d0, 0.2, -0.15).xRot(-f).yRot(-f1));
        }
        double d1 = this.getBoundingBox().getYsize() - 1.0;
        double d2 = this.isCrouching() ? -0.2 : 0.07;
        return this.getPosition(p_36374_).add(new Vec3(d0, d1, d2).yRot(-f1));
    }

    @Override
    public boolean isAlwaysTicking() {
        return true;
    }

    public boolean isScoping() {
        return this.isUsingItem() && this.getUseItem().is(Items.SPYGLASS);
    }

    @Override
    public boolean shouldBeSaved() {
        return false;
    }

    public Optional<GlobalPos> getLastDeathLocation() {
        return this.lastDeathLocation;
    }

    public void setLastDeathLocation(Optional<GlobalPos> p_219750_) {
        this.lastDeathLocation = p_219750_;
    }

    @Override
    public float getHurtDir() {
        return this.hurtDir;
    }

    @Override
    public void animateHurt(float p_265280_) {
        super.animateHurt(p_265280_);
        this.hurtDir = p_265280_;
    }

    public boolean isMobilityRestricted() {
        return this.hasEffect(MobEffects.BLINDNESS);
    }

    @Override
    public boolean canSprint() {
        return true;
    }

    @Override
    protected float getFlyingSpeed() {
        if (this.abilities.flying && !this.isPassenger()) {
            return this.isSprinting() ? this.abilities.getFlyingSpeed() * 2.0f : this.abilities.getFlyingSpeed();
        }
        return this.isSprinting() ? 0.025999999f : 0.02f;
    }

    public boolean hasClientLoaded() {
        return this.clientLoaded || this.clientLoadedTimeoutTimer <= 0;
    }

    public void tickClientLoadTimeout() {
        if (!this.clientLoaded) {
            --this.clientLoadedTimeoutTimer;
        }
    }

    public void setClientLoaded(boolean p_377570_) {
        this.clientLoaded = p_377570_;
        if (!this.clientLoaded) {
            this.clientLoadedTimeoutTimer = 60;
        }
    }

    @Override
    public boolean hasContainerOpen(ContainerOpenersCounter p_430021_, BlockPos p_426016_) {
        return p_430021_.isOwnContainer(this);
    }

    @Override
    public double getContainerInteractionRange() {
        return this.blockInteractionRange();
    }

    public double blockInteractionRange() {
        return this.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
    }

    public double entityInteractionRange() {
        return this.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE);
    }

    public boolean canInteractWithEntity(Entity p_333619_, double p_330803_) {
        return p_333619_.isRemoved() ? false : this.canInteractWithEntity(p_333619_.getBoundingBox(), p_330803_);
    }

    public boolean canInteractWithEntity(AABB p_329456_, double p_332906_) {
        double d0 = this.entityInteractionRange() + p_332906_;
        return p_329456_.distanceToSqr(this.getEyePosition()) < d0 * d0;
    }

    public boolean canInteractWithBlock(BlockPos p_331132_, double p_328439_) {
        double d0 = this.blockInteractionRange() + p_328439_;
        return new AABB(p_331132_).distanceToSqr(this.getEyePosition()) < d0 * d0;
    }

    public void setIgnoreFallDamageFromCurrentImpulse(boolean p_344459_) {
        this.ignoreFallDamageFromCurrentImpulse = p_344459_;
        this.currentImpulseContextResetGraceTime = p_344459_ ? 40 : 0;
    }

    public boolean isIgnoringFallDamageFromCurrentImpulse() {
        return this.ignoreFallDamageFromCurrentImpulse;
    }

    public void tryResetCurrentImpulseContext() {
        if (this.currentImpulseContextResetGraceTime == 0) {
            this.resetCurrentImpulseContext();
        }
    }

    public void resetCurrentImpulseContext() {
        this.currentImpulseContextResetGraceTime = 0;
        this.currentExplosionCause = null;
        this.currentImpulseImpactPos = null;
        this.ignoreFallDamageFromCurrentImpulse = false;
    }

    public Collection<MutableComponent> getPrefixes() {
        return this.prefixes;
    }

    public Collection<MutableComponent> getSuffixes() {
        return this.suffixes;
    }

    public void refreshDisplayName() {
        this.displayname = ForgeEventFactory.getPlayerDisplayName((Player)this, (Component)this.getName());
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && this.isAlive()) {
            if (facing == null) {
                return this.playerJoinedHandler.cast();
            }
            if (facing.getAxis().isVertical()) {
                return this.playerMainHandler.cast();
            }
            if (facing.getAxis().isHorizontal()) {
                return this.playerEquipmentHandler.cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    public void setForcedPose(@Nullable Pose pose) {
        this.forcedPose = pose;
    }

    @Nullable
    public Pose getForcedPose() {
        return this.forcedPose;
    }

    public boolean shouldRotateWithMinecart() {
        return false;
    }

    @Override
    public boolean onClimbable() {
        return this.abilities.flying ? false : super.onClimbable();
    }

    public String debugInfo() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getPlainTextName()).add("id", this.getId()).add("pos", (Object)this.position()).add("mode", (Object)this.gameMode()).add("permission", this.getPermissionLevel()).toString();
    }

    public static enum BedSleepingProblem {
        NOT_POSSIBLE_HERE,
        NOT_POSSIBLE_NOW(Component.translatable("block.minecraft.bed.no_sleep")),
        TOO_FAR_AWAY(Component.translatable("block.minecraft.bed.too_far_away")),
        OBSTRUCTED(Component.translatable("block.minecraft.bed.obstructed")),
        OTHER_PROBLEM,
        NOT_SAFE(Component.translatable("block.minecraft.bed.not_safe"));

        @Nullable
        private final Component message;

        private BedSleepingProblem() {
            this.message = null;
        }

        private BedSleepingProblem(Component p_36422_) {
            this.message = p_36422_;
        }

        @Nullable
        public Component getMessage() {
            return this.message;
        }
    }
}

