/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;

public class PoweredRailBlock
extends BaseRailBlock {
    public static final MapCodec<PoweredRailBlock> CODEC = PoweredRailBlock.simpleCodec(PoweredRailBlock::new);
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.RAIL_SHAPE_STRAIGHT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private final boolean isActivator;

    public MapCodec<PoweredRailBlock> codec() {
        return CODEC;
    }

    public PoweredRailBlock(BlockBehaviour.Properties p_55218_) {
        this(p_55218_, false);
    }

    protected PoweredRailBlock(BlockBehaviour.Properties p_55218_, boolean isPoweredRail) {
        super(true, p_55218_);
        this.isActivator = !isPoweredRail;
        this.registerDefaultState();
    }

    protected void registerDefaultState() {
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(SHAPE, RailShape.NORTH_SOUTH)).setValue(POWERED, false)).setValue(WATERLOGGED, false));
    }

    protected boolean findPoweredRailSignal(Level p_55220_, BlockPos p_55221_, BlockState p_55222_, boolean p_55223_, int p_55224_) {
        if (p_55224_ >= 8) {
            return false;
        }
        int i = p_55221_.getX();
        int j = p_55221_.getY();
        int k = p_55221_.getZ();
        boolean flag = true;
        RailShape railshape = p_55222_.getValue(this.getShapeProperty());
        switch (railshape) {
            case NORTH_SOUTH: {
                if (p_55223_) {
                    ++k;
                    break;
                }
                --k;
                break;
            }
            case EAST_WEST: {
                if (p_55223_) {
                    --i;
                    break;
                }
                ++i;
                break;
            }
            case ASCENDING_EAST: {
                if (p_55223_) {
                    --i;
                } else {
                    ++i;
                    ++j;
                    flag = false;
                }
                railshape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (p_55223_) {
                    --i;
                    ++j;
                    flag = false;
                } else {
                    ++i;
                }
                railshape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (p_55223_) {
                    ++k;
                } else {
                    --k;
                    ++j;
                    flag = false;
                }
                railshape = RailShape.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (p_55223_) {
                    ++k;
                    ++j;
                    flag = false;
                } else {
                    --k;
                }
                railshape = RailShape.NORTH_SOUTH;
            }
        }
        return this.isSameRailWithPower(p_55220_, new BlockPos(i, j, k), p_55223_, p_55224_, railshape) ? true : flag && this.isSameRailWithPower(p_55220_, new BlockPos(i, j - 1, k), p_55223_, p_55224_, railshape);
    }

    protected boolean isSameRailWithPower(Level p_55226_, BlockPos p_55227_, boolean p_55228_, int p_55229_, RailShape p_55230_) {
        PoweredRailBlock other;
        BlockState blockstate;
        block7: {
            block6: {
                blockstate = p_55226_.getBlockState(p_55227_);
                Block block = blockstate.getBlock();
                if (!(block instanceof PoweredRailBlock)) break block6;
                other = (PoweredRailBlock)block;
                if (this.isActivatorRail() == other.isActivatorRail()) break block7;
            }
            return false;
        }
        RailShape railshape = other.getRailDirection(blockstate, p_55226_, p_55227_, null);
        if (p_55230_ != RailShape.EAST_WEST || railshape != RailShape.NORTH_SOUTH && railshape != RailShape.ASCENDING_NORTH && railshape != RailShape.ASCENDING_SOUTH) {
            if (p_55230_ != RailShape.NORTH_SOUTH || railshape != RailShape.EAST_WEST && railshape != RailShape.ASCENDING_EAST && railshape != RailShape.ASCENDING_WEST) {
                if (!blockstate.getValue(POWERED).booleanValue()) {
                    return false;
                }
                return p_55226_.hasNeighborSignal(p_55227_) ? true : other.findPoweredRailSignal(p_55226_, p_55227_, blockstate, p_55228_, p_55229_ + 1);
            }
            return false;
        }
        return false;
    }

    @Override
    protected void updateState(BlockState p_55232_, Level p_55233_, BlockPos p_55234_, Block p_55235_) {
        boolean flag1;
        boolean flag = p_55232_.getValue(POWERED);
        boolean bl = flag1 = p_55233_.hasNeighborSignal(p_55234_) || this.findPoweredRailSignal(p_55233_, p_55234_, p_55232_, true, 0) || this.findPoweredRailSignal(p_55233_, p_55234_, p_55232_, false, 0);
        if (flag1 != flag) {
            p_55233_.setBlock(p_55234_, (BlockState)p_55232_.setValue(POWERED, flag1), 3);
            p_55233_.updateNeighborsAt(p_55234_.below(), this);
            if (p_55232_.getValue(this.getShapeProperty()).isSlope()) {
                p_55233_.updateNeighborsAt(p_55234_.above(), this);
            }
        }
    }

    @Override
    public Property<RailShape> getShapeProperty() {
        return SHAPE;
    }

    @Override
    protected BlockState rotate(BlockState p_55240_, Rotation p_55241_) {
        RailShape railshape = p_55240_.getValue(SHAPE);
        RailShape railshape1 = this.rotate(railshape, p_55241_);
        return (BlockState)p_55240_.setValue(SHAPE, railshape1);
    }

    @Override
    protected BlockState mirror(BlockState p_55237_, Mirror p_55238_) {
        RailShape railshape = p_55237_.getValue(SHAPE);
        RailShape railshape1 = this.mirror(railshape, p_55238_);
        return (BlockState)p_55237_.setValue(SHAPE, railshape1);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_55243_) {
        p_55243_.add(this.getShapeProperty(), POWERED, WATERLOGGED);
    }

    public boolean isActivatorRail() {
        return this.isActivator;
    }
}

