/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.entity.ClientMannequin;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ItemFrameRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraftforge.client.event.AddFramePassEvent;
import net.minecraftforge.client.event.AddGuiOverlayLayersEvent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.CreateSpecialBlockRendererEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.client.event.RenderAvatarEvent;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ToastAddEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.client.event.sound.PlayStreamingSourceEvent;
import net.minecraftforge.client.gui.overlay.ForgeLayeredDraw;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.internal.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ForgeEventFactoryClient {
    private ForgeEventFactoryClient() {
    }

    public static void onGatherLayers(Map<EntityType<?>, EntityRenderer<?, ?>> renderers, Map<PlayerModelType, AvatarRenderer<AbstractClientPlayer>> playerRenderers, Map<PlayerModelType, AvatarRenderer<ClientMannequin>> mannequinRenderers, EntityRendererProvider.Context context) {
        EntityRenderersEvent.AddLayers.BUS.post((Event)new EntityRenderersEvent.AddLayers(renderers, playerRenderers, mannequinRenderers, context));
    }

    public static boolean onScreenMouseReleased(Screen screen, double mouseX, double mouseY, MouseButtonEvent event) {
        if (ScreenEvent.MouseButtonReleased.Pre.BUS.post((Event)new ScreenEvent.MouseButtonReleased.Pre(screen, mouseX, mouseY, event.button()))) {
            return true;
        }
        boolean ret = screen.mouseReleased(event);
        Result result = ((ScreenEvent.MouseButtonReleased.Post)ScreenEvent.MouseButtonReleased.Post.BUS.fire((Event)new ScreenEvent.MouseButtonReleased.Post(screen, mouseX, mouseY, event.button(), ret))).getResult();
        return result == Result.DEFAULT ? ret : result == Result.ALLOW;
    }

    public static boolean onScreenMouseClicked(Screen screen, double mouseX, double mouseY, MouseButtonEvent info, boolean repeate) {
        Result result;
        boolean ret = ScreenEvent.MouseButtonPressed.Pre.BUS.post((Event)new ScreenEvent.MouseButtonPressed.Pre(screen, mouseX, mouseY, info));
        if (!ret) {
            ret = screen.mouseClicked(info, repeate);
        }
        return (result = ((ScreenEvent.MouseButtonPressed.Post)ScreenEvent.MouseButtonPressed.Post.BUS.fire((Event)new ScreenEvent.MouseButtonPressed.Post(screen, mouseX, mouseY, info, ret, new Result.Holder()))).getResult()) == Result.DEFAULT ? ret : result == Result.ALLOW;
    }

    public static boolean onMouseButtonPre(MouseButtonInfo info, int action) {
        return InputEvent.MouseButton.Pre.BUS.post((Event)new InputEvent.MouseButton.Pre(info, action));
    }

    public static void onMouseButtonPost(MouseButtonInfo info, int action) {
        InputEvent.MouseButton.Post.BUS.post((Event)new InputEvent.MouseButton.Post(info, action));
    }

    public static boolean onScreenMouseScrollPre(Screen guiScreen, double mouseX, double mouseY, double deltaX, double deltaY) {
        return ScreenEvent.MouseScrolled.Pre.BUS.post((Event)new ScreenEvent.MouseScrolled.Pre(guiScreen, mouseX, mouseY, deltaX, deltaY));
    }

    public static void onScreenMouseScrollPost(Screen guiScreen, double mouseX, double mouseY, double deltaX, double deltaY) {
        ScreenEvent.MouseScrolled.Post.BUS.post((Event)new ScreenEvent.MouseScrolled.Post(guiScreen, mouseX, mouseY, deltaX, deltaY));
    }

    public static boolean onMouseScroll(MouseHandler mouseHelper, double deltaX, double deltaY) {
        return InputEvent.MouseScrollingEvent.BUS.post((Event)new InputEvent.MouseScrollingEvent(deltaX, deltaY, mouseHelper.isLeftPressed(), mouseHelper.isMiddlePressed(), mouseHelper.isRightPressed(), mouseHelper.xpos(), mouseHelper.ypos()));
    }

    public static boolean onScreenMouseDragPre(Screen guiScreen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        return ScreenEvent.MouseDragged.Pre.BUS.post((Event)new ScreenEvent.MouseDragged.Pre(guiScreen, mouseX, mouseY, mouseButton, dragX, dragY));
    }

    public static boolean onScreenMouseDragPost(Screen guiScreen, double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        return ScreenEvent.MouseDragged.Post.BUS.post((Event)new ScreenEvent.MouseDragged.Post(guiScreen, mouseX, mouseY, mouseButton, dragX, dragY));
    }

    @Nullable
    public static Screen onScreenOpening(Screen old, Screen screen) {
        ScreenEvent.Opening event = new ScreenEvent.Opening(old, screen);
        if (ScreenEvent.Opening.BUS.post((Event)event)) {
            return null;
        }
        return event.getNewScreen();
    }

    public static void onScreenClose(Screen screen) {
        ScreenEvent.Closing.BUS.post((Event)new ScreenEvent.Closing(screen));
    }

    public static void onPlaySoundSource(SoundEngine engine, SoundInstance sound, Channel channel) {
        PlaySoundSourceEvent.BUS.post((Event)new PlaySoundSourceEvent(engine, sound, channel));
    }

    public static void onPlayStreamingSource(SoundEngine engine, SoundInstance sound, Channel channel) {
        PlayStreamingSourceEvent.BUS.post((Event)new PlayStreamingSourceEvent(engine, sound, channel));
    }

    public static boolean onScreenKeyPressedPre(Screen screen, KeyEvent info) {
        return ScreenEvent.KeyPressed.Pre.BUS.post((Event)new ScreenEvent.KeyPressed.Pre(screen, info));
    }

    public static boolean onScreenKeyPressedPost(Screen screen, KeyEvent info) {
        return ScreenEvent.KeyPressed.Post.BUS.post((Event)new ScreenEvent.KeyPressed.Post(screen, info));
    }

    public static boolean onScreenKeyReleasedPre(Screen screen, KeyEvent info) {
        return ScreenEvent.KeyReleased.Pre.BUS.post((Event)new ScreenEvent.KeyReleased.Pre(screen, info));
    }

    public static boolean onScreenKeyReleasedPost(Screen screen, KeyEvent info) {
        return ScreenEvent.KeyReleased.Post.BUS.post((Event)new ScreenEvent.KeyReleased.Post(screen, info));
    }

    public static boolean onScreenCharTypedPre(Screen screen, CharacterEvent info) {
        return ScreenEvent.CharacterTyped.Pre.BUS.post((Event)new ScreenEvent.CharacterTyped.Pre(screen, info));
    }

    public static boolean onScreenCharTypedPost(Screen screen, CharacterEvent info) {
        return ScreenEvent.CharacterTyped.Post.BUS.post((Event)new ScreenEvent.CharacterTyped.Post(screen, info));
    }

    public static boolean onClickInputPickBlock(KeyMapping keyBinding) {
        InputEvent.InteractionKeyMappingTriggered event = new InputEvent.InteractionKeyMappingTriggered(2, keyBinding, InteractionHand.MAIN_HAND);
        return InputEvent.InteractionKeyMappingTriggered.BUS.post((Event)event);
    }

    public static void onContainerRenderBackground(AbstractContainerScreen<?> screen, GuiGraphics graphics, int mouseX, int mouseY) {
        ContainerScreenEvent.Render.Background.BUS.post((Event)new ContainerScreenEvent.Render.Background(screen, graphics, mouseX, mouseY));
    }

    public static void onContainerRenderForeground(AbstractContainerScreen<?> screen, GuiGraphics graphics, int mouseX, int mouseY) {
        ContainerScreenEvent.Render.Foreground.BUS.post((Event)new ContainerScreenEvent.Render.Foreground(screen, graphics, mouseX, mouseY));
    }

    public static void firePlayerLogin(MultiPlayerGameMode pc, LocalPlayer player, Connection networkManager) {
        ClientPlayerNetworkEvent.LoggingIn.BUS.post((Event)new ClientPlayerNetworkEvent.LoggingIn(pc, player, networkManager));
    }

    public static void firePlayerLogout(@Nullable MultiPlayerGameMode pc, @Nullable LocalPlayer player) {
        ClientPlayerNetworkEvent.LoggingOut.BUS.post((Event)new ClientPlayerNetworkEvent.LoggingOut(pc, player, player != null ? (player.connection != null ? player.connection.getConnection() : null) : null));
    }

    public static void firePlayerRespawn(MultiPlayerGameMode pc, LocalPlayer oldPlayer, LocalPlayer newPlayer, Connection networkManager) {
        ClientPlayerNetworkEvent.Clone.BUS.post((Event)new ClientPlayerNetworkEvent.Clone(pc, oldPlayer, newPlayer, networkManager));
    }

    public static ViewportEvent.ComputeFov fireComputeFov(GameRenderer renderer, Camera camera, float partialTick, float fov, boolean usedConfiguredFov) {
        return (ViewportEvent.ComputeFov)ViewportEvent.ComputeFov.BUS.fire((Event)new ViewportEvent.ComputeFov(renderer, camera, partialTick, fov, usedConfiguredFov));
    }

    public static ViewportEvent.ComputeCameraAngles fireComputeCameraAngles(GameRenderer renderer, Camera camera, float partial) {
        return (ViewportEvent.ComputeCameraAngles)ViewportEvent.ComputeCameraAngles.BUS.fire((Event)new ViewportEvent.ComputeCameraAngles(renderer, camera, partial, camera.getYRot(), camera.getXRot(), 0.0f));
    }

    public static <T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<? super S>> boolean onRenderLivingPre(S state, LivingEntityRenderer<T, S, M> renderer, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraState) {
        return RenderLivingEvent.Pre.BUS.post(new RenderLivingEvent.Pre<T, S, M>(state, renderer, poseStack, nodeCollector, cameraState));
    }

    public static <T extends LivingEntity, S extends LivingEntityRenderState, M extends EntityModel<? super S>> boolean onRenderLivingPost(S state, LivingEntityRenderer<T, S, M> renderer, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraState) {
        return RenderLivingEvent.Post.BUS.post(new RenderLivingEvent.Post<T, S, M>(state, renderer, poseStack, nodeCollector, cameraState));
    }

    public static <AvatarlikeEntity extends Avatar> boolean onRenderAvatarPre(AvatarRenderState player, AvatarRenderer<AvatarlikeEntity> renderer, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState camera) {
        return RenderAvatarEvent.Pre.BUS.post((Event)new RenderAvatarEvent.Pre(player, renderer, poseStack, nodeCollector, camera));
    }

    public static <AvatarlikeEntity extends Avatar> boolean onRenderAvatarPost(AvatarRenderState player, AvatarRenderer<AvatarlikeEntity> renderer, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState camera) {
        return RenderAvatarEvent.Post.BUS.post((Event)new RenderAvatarEvent.Post(player, renderer, poseStack, nodeCollector, camera));
    }

    public static boolean onRenderArm(PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight, HumanoidArm arm) {
        return RenderArmEvent.BUS.post((Event)new RenderArmEvent(poseStack, nodeCollector, packedLight, arm));
    }

    public static boolean onRenderItemInFrame(ItemFrameRenderState state, ItemFrameRenderer<?> renderItemFrame, PoseStack poseStack, SubmitNodeCollector nodeCollector, int packedLight) {
        return RenderItemInFrameEvent.BUS.post((Event)new RenderItemInFrameEvent(state, renderItemFrame, poseStack, nodeCollector, packedLight));
    }

    public static RenderNameTagEvent fireRenderNameTagEvent(EntityRenderState state, Component content, EntityRenderer<?, ?> entityRenderer, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraState) {
        return (RenderNameTagEvent)RenderNameTagEvent.BUS.fire((Event)new RenderNameTagEvent(state, content, entityRenderer, poseStack, nodeCollector, cameraState));
    }

    public static void onRenderScreenBackground(Screen screen, GuiGraphics guiGraphics) {
        ScreenEvent.BackgroundRendered.BUS.post((Event)new ScreenEvent.BackgroundRendered(screen, guiGraphics));
    }

    public static void onRenderTickStart(DeltaTracker timer) {
        TickEvent.RenderTickEvent.Pre.BUS.post((Event)new TickEvent.RenderTickEvent.Pre(timer));
    }

    public static void onRenderTickEnd(DeltaTracker timer) {
        TickEvent.RenderTickEvent.Post.BUS.post((Event)new TickEvent.RenderTickEvent.Post(timer));
    }

    public static boolean onToastAdd(Toast toast) {
        return ToastAddEvent.BUS.post((Event)new ToastAddEvent(toast));
    }

    @Nullable
    public static ScreenEvent.RenderInventoryMobEffects onScreenEffectSize(Screen screen, int availableSpace, boolean compact, int horizontalOffset) {
        ScreenEvent.RenderInventoryMobEffects event = new ScreenEvent.RenderInventoryMobEffects(screen, availableSpace, compact, horizontalOffset);
        return ScreenEvent.RenderInventoryMobEffects.BUS.post((Event)event) ? null : event;
    }

    public static void onRecipesUpdated(ClientRecipeBook book) {
        RecipesUpdatedEvent.BUS.post((Event)new RecipesUpdatedEvent(book));
    }

    public static ComputeFovModifierEvent fireFovModifierEvent(Player entity, float modifier, float scale) {
        return (ComputeFovModifierEvent)ComputeFovModifierEvent.BUS.fire((Event)new ComputeFovModifierEvent(entity, modifier, scale));
    }

    public static void onCreateSpecialBlockRenderers(Map<Block, SpecialModelRenderer.Unbaked> map) {
        CreateSpecialBlockRendererEvent.BUS.post((Event)new CreateSpecialBlockRendererEvent(map));
    }

    public static Map<SkullBlock.Type, Function<EntityModelSet, SkullModelBase>> onCreateSkullModels() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        EntityRenderersEvent.CreateSkullModels.BUS.post((Event)new EntityRenderersEvent.CreateSkullModels((ImmutableMap.Builder<SkullBlock.Type, Function<EntityModelSet, SkullModelBase>>)builder));
        return builder.build();
    }

    public static ModelEvent.RegisterModelStateDefinitions onRegisterModeStateDefinitions() {
        return (ModelEvent.RegisterModelStateDefinitions)ModelEvent.RegisterModelStateDefinitions.BUS.fire((Event)new ModelEvent.RegisterModelStateDefinitions());
    }

    public static void onInitLevelRenderer() {
        AddFramePassEvent.BUS.post((Event)new AddFramePassEvent());
    }

    public static void onComputeLayerOrder(ForgeLayeredDraw layeredDraw) {
        AddGuiOverlayLayersEvent.BUS.post((Event)new AddGuiOverlayLayersEvent(layeredDraw));
    }
}

