/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.capabilities;

import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilityProviderImpl;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.internal.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class CapabilityProvider<B extends ICapabilityProviderImpl<B>>
implements ICapabilityProviderImpl<B> {
    @VisibleForTesting
    static boolean SUPPORTS_LAZY_CAPABILITIES = true;
    @Nullable
    private CapabilityDispatcher capabilities;
    private boolean valid = true;
    private final boolean isLazy;
    private Supplier<ICapabilityProvider> lazyParentSupplier = null;
    private CompoundTag lazyData = null;
    private HolderLookup.Provider registryAccess = null;
    private boolean initialized = false;

    protected CapabilityProvider() {
        this.isLazy = false;
    }

    protected CapabilityProvider(boolean isLazy) {
        this.isLazy = SUPPORTS_LAZY_CAPABILITIES && isLazy;
    }

    protected final void gatherCapabilities() {
        this.gatherCapabilities(() -> null);
    }

    protected final void gatherCapabilities(@Nullable ICapabilityProvider parent) {
        if (!this.shouldFireAttachCapabilitiesEvent()) {
            this.initialized = true;
            return;
        }
        this.gatherCapabilities(() -> parent);
    }

    protected final void gatherCapabilities(@Nullable Supplier<ICapabilityProvider> parent) {
        if (!this.shouldFireAttachCapabilitiesEvent()) {
            this.initialized = true;
            return;
        }
        if (this.isLazy && !this.initialized) {
            this.lazyParentSupplier = parent == null ? () -> null : parent;
            return;
        }
        this.doGatherCapabilities(parent == null ? null : parent.get());
    }

    protected abstract AttachCapabilitiesEvent fireAttachCapabilitiesEvent(B var1);

    protected abstract boolean shouldFireAttachCapabilitiesEvent();

    private void doGatherCapabilities(@Nullable ICapabilityProvider parent) {
        this.capabilities = ForgeEventFactory.gatherCapabilities(this.fireAttachCapabilitiesEvent(this.getProvider()), parent);
        this.initialized = true;
    }

    @NotNull
    B getProvider() {
        return (B)this;
    }

    @Nullable
    protected final CapabilityDispatcher getCapabilities() {
        if (this.isLazy && !this.initialized) {
            this.doGatherCapabilities(this.lazyParentSupplier == null ? null : this.lazyParentSupplier.get());
            if (this.lazyData != null) {
                this.deserializeCaps(this.registryAccess, this.lazyData);
            }
        }
        return this.capabilities;
    }

    @Nullable
    protected final CompoundTag serializeCaps(HolderLookup.Provider registryAccess) {
        if (this.isLazy && !this.initialized) {
            return this.lazyData;
        }
        CapabilityDispatcher disp = this.getCapabilities();
        if (disp != null) {
            return disp.serializeNBT(registryAccess);
        }
        return null;
    }

    protected final void deserializeCaps(HolderLookup.Provider registryAccess, CompoundTag tag) {
        if (this.isLazy && !this.initialized) {
            this.lazyData = tag;
            this.registryAccess = registryAccess;
            return;
        }
        CapabilityDispatcher disp = this.getCapabilities();
        if (disp != null) {
            disp.deserializeNBT(registryAccess, tag);
        }
        this.lazyData = null;
        this.registryAccess = null;
    }

    @Override
    public void invalidateCaps() {
        this.valid = false;
        CapabilityDispatcher disp = this.getCapabilities();
        if (disp != null) {
            disp.invalidate();
        }
    }

    @Override
    public void reviveCaps() {
        this.valid = true;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        CapabilityDispatcher disp = this.getCapabilities();
        return !this.valid || disp == null ? LazyOptional.empty() : disp.getCapability(cap, side);
    }

    public static abstract class AsField<B extends ICapabilityProviderImpl<B>>
    extends CapabilityProvider<B> {
        private final B owner;

        public AsField(B owner) {
            this.owner = owner;
        }

        public AsField(B owner, boolean isLazy) {
            super(isLazy);
            this.owner = owner;
        }

        public void initInternal() {
            this.gatherCapabilities();
        }

        @Nullable
        public CompoundTag serializeInternal(HolderLookup.Provider registryAccess) {
            return this.serializeCaps(registryAccess);
        }

        public void deserializeInternal(HolderLookup.Provider registryAccess, CompoundTag tag) {
            this.deserializeCaps(registryAccess, tag);
        }

        @Override
        @NotNull
        B getProvider() {
            return this.owner;
        }

        public static class LevelChunks
        extends AsField<LevelChunk> {
            public LevelChunks(LevelChunk owner) {
                super(owner);
            }

            public LevelChunks(LevelChunk owner, boolean isLazy) {
                super(owner, isLazy);
            }

            protected AttachCapabilitiesEvent.LevelChunks fireAttachCapabilitiesEvent(LevelChunk provider) {
                return (AttachCapabilitiesEvent.LevelChunks)AttachCapabilitiesEvent.LevelChunks.BUS.fire((Event)new AttachCapabilitiesEvent.LevelChunks(provider));
            }

            @Override
            protected boolean shouldFireAttachCapabilitiesEvent() {
                return AttachCapabilitiesEvent.LevelChunks.BUS.hasListeners();
            }
        }
    }

    public static class Levels
    extends CapabilityProvider<Level> {
        protected Levels() {
            super(false);
        }

        protected Levels(boolean isLazy) {
            super(isLazy);
        }

        protected AttachCapabilitiesEvent.Levels fireAttachCapabilitiesEvent(Level provider) {
            return (AttachCapabilitiesEvent.Levels)AttachCapabilitiesEvent.Levels.BUS.fire((Event)new AttachCapabilitiesEvent.Levels(provider));
        }

        @Override
        protected boolean shouldFireAttachCapabilitiesEvent() {
            return AttachCapabilitiesEvent.Levels.BUS.hasListeners();
        }
    }

    public static class ItemStacks
    extends CapabilityProvider<ItemStack> {
        protected ItemStacks() {
            super(false);
        }

        protected ItemStacks(boolean isLazy) {
            super(isLazy);
        }

        protected AttachCapabilitiesEvent.ItemStacks fireAttachCapabilitiesEvent(ItemStack provider) {
            return (AttachCapabilitiesEvent.ItemStacks)AttachCapabilitiesEvent.ItemStacks.BUS.fire((Event)new AttachCapabilitiesEvent.ItemStacks(provider));
        }

        @Override
        protected boolean shouldFireAttachCapabilitiesEvent() {
            return AttachCapabilitiesEvent.ItemStacks.BUS.hasListeners();
        }
    }

    public static class BlockEntities
    extends CapabilityProvider<BlockEntity> {
        protected BlockEntities() {
            super(false);
        }

        protected BlockEntities(boolean isLazy) {
            super(isLazy);
        }

        protected AttachCapabilitiesEvent.BlockEntities fireAttachCapabilitiesEvent(BlockEntity provider) {
            return (AttachCapabilitiesEvent.BlockEntities)AttachCapabilitiesEvent.BlockEntities.BUS.fire((Event)new AttachCapabilitiesEvent.BlockEntities(provider));
        }

        @Override
        protected boolean shouldFireAttachCapabilitiesEvent() {
            return AttachCapabilitiesEvent.BlockEntities.BUS.hasListeners();
        }
    }

    public static class Entities
    extends CapabilityProvider<Entity> {
        protected Entities() {
            super(false);
        }

        protected Entities(boolean isLazy) {
            super(isLazy);
        }

        protected AttachCapabilitiesEvent.Entities fireAttachCapabilitiesEvent(Entity provider) {
            return (AttachCapabilitiesEvent.Entities)AttachCapabilitiesEvent.Entities.BUS.fire((Event)new AttachCapabilitiesEvent.Entities(provider));
        }

        @Override
        protected boolean shouldFireAttachCapabilitiesEvent() {
            return AttachCapabilitiesEvent.Entities.BUS.hasListeners();
        }
    }
}

