// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package gpuevent

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"
	"structs"

	"github.com/cilium/ebpf"
)

type BpfGpuKernelLaunchT struct {
	_       structs.HostLayout
	Flags   uint8
	Pad     [3]uint8
	PidInfo struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	KernFuncOff uint64
	GridX       int32
	GridY       int32
	GridZ       int32
	BlockX      int32
	BlockY      int32
	BlockZ      int32
	Stream      uint64
	Args        [16]uint64
	UstackSz    uint64
	Ustack      [128]uint64
}

type BpfGpuMallocT struct {
	_       structs.HostLayout
	Flags   uint8
	Pad     [3]uint8
	PidInfo struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Size int64
}

type BpfGpuMemcpyT struct {
	_       structs.HostLayout
	Flags   uint8
	Kind    uint8
	Pad     [2]uint8
	PidInfo struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Size int64
}

// LoadBpf returns the embedded CollectionSpec for Bpf.
func LoadBpf() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load Bpf: %w", err)
	}

	return spec, err
}

// LoadBpfObjects loads Bpf and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*BpfObjects
//	*BpfPrograms
//	*BpfMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func LoadBpfObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := LoadBpf()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// BpfSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfSpecs struct {
	BpfProgramSpecs
	BpfMapSpecs
	BpfVariableSpecs
}

// BpfProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfProgramSpecs struct {
	HandleCudaLaunch *ebpf.ProgramSpec `ebpf:"handle_cuda_launch"`
	HandleCudaMalloc *ebpf.ProgramSpec `ebpf:"handle_cuda_malloc"`
	HandleCudaMemcpy *ebpf.ProgramSpec `ebpf:"handle_cuda_memcpy"`
}

// BpfMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfMapSpecs struct {
	PidCache  *ebpf.MapSpec `ebpf:"pid_cache"`
	Rb        *ebpf.MapSpec `ebpf:"rb"`
	ValidPids *ebpf.MapSpec `ebpf:"valid_pids"`
}

// BpfVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfVariableSpecs struct {
	FilterPids *ebpf.VariableSpec `ebpf:"filter_pids"`
	ProgCfg    *ebpf.VariableSpec `ebpf:"prog_cfg"`
	UnusedGpu  *ebpf.VariableSpec `ebpf:"unused_gpu"`
	UnusedGpu1 *ebpf.VariableSpec `ebpf:"unused_gpu1"`
	UnusedGpu2 *ebpf.VariableSpec `ebpf:"unused_gpu2"`
}

// BpfObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfObjects struct {
	BpfPrograms
	BpfMaps
	BpfVariables
}

func (o *BpfObjects) Close() error {
	return _BpfClose(
		&o.BpfPrograms,
		&o.BpfMaps,
	)
}

// BpfMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfMaps struct {
	PidCache  *ebpf.Map `ebpf:"pid_cache"`
	Rb        *ebpf.Map `ebpf:"rb"`
	ValidPids *ebpf.Map `ebpf:"valid_pids"`
}

func (m *BpfMaps) Close() error {
	return _BpfClose(
		m.PidCache,
		m.Rb,
		m.ValidPids,
	)
}

// BpfVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfVariables struct {
	FilterPids *ebpf.Variable `ebpf:"filter_pids"`
	ProgCfg    *ebpf.Variable `ebpf:"prog_cfg"`
	UnusedGpu  *ebpf.Variable `ebpf:"unused_gpu"`
	UnusedGpu1 *ebpf.Variable `ebpf:"unused_gpu1"`
	UnusedGpu2 *ebpf.Variable `ebpf:"unused_gpu2"`
}

// BpfPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to LoadBpfObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfPrograms struct {
	HandleCudaLaunch *ebpf.Program `ebpf:"handle_cuda_launch"`
	HandleCudaMalloc *ebpf.Program `ebpf:"handle_cuda_malloc"`
	HandleCudaMemcpy *ebpf.Program `ebpf:"handle_cuda_memcpy"`
}

func (p *BpfPrograms) Close() error {
	return _BpfClose(
		p.HandleCudaLaunch,
		p.HandleCudaMalloc,
		p.HandleCudaMemcpy,
	)
}

func _BpfClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpf_x86_bpfel.o
var _BpfBytes []byte
