// Code generated by bpf2go; DO NOT EDIT.
//go:build 386 || amd64

package gpuevent

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"
	"structs"

	"github.com/cilium/ebpf"
)

type BpfDebugGpuKernelLaunchT struct {
	_       structs.HostLayout
	Flags   uint8
	Pad     [3]uint8
	PidInfo struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	KernFuncOff uint64
	GridX       int32
	GridY       int32
	GridZ       int32
	BlockX      int32
	BlockY      int32
	BlockZ      int32
	Stream      uint64
	Args        [16]uint64
	UstackSz    uint64
	Ustack      [128]uint64
}

type BpfDebugGpuMallocT struct {
	_       structs.HostLayout
	Flags   uint8
	Pad     [3]uint8
	PidInfo struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Size int64
}

type BpfDebugGpuMemcpyT struct {
	_       structs.HostLayout
	Flags   uint8
	Kind    uint8
	Pad     [2]uint8
	PidInfo struct {
		_       structs.HostLayout
		HostPid uint32
		UserPid uint32
		Ns      uint32
	}
	Size int64
}

// LoadBpfDebug returns the embedded CollectionSpec for BpfDebug.
func LoadBpfDebug() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_BpfDebugBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load BpfDebug: %w", err)
	}

	return spec, err
}

// LoadBpfDebugObjects loads BpfDebug and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*BpfDebugObjects
//	*BpfDebugPrograms
//	*BpfDebugMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func LoadBpfDebugObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := LoadBpfDebug()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// BpfDebugSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugSpecs struct {
	BpfDebugProgramSpecs
	BpfDebugMapSpecs
	BpfDebugVariableSpecs
}

// BpfDebugProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugProgramSpecs struct {
	HandleCudaLaunch *ebpf.ProgramSpec `ebpf:"handle_cuda_launch"`
	HandleCudaMalloc *ebpf.ProgramSpec `ebpf:"handle_cuda_malloc"`
	HandleCudaMemcpy *ebpf.ProgramSpec `ebpf:"handle_cuda_memcpy"`
}

// BpfDebugMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugMapSpecs struct {
	DebugEvents *ebpf.MapSpec `ebpf:"debug_events"`
	PidCache    *ebpf.MapSpec `ebpf:"pid_cache"`
	Rb          *ebpf.MapSpec `ebpf:"rb"`
	ValidPids   *ebpf.MapSpec `ebpf:"valid_pids"`
}

// BpfDebugVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type BpfDebugVariableSpecs struct {
	FilterPids *ebpf.VariableSpec `ebpf:"filter_pids"`
	ProgCfg    *ebpf.VariableSpec `ebpf:"prog_cfg"`
	UnusedGpu  *ebpf.VariableSpec `ebpf:"unused_gpu"`
	UnusedGpu1 *ebpf.VariableSpec `ebpf:"unused_gpu1"`
	UnusedGpu2 *ebpf.VariableSpec `ebpf:"unused_gpu2"`
}

// BpfDebugObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugObjects struct {
	BpfDebugPrograms
	BpfDebugMaps
	BpfDebugVariables
}

func (o *BpfDebugObjects) Close() error {
	return _BpfDebugClose(
		&o.BpfDebugPrograms,
		&o.BpfDebugMaps,
	)
}

// BpfDebugMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugMaps struct {
	DebugEvents *ebpf.Map `ebpf:"debug_events"`
	PidCache    *ebpf.Map `ebpf:"pid_cache"`
	Rb          *ebpf.Map `ebpf:"rb"`
	ValidPids   *ebpf.Map `ebpf:"valid_pids"`
}

func (m *BpfDebugMaps) Close() error {
	return _BpfDebugClose(
		m.DebugEvents,
		m.PidCache,
		m.Rb,
		m.ValidPids,
	)
}

// BpfDebugVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugVariables struct {
	FilterPids *ebpf.Variable `ebpf:"filter_pids"`
	ProgCfg    *ebpf.Variable `ebpf:"prog_cfg"`
	UnusedGpu  *ebpf.Variable `ebpf:"unused_gpu"`
	UnusedGpu1 *ebpf.Variable `ebpf:"unused_gpu1"`
	UnusedGpu2 *ebpf.Variable `ebpf:"unused_gpu2"`
}

// BpfDebugPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to LoadBpfDebugObjects or ebpf.CollectionSpec.LoadAndAssign.
type BpfDebugPrograms struct {
	HandleCudaLaunch *ebpf.Program `ebpf:"handle_cuda_launch"`
	HandleCudaMalloc *ebpf.Program `ebpf:"handle_cuda_malloc"`
	HandleCudaMemcpy *ebpf.Program `ebpf:"handle_cuda_memcpy"`
}

func (p *BpfDebugPrograms) Close() error {
	return _BpfDebugClose(
		p.HandleCudaLaunch,
		p.HandleCudaMalloc,
		p.HandleCudaMemcpy,
	)
}

func _BpfDebugClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed bpfdebug_x86_bpfel.o
var _BpfDebugBytes []byte
