/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.fields;

import gov.nist.javax.sdp.fields.SDPField;
import java.net.URL;
import javax.sdp.URI;

public class URIField
extends SDPField
implements URI {
    private static final long serialVersionUID = -4322063343955734258L;
    protected URL url;
    protected String urlString;

    public URIField() {
        super("u=");
    }

    public String getURI() {
        return this.urlString;
    }

    public void setURI(String uri) {
        this.urlString = uri;
        this.url = null;
    }

    public URL get() {
        if (this.url != null) {
            return this.url;
        }
        try {
            this.url = new URL(this.urlString);
            return this.url;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void set(URL uri) {
        this.url = uri;
        this.urlString = null;
    }

    @Override
    public String encode() {
        if (this.urlString != null) {
            return "u=" + this.urlString + "\r\n";
        }
        if (this.url != null) {
            return "u=" + this.url.toString() + "\r\n";
        }
        return "";
    }
}

