/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.DebugStateMode;
import org.jitsi.utils.dsi.ActiveSpeakerChangedListener;
import org.jitsi.utils.dsi.DominantSpeakerIdentification;
import org.jitsi.utils.dsi.SpeakerRanking;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.ConferenceSpeechActivityConfig;
import org.jitsi.videobridge.LoudestConfig;
import org.jitsi.videobridge.RecentSpeakersList;
import org.jitsi.videobridge.util.TaskPools;
import org.json.simple.JSONObject;

public class ConferenceSpeechActivity {
    private final Logger logger;
    private final ActiveSpeakerChangedListener<String> activeSpeakerChangedListener = this::activeSpeakerChanged;
    private DominantSpeakerIdentification<String> dominantSpeakerIdentification;
    private Listener listener;
    private final List<AbstractEndpoint> endpointsBySpeechActivity = new ArrayList<AbstractEndpoint>();
    @NotNull
    private List<AbstractEndpoint> endpointsInLastNOrder = new ArrayList<AbstractEndpoint>();
    @NotNull
    private final RecentSpeakersList<AbstractEndpoint> recentSpeakers = new RecentSpeakersList(ConferenceSpeechActivityConfig.config.getRecentSpeakersCount() + 1);
    private boolean inSilence = ConferenceSpeechActivityConfig.config.getEnableSilenceDetection();
    private final Object syncRoot = new Object();

    public ConferenceSpeechActivity(@NotNull Listener listener) {
        this(listener, null);
    }

    public ConferenceSpeechActivity(@NotNull Listener listener, Logger parentLogger) {
        this.listener = Objects.requireNonNull(listener, "listener");
        this.logger = parentLogger == null ? new LoggerImpl(ConferenceSpeechActivity.class.getName()) : parentLogger.createChildLogger(ConferenceSpeechActivity.class.getName());
        long silenceTimeoutMs = -1L;
        if (ConferenceSpeechActivityConfig.config.getEnableSilenceDetection()) {
            silenceTimeoutMs = ConferenceSpeechActivityConfig.config.getSilenceDetectionTimeout().toMillis();
        }
        this.dominantSpeakerIdentification = new DominantSpeakerIdentification(silenceTimeoutMs);
        this.dominantSpeakerIdentification.addActiveSpeakerChangedListener(this.activeSpeakerChangedListener);
        int numLoudestToTrack = LoudestConfig.Companion.getRouteLoudestOnly() ? LoudestConfig.Companion.getNumLoudest() : 0;
        this.dominantSpeakerIdentification.setLoudestConfig(numLoudestToTrack, (int)LoudestConfig.Companion.getEnergyExpireTime().toMillis(), LoudestConfig.Companion.getEnergyAlphaPct());
    }

    boolean isInSilence() {
        return this.inSilence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activeSpeakerChanged(@Nullable String id) {
        boolean dominantSpeakerChanged;
        boolean endpointListChanged;
        Listener listener = this.listener;
        if (listener == null) {
            return;
        }
        this.logger.trace(() -> "The dominant speaker is now " + id + ".");
        Object object = this.syncRoot;
        synchronized (object) {
            if (id == null) {
                endpointListChanged = false;
                dominantSpeakerChanged = false;
                if (!this.inSilence) {
                    this.inSilence = true;
                }
            } else {
                AbstractEndpoint endpoint;
                dominantSpeakerChanged = true;
                if (this.inSilence) {
                    this.inSilence = false;
                }
                if (!this.endpointsBySpeechActivity.remove(endpoint = (AbstractEndpoint)this.endpointsBySpeechActivity.stream().filter(e -> id.equals(e.getId())).findFirst().orElse(null))) {
                    this.logger.warn((Object)("Got active speaker notification for an unknown endpoint: " + id + ", ignoring"));
                    return;
                }
                this.endpointsBySpeechActivity.add(0, endpoint);
                this.recentSpeakers.promote(endpoint);
                endpointListChanged = this.updateLastNEndpoints();
            }
        }
        TaskPools.IO_POOL.execute(() -> {
            listener.recentSpeakersChanged(this.recentSpeakers.getRecentSpeakers(), dominantSpeakerChanged, this.inSilence);
            if (endpointListChanged) {
                listener.lastNEndpointsChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateLastNEndpoints() {
        Object object = this.syncRoot;
        synchronized (object) {
            Map<Boolean, List<AbstractEndpoint>> byVideoAvailable = this.endpointsBySpeechActivity.stream().collect(Collectors.groupingBy(AbstractEndpoint::hasVideoAvailable));
            ArrayList newEndpointsInLastNOrder = new ArrayList(this.endpointsBySpeechActivity.size());
            newEndpointsInLastNOrder.addAll(byVideoAvailable.getOrDefault(true, Collections.emptyList()));
            newEndpointsInLastNOrder.addAll(byVideoAvailable.getOrDefault(false, Collections.emptyList()));
            if (!newEndpointsInLastNOrder.equals(this.endpointsInLastNOrder)) {
                this.endpointsInLastNOrder = Collections.unmodifiableList(newEndpointsInLastNOrder);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expire() {
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.dominantSpeakerIdentification != null) {
                this.dominantSpeakerIdentification.removeActiveSpeakerChangedListener(this.activeSpeakerChangedListener);
            }
            this.listener = null;
            this.dominantSpeakerIdentification = null;
            this.endpointsBySpeechActivity.clear();
            this.endpointsInLastNOrder = Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractEndpoint getDominantEndpoint() {
        Object object = this.syncRoot;
        synchronized (object) {
            return this.recentSpeakers.getRecentSpeakers().stream().findFirst().orElse(null);
        }
    }

    public List<AbstractEndpoint> getOrderedEndpoints() {
        return this.endpointsInLastNOrder;
    }

    @NotNull
    public List<String> getRecentSpeakers() {
        return this.recentSpeakers.getRecentSpeakers().stream().map(AbstractEndpoint::getId).collect(Collectors.toList());
    }

    public boolean isRecentSpeaker(AbstractEndpoint endpoint) {
        return this.recentSpeakers.isRecentSpeaker(endpoint);
    }

    public boolean isAmongLoudest(String endpointId) {
        return this.dominantSpeakerIdentification.isAmongLoudest((Object)endpointId);
    }

    public SpeakerRanking levelChanged(@NotNull AbstractEndpoint endpoint, long level) {
        DominantSpeakerIdentification<String> dsi = this.dominantSpeakerIdentification;
        return dsi != null ? dsi.levelChanged((Object)endpoint.getId(), (int)level) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointsChanged(List<AbstractEndpoint> conferenceEndpoints) {
        boolean dominantSpeakerChanged;
        boolean recentSpeakersChanged;
        boolean endpointsListChanged;
        Object object = this.syncRoot;
        synchronized (object) {
            AbstractEndpoint previousDominantSpeaker = this.endpointsBySpeechActivity.isEmpty() ? null : this.endpointsBySpeechActivity.get(0);
            endpointsListChanged = this.endpointsBySpeechActivity.removeIf(ep -> !conferenceEndpoints.contains(ep));
            recentSpeakersChanged = this.recentSpeakers.removeAllExcept(conferenceEndpoints);
            for (AbstractEndpoint conferenceEndpoint : conferenceEndpoints) {
                if (this.endpointsBySpeechActivity.contains(conferenceEndpoint)) continue;
                this.endpointsBySpeechActivity.add(conferenceEndpoint);
                endpointsListChanged = true;
            }
            AbstractEndpoint newDominantSpeaker = this.endpointsBySpeechActivity.isEmpty() ? null : this.endpointsBySpeechActivity.get(0);
            dominantSpeakerChanged = !Objects.equals(previousDominantSpeaker, newDominantSpeaker);
            recentSpeakersChanged |= dominantSpeakerChanged;
            if (endpointsListChanged) {
                endpointsListChanged = this.updateLastNEndpoints();
            }
        }
        if (recentSpeakersChanged || endpointsListChanged) {
            boolean finalRecentSpeakersChanged = recentSpeakersChanged;
            boolean finalEndpointsChanged = endpointsListChanged;
            Listener listener = this.listener;
            if (listener == null) {
                return;
            }
            TaskPools.IO_POOL.execute(() -> {
                if (finalRecentSpeakersChanged) {
                    listener.recentSpeakersChanged(this.recentSpeakers.getRecentSpeakers(), dominantSpeakerChanged, this.inSilence);
                }
                if (finalEndpointsChanged) {
                    listener.lastNEndpointsChanged();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endpointVideoAvailabilityChanged() {
        boolean endpointsListChanged;
        Object object = this.syncRoot;
        synchronized (object) {
            endpointsListChanged = this.updateLastNEndpoints();
        }
        if (endpointsListChanged) {
            TaskPools.IO_POOL.execute(() -> {
                try {
                    this.listener.lastNEndpointsChanged();
                }
                catch (Throwable e) {
                    this.logger.warn((Object)"Failed to fire event", e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getDebugState(@NotNull DebugStateMode mode) {
        JSONObject debugState = new JSONObject();
        AbstractEndpoint dominantEndpoint = this.getDominantEndpoint();
        debugState.put((Object)"dominantEndpoint", (Object)(dominantEndpoint == null ? "null" : dominantEndpoint.getId()));
        if (mode != DebugStateMode.FULL) {
            return debugState;
        }
        DominantSpeakerIdentification<String> dsi = this.dominantSpeakerIdentification;
        debugState.put((Object)"dominantSpeakerIdentification", (Object)(dsi == null ? null : dsi.doGetJSON()));
        Object object = this.syncRoot;
        synchronized (object) {
            debugState.put((Object)"endpointsBySpeechActivity", this.endpointsBySpeechActivity.stream().map(AbstractEndpoint::getId).collect(Collectors.toList()));
            debugState.put((Object)"endpointsInLastNOrder", this.endpointsInLastNOrder.stream().map(AbstractEndpoint::getId).collect(Collectors.toList()));
        }
        return debugState;
    }

    static interface Listener {
        public void recentSpeakersChanged(List<AbstractEndpoint> var1, boolean var2, boolean var3);

        public void lastNEndpointsChanged();
    }
}

