/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.IPerformanceCollector;
import io.sentry.IPerformanceContinuousCollector;
import io.sentry.IPerformanceSnapshotCollector;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.PerformanceCollectionData;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.TransactionPerformanceCollector;
import io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DefaultTransactionPerformanceCollector
implements TransactionPerformanceCollector {
    private static final long TRANSACTION_COLLECTION_INTERVAL_MILLIS = 100L;
    private static final long TRANSACTION_COLLECTION_TIMEOUT_MILLIS = 30000L;
    @NotNull
    private final Object timerLock = new Object();
    @Nullable
    private volatile Timer timer = null;
    @NotNull
    private final Map<String, List<PerformanceCollectionData>> performanceDataMap = new ConcurrentHashMap<String, List<PerformanceCollectionData>>();
    @NotNull
    private final List<IPerformanceSnapshotCollector> snapshotCollectors;
    @NotNull
    private final List<IPerformanceContinuousCollector> continuousCollectors;
    private final boolean hasNoCollectors;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private long lastCollectionTimestamp = 0L;

    public DefaultTransactionPerformanceCollector(@NotNull SentryOptions options) {
        this.options = Objects.requireNonNull(options, "The options object is required.");
        this.snapshotCollectors = new ArrayList<IPerformanceSnapshotCollector>();
        this.continuousCollectors = new ArrayList<IPerformanceContinuousCollector>();
        @NotNull List<IPerformanceCollector> performanceCollectors = options.getPerformanceCollectors();
        for (IPerformanceCollector performanceCollector : performanceCollectors) {
            if (performanceCollector instanceof IPerformanceSnapshotCollector) {
                this.snapshotCollectors.add((IPerformanceSnapshotCollector)performanceCollector);
            }
            if (!(performanceCollector instanceof IPerformanceContinuousCollector)) continue;
            this.continuousCollectors.add((IPerformanceContinuousCollector)performanceCollector);
        }
        this.hasNoCollectors = this.snapshotCollectors.isEmpty() && this.continuousCollectors.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(@NotNull ITransaction transaction) {
        if (this.hasNoCollectors) {
            this.options.getLogger().log(SentryLevel.INFO, "No collector found. Performance stats will not be captured during transactions.", new Object[0]);
            return;
        }
        for (IPerformanceContinuousCollector collector : this.continuousCollectors) {
            collector.onSpanStarted(transaction);
        }
        if (!this.performanceDataMap.containsKey(transaction.getEventId().toString())) {
            this.performanceDataMap.put(transaction.getEventId().toString(), new ArrayList());
            try {
                this.options.getExecutorService().schedule(() -> this.stop(transaction), 30000L);
            }
            catch (RejectedExecutionException e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. Performance collector will not be automatically finished. Did you call Sentry.close()?", e);
            }
        }
        if (!this.isStarted.getAndSet(true)) {
            Object object = this.timerLock;
            synchronized (object) {
                if (this.timer == null) {
                    this.timer = new Timer(true);
                }
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        for (IPerformanceSnapshotCollector collector : DefaultTransactionPerformanceCollector.this.snapshotCollectors) {
                            collector.setup();
                        }
                    }
                }, 0L);
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        long now = System.currentTimeMillis();
                        if (now - DefaultTransactionPerformanceCollector.this.lastCollectionTimestamp < 10L) {
                            return;
                        }
                        DefaultTransactionPerformanceCollector.this.lastCollectionTimestamp = now;
                        @NotNull PerformanceCollectionData tempData = new PerformanceCollectionData();
                        for (IPerformanceSnapshotCollector collector : DefaultTransactionPerformanceCollector.this.snapshotCollectors) {
                            collector.collect(tempData);
                        }
                        for (List data : DefaultTransactionPerformanceCollector.this.performanceDataMap.values()) {
                            data.add(tempData);
                        }
                    }
                };
                this.timer.scheduleAtFixedRate(timerTask, 100L, 100L);
            }
        }
    }

    @Override
    public void onSpanStarted(@NotNull ISpan span) {
        for (IPerformanceContinuousCollector collector : this.continuousCollectors) {
            collector.onSpanStarted(span);
        }
    }

    @Override
    public void onSpanFinished(@NotNull ISpan span) {
        for (IPerformanceContinuousCollector collector : this.continuousCollectors) {
            collector.onSpanFinished(span);
        }
    }

    @Override
    @Nullable
    public List<PerformanceCollectionData> stop(@NotNull ITransaction transaction) {
        this.options.getLogger().log(SentryLevel.DEBUG, "stop collecting performance info for transactions %s (%s)", transaction.getName(), transaction.getSpanContext().getTraceId().toString());
        @Nullable List<PerformanceCollectionData> data = this.performanceDataMap.remove(transaction.getEventId().toString());
        for (IPerformanceContinuousCollector collector : this.continuousCollectors) {
            collector.onSpanFinished(transaction);
        }
        if (this.performanceDataMap.isEmpty()) {
            this.close();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.options.getLogger().log(SentryLevel.DEBUG, "stop collecting all performance info for transactions", new Object[0]);
        this.performanceDataMap.clear();
        for (IPerformanceContinuousCollector collector : this.continuousCollectors) {
            collector.clear();
        }
        if (this.isStarted.getAndSet(false)) {
            Object object = this.timerLock;
            synchronized (object) {
                if (this.timer != null) {
                    this.timer.cancel();
                    this.timer = null;
                }
            }
        }
    }
}

