/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.videobridge.metrics.Metrics;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\b\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lorg/jitsi/videobridge/stats/ConferencePacketStats;", "", "<init>", "()V", "periodSeconds", "", "stats", "", "", "Lorg/jitsi/videobridge/stats/ConferencePacketStats$Stats;", "stats$1", "totalPackets", "Ljava/util/concurrent/atomic/AtomicLong;", "getTotalPackets", "()Ljava/util/concurrent/atomic/AtomicLong;", "totalBytes", "getTotalBytes", "addValue", "", "conferenceSize", "packetRatePps", "", "bitrateBps", "toJson", "Lorg/json/simple/JSONObject;", "Companion", "Stats", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nConferencePacketStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConferencePacketStats.kt\norg/jitsi/videobridge/stats/ConferencePacketStats\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1869#2,2:84\n1869#2,2:86\n*S KotlinDebug\n*F\n+ 1 ConferencePacketStats.kt\norg/jitsi/videobridge/stats/ConferencePacketStats\n*L\n34#1:84,2\n58#1:86,2\n*E\n"})
public final class ConferencePacketStats {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double periodSeconds = (double)Metrics.INSTANCE.getInterval().toMillis() / (double)1000;
    @NotNull
    private final Map<Integer, Stats> stats$1;
    @NotNull
    private final AtomicLong totalPackets;
    @NotNull
    private final AtomicLong totalBytes;
    public static final int MAX_SIZE = 500;
    @JvmField
    @NotNull
    public static final ConferencePacketStats stats = new ConferencePacketStats();

    /*
     * WARNING - void declaration
     */
    private ConferencePacketStats() {
        Map map;
        Map map2 = map = (Map)new LinkedHashMap();
        ConferencePacketStats conferencePacketStats = this;
        boolean bl = false;
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, 500);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$stats_u24lambda_u240;
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl2 = false;
            $this$stats_u24lambda_u240.put(it, new Stats());
        }
        conferencePacketStats.stats$1 = map;
        this.totalPackets = new AtomicLong();
        this.totalBytes = new AtomicLong();
    }

    @NotNull
    public final AtomicLong getTotalPackets() {
        return this.totalPackets;
    }

    @NotNull
    public final AtomicLong getTotalBytes() {
        return this.totalBytes;
    }

    public final void addValue(int conferenceSize, long packetRatePps, long bitrateBps) {
        block0: {
            Stats stats = this.stats$1.get(RangesKt.coerceAtMost((int)conferenceSize, (int)500));
            if (stats == null) break block0;
            Stats it = stats;
            boolean bl = false;
            long packets = (long)((double)packetRatePps * this.periodSeconds);
            long bytes = (long)((double)bitrateBps * this.periodSeconds / (double)8);
            it.getPackets().addAndGet(packets);
            it.getBytes().addAndGet(bytes);
            this.totalPackets.addAndGet(packets);
            this.totalBytes.addAndGet(bytes);
        }
    }

    @NotNull
    public final JSONObject toJson() {
        JSONObject jSONObject;
        JSONObject $this$toJson_u24lambda_u240 = jSONObject = new JSONObject();
        boolean bl = false;
        JSONArray packetRates = new JSONArray();
        JSONArray bitrates = new JSONArray();
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, 500);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Stats it;
            int element$iv;
            int conferenceSize = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl2 = false;
            if (this.stats$1.get(conferenceSize) == null) continue;
            boolean bl3 = false;
            packetRates.add((Object)it.getPackets().get());
            bitrates.add((Object)it.getBytes().get());
        }
        $this$toJson_u24lambda_u240.put((Object)"packets", (Object)packetRates);
        $this$toJson_u24lambda_u240.put((Object)"bytes", (Object)bitrates);
        $this$toJson_u24lambda_u240.put((Object)"total_packets", (Object)this.totalPackets.get());
        $this$toJson_u24lambda_u240.put((Object)"total_bytes", (Object)this.totalBytes.get());
        return jSONObject;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/stats/ConferencePacketStats$Companion;", "", "<init>", "()V", "MAX_SIZE", "", "stats", "Lorg/jitsi/videobridge/stats/ConferencePacketStats;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jitsi/videobridge/stats/ConferencePacketStats$Stats;", "", "<init>", "()V", "packets", "Ljava/util/concurrent/atomic/AtomicLong;", "getPackets", "()Ljava/util/concurrent/atomic/AtomicLong;", "bytes", "getBytes", "jitsi-videobridge"})
    private static final class Stats {
        @NotNull
        private final AtomicLong packets = new AtomicLong();
        @NotNull
        private final AtomicLong bytes = new AtomicLong();

        @NotNull
        public final AtomicLong getPackets() {
            return this.packets;
        }

        @NotNull
        public final AtomicLong getBytes() {
            return this.bytes;
        }
    }
}

