/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.util.ArrayCache;
import org.jitsi.nlj.util.RtpSequenceIndexTracker;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.util.RtpUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0018\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/jitsi/nlj/rtp/ResumableStreamRewriter;", "", "keepHistory", "", "<init>", "(Z)V", "getKeepHistory", "()Z", "value", "", "seqnumDelta", "getSeqnumDelta", "()I", "history", "Lorg/jitsi/nlj/rtp/ResumableStreamRewriter$StreamRewriteHistory;", "highestSequenceNumberSent", "getHighestSequenceNumberSent", "rewriteRtp", "", "accept", "rtpPacket", "Lorg/jitsi/rtp/rtp/RtpPacket;", "rewriteSequenceNumber", "sequenceNumber", "gapsLeft", "getGapsLeft", "RewriteHistoryItem", "StreamRewriteHistory", "jitsi-media-transform"})
public final class ResumableStreamRewriter {
    private final boolean keepHistory;
    private int seqnumDelta;
    @Nullable
    private StreamRewriteHistory history;
    private int highestSequenceNumberSent;

    public ResumableStreamRewriter(boolean keepHistory) {
        this.keepHistory = keepHistory;
        this.highestSequenceNumberSent = -1;
    }

    public /* synthetic */ ResumableStreamRewriter(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getKeepHistory() {
        return this.keepHistory;
    }

    public final int getSeqnumDelta() {
        return this.seqnumDelta;
    }

    public final int getHighestSequenceNumberSent() {
        return this.highestSequenceNumberSent;
    }

    public final void rewriteRtp(boolean accept, @NotNull RtpPacket rtpPacket) {
        Intrinsics.checkNotNullParameter((Object)rtpPacket, (String)"rtpPacket");
        int sequenceNumber = rtpPacket.getSequenceNumber();
        int newSequenceNumber = this.rewriteSequenceNumber(accept, sequenceNumber);
        if (sequenceNumber != newSequenceNumber) {
            rtpPacket.setSequenceNumber(newSequenceNumber);
        }
    }

    public final int rewriteSequenceNumber(boolean accept, int sequenceNumber) {
        int newDelta;
        StreamRewriteHistory streamRewriteHistory;
        if (this.keepHistory && !accept && this.history == null) {
            this.history = new StreamRewriteHistory(this.highestSequenceNumberSent);
        }
        if ((streamRewriteHistory = this.history) != null) {
            StreamRewriteHistory it = streamRewriteHistory;
            boolean bl = false;
            return it.rewriteSequenceNumber(accept, sequenceNumber);
        }
        if (accept) {
            int newSequenceNumber = sequenceNumber - this.seqnumDelta & 0xFFFF;
            if (this.highestSequenceNumberSent == -1 || RtpUtilsKt.isNewerThan((int)newSequenceNumber, (int)this.highestSequenceNumberSent)) {
                this.highestSequenceNumberSent = newSequenceNumber;
            }
            return newSequenceNumber;
        }
        if (this.highestSequenceNumberSent != -1 && RtpUtilsKt.isNewerThan((int)(newDelta = sequenceNumber - this.highestSequenceNumberSent & 0xFFFF), (int)this.seqnumDelta)) {
            this.seqnumDelta = newDelta;
        }
        return sequenceNumber;
    }

    public final int getGapsLeft() {
        StreamRewriteHistory streamRewriteHistory = this.history;
        return streamRewriteHistory != null ? streamRewriteHistory.getGapsLeft() : 0;
    }

    public ResumableStreamRewriter() {
        this(false, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/nlj/rtp/ResumableStreamRewriter$RewriteHistoryItem;", "", "accept", "", "newIndex", "", "<init>", "(Ljava/lang/Boolean;J)V", "getAccept", "()Ljava/lang/Boolean;", "setAccept", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getNewIndex", "()J", "jitsi-media-transform"})
    private static final class RewriteHistoryItem {
        @Nullable
        private Boolean accept;
        private final long newIndex;

        public RewriteHistoryItem(@Nullable Boolean accept, long newIndex) {
            this.accept = accept;
            this.newIndex = newIndex;
        }

        @Nullable
        public final Boolean getAccept() {
            return this.accept;
        }

        public final void setAccept(@Nullable Boolean bl) {
            this.accept = bl;
        }

        public final long getNewIndex() {
            return this.newIndex;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0016\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0004R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jitsi/nlj/rtp/ResumableStreamRewriter$StreamRewriteHistory;", "Lorg/jitsi/nlj/util/ArrayCache;", "Lorg/jitsi/nlj/rtp/ResumableStreamRewriter$RewriteHistoryItem;", "highestSeqSent", "", "<init>", "(I)V", "firstIndex", "", "getFirstIndex", "()J", "setFirstIndex", "(J)V", "value", "gapsLeft", "getGapsLeft", "()I", "rtpSequenceIndexTracker", "Lorg/jitsi/nlj/util/RtpSequenceIndexTracker;", "fillBetween", "", "start", "end", "firstNewIndex", "rewriteSequenceNumber", "accept", "", "sequenceNumber", "Companion", "jitsi-media-transform"})
    private static final class StreamRewriteHistory
    extends ArrayCache<RewriteHistoryItem> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private long firstIndex = -1L;
        private int gapsLeft;
        @NotNull
        private final RtpSequenceIndexTracker rtpSequenceIndexTracker = new RtpSequenceIndexTracker();
        private static final int MAX_REWRITE_HISTORY = 1000;

        public StreamRewriteHistory(int highestSeqSent) {
            super(1000, StreamRewriteHistory::_init_$lambda$0, false, null, 8, null);
            if (highestSeqSent != -1) {
                this.rewriteSequenceNumber(true, highestSeqSent);
            }
        }

        public final long getFirstIndex() {
            return this.firstIndex;
        }

        public final void setFirstIndex(long l) {
            this.firstIndex = l;
        }

        public final int getGapsLeft() {
            return this.gapsLeft;
        }

        private final void fillBetween(long start, long end, long firstNewIndex) {
            if (end <= this.getLastIndex() - (long)this.getSize() + 1L) {
                return;
            }
            long actualStart = start <= this.getLastIndex() - (long)this.getSize() ? this.getLastIndex() - (long)this.getSize() + 1L : start;
            long newIndex = firstNewIndex;
            long i = actualStart;
            if (i <= end) {
                while (true) {
                    this.insertItem(new RewriteHistoryItem(null, newIndex), i);
                    long l = newIndex;
                    newIndex = l + 1L;
                    if (i == end) break;
                    ++i;
                }
            }
        }

        public final int rewriteSequenceNumber(boolean accept, int sequenceNumber) {
            long index = this.rtpSequenceIndexTracker.update(sequenceNumber);
            long newIndex = 0L;
            if (this.firstIndex == -1L) {
                this.insertItem(new RewriteHistoryItem(accept, index), index);
                this.firstIndex = index;
                newIndex = index;
            } else if (index > this.getLastIndex()) {
                long newestIndex = this.getLastIndex();
                ArrayCache.Container container = ArrayCache.getContainer$default(this, newestIndex, false, 2, null);
                if (container == null) {
                    throw new IllegalStateException("No newest container found");
                }
                ArrayCache.Container newest = container;
                Object t = newest.getItem();
                Intrinsics.checkNotNull(t);
                long newestNewIndex = ((RewriteHistoryItem)t).getNewIndex();
                long indexGap = index - newestIndex;
                long newGap = indexGap - (long)(accept ? 0 : 1);
                newIndex = newestNewIndex + newGap;
                this.insertItem(new RewriteHistoryItem(accept, newIndex), index);
                this.fillBetween(newestIndex + 1L, index - 1L, newestNewIndex + 1L);
            } else if (index > this.getLastIndex() - (long)this.getSize() && index >= this.firstIndex) {
                ArrayCache.Container container = ArrayCache.getContainer$default(this, index, false, 2, null);
                if (container == null) {
                    throw new IllegalStateException("No container found for index " + index + " in history");
                }
                ArrayCache.Container container2 = container;
                Object t = container2.getItem();
                Intrinsics.checkNotNull(t);
                RewriteHistoryItem item = (RewriteHistoryItem)t;
                if (item.getAccept() == null) {
                    item.setAccept(accept);
                    if (!accept) {
                        int newest = this.gapsLeft;
                        this.gapsLeft = newest + 1;
                    }
                }
                newIndex = item.getNewIndex();
            } else if (index > this.getLastIndex() - (long)this.getSize() && index < this.firstIndex) {
                long oldestIndex = Math.max(this.getLastIndex() - (long)this.getSize() + 1L, this.firstIndex);
                ArrayCache.Container container = ArrayCache.getContainer$default(this, oldestIndex, false, 2, null);
                if (container == null) {
                    throw new IllegalStateException("No oldest container found");
                }
                ArrayCache.Container oldest = container;
                Object t = oldest.getItem();
                Intrinsics.checkNotNull(t);
                long oldestNewIndex = ((RewriteHistoryItem)t).getNewIndex();
                long indexGap = index - oldestIndex;
                long newGap = indexGap + (long)(accept ? 0 : 1);
                newIndex = oldestNewIndex + newGap;
                this.insertItem(new RewriteHistoryItem(accept, newIndex), index);
                this.fillBetween(index + 1L, oldestIndex - 1L, newIndex + 1L);
                this.firstIndex = index;
            } else {
                long oldestIndex = Math.max(this.getLastIndex() - (long)this.getSize() + 1L, this.firstIndex);
                ArrayCache.Container container = ArrayCache.getContainer$default(this, oldestIndex, false, 2, null);
                if (container == null) {
                    throw new IllegalStateException("No oldest container found");
                }
                ArrayCache.Container oldest = container;
                Object t = oldest.getItem();
                Intrinsics.checkNotNull(t);
                long oldestDelta = oldestIndex - ((RewriteHistoryItem)t).getNewIndex();
                newIndex = index - oldestDelta;
            }
            if (accept) {
                return StreamRewriteHistory.Companion.toSequenceNumber(newIndex);
            }
            return sequenceNumber;
        }

        private static final RewriteHistoryItem _init_$lambda$0(RewriteHistoryItem it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jitsi/nlj/rtp/ResumableStreamRewriter$StreamRewriteHistory$Companion;", "", "<init>", "()V", "MAX_REWRITE_HISTORY", "", "toSequenceNumber", "index", "", "jitsi-media-transform"})
        public static final class Companion {
            private Companion() {
            }

            private final int toSequenceNumber(long index) {
                return (int)(index & 0xFFFFL);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

