/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.util;

import java.time.Clock;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.stats.RateTracker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0012\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u000eJ\u0010\u0010\u001a\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lorg/jitsi/nlj/util/BitrateTracker;", "", "windowSize", "Ljava/time/Duration;", "bucketSize", "clock", "Ljava/time/Clock;", "<init>", "(Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Clock;)V", "tracker", "Lorg/jitsi/utils/stats/RateTracker;", "getRate", "Lorg/jitsi/nlj/util/Bandwidth;", "nowMs", "", "getRate-WElJv5I", "(J)J", "getRateBps", "rate", "getRate-rlWvAKk", "()J", "update", "", "dataSize", "Lorg/jitsi/nlj/util/DataSize;", "now", "getAccumulatedSize", "jitsi-media-transform"})
public class BitrateTracker {
    @NotNull
    private final Duration windowSize;
    @NotNull
    private final Duration bucketSize;
    @NotNull
    private final Clock clock;
    @NotNull
    private final RateTracker tracker;

    @JvmOverloads
    public BitrateTracker(@NotNull Duration windowSize, @NotNull Duration bucketSize, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)windowSize, (String)"windowSize");
        Intrinsics.checkNotNullParameter((Object)bucketSize, (String)"bucketSize");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.windowSize = windowSize;
        this.bucketSize = bucketSize;
        this.clock = clock;
        this.tracker = new RateTracker(this.windowSize, this.bucketSize, this.clock);
    }

    public /* synthetic */ BitrateTracker(Duration duration, Duration duration2, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            duration2 = DurationKt.getMs((int)1);
        }
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(duration, duration2, clock);
    }

    public long getRate-WElJv5I(long nowMs) {
        return BandwidthKt.getBps(this.tracker.getRate(nowMs));
    }

    public static /* synthetic */ long getRate-WElJv5I$default(BitrateTracker bitrateTracker, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRate-WElJv5I");
        }
        if ((n & 1) != 0) {
            l = bitrateTracker.clock.millis();
        }
        return bitrateTracker.getRate-WElJv5I(l);
    }

    @JvmOverloads
    public long getRateBps(long nowMs) {
        return this.tracker.getRate(nowMs);
    }

    public static /* synthetic */ long getRateBps$default(BitrateTracker bitrateTracker, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRateBps");
        }
        if ((n & 1) != 0) {
            l = bitrateTracker.clock.millis();
        }
        return bitrateTracker.getRateBps(l);
    }

    public final long getRate-rlWvAKk() {
        return BitrateTracker.getRate-WElJv5I$default(this, 0L, 1, null);
    }

    public final void update(@NotNull DataSize dataSize, long now) {
        Intrinsics.checkNotNullParameter((Object)dataSize, (String)"dataSize");
        this.tracker.update(dataSize.getBits(), now);
    }

    public static /* synthetic */ void update$default(BitrateTracker bitrateTracker, DataSize dataSize, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 2) != 0) {
            l = bitrateTracker.clock.millis();
        }
        bitrateTracker.update(dataSize, l);
    }

    @NotNull
    public final DataSize getAccumulatedSize(long now) {
        return DataSizeKt.getBits(this.tracker.getAccumulatedCount(now));
    }

    public static /* synthetic */ DataSize getAccumulatedSize$default(BitrateTracker bitrateTracker, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAccumulatedSize");
        }
        if ((n & 1) != 0) {
            l = bitrateTracker.clock.millis();
        }
        return bitrateTracker.getAccumulatedSize(l);
    }

    @JvmOverloads
    public BitrateTracker(@NotNull Duration windowSize, @NotNull Duration bucketSize) {
        Intrinsics.checkNotNullParameter((Object)windowSize, (String)"windowSize");
        Intrinsics.checkNotNullParameter((Object)bucketSize, (String)"bucketSize");
        this(windowSize, bucketSize, null, 4, null);
    }

    @JvmOverloads
    public BitrateTracker(@NotNull Duration windowSize) {
        Intrinsics.checkNotNullParameter((Object)windowSize, (String)"windowSize");
        this(windowSize, null, null, 6, null);
    }

    @JvmOverloads
    public final long getRateBps() {
        return BitrateTracker.getRateBps$default(this, 0L, 1, null);
    }
}

