/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.rating.RatingProvider;

public class MovieFetchRatingsTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieFetchRatingsTask.class);
    private final List<Movie> movies;
    private final List<RatingProvider.RatingSource> sources;

    public MovieFetchRatingsTask(Collection<Movie> movies, Collection<RatingProvider.RatingSource> sources) {
        super(TmmResourceBundle.getString("movie.fetchratings"), movies.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.movies = new ArrayList<Movie>(movies);
        this.sources = new ArrayList<RatingProvider.RatingSource>(sources);
    }

    @Override
    protected void doInBackground() {
        LOGGER.debug("fetching ratings...");
        int i = 0;
        for (Movie movie : this.movies) {
            List<MediaRating> ratings = RatingProvider.getRatings(movie.getIds(), this.sources, MediaType.MOVIE);
            ratings.forEach(movie::setRating);
            if (!ratings.isEmpty()) {
                movie.saveToDb();
                movie.writeNFO();
            }
            this.publishState(++i);
            if (!this.cancel) continue;
            break;
        }
    }
}

