/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.imdb;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.http.OnDiskCachedUrl;

public class ImdbDatasetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImdbDatasetUtils.class);
    static final String IMDB_DATASET_NAME_BASICS = "name.basics.tsv";
    static final String IMDB_DATASET_TITLE_AKAS = "title.akas.tsv";
    static final String IMDB_DATASET_TITLE_BASICS = "title.basics.tsv";
    static final String IMDB_DATASET_TITLE_CREW = "title.crew.tsv";
    static final String IMDB_DATASET_TITLE_EPISODE = "title.episode.tsv";
    static final String IMDB_DATASET_TITLE_PRINCIPALS = "title.principals.tsv";
    static final String IMDB_DATASET_TITLE_RATINGS = "title.ratings.tsv";
    private static MVStore mvStore;
    private static MVMap<String, List<String>> dbEpisodeMap;
    private static Map<String, List<String>> javaEpisodeMap;

    private static synchronized void initMap() {
        if (mvStore == null) {
            ImdbDatasetUtils.initEpisodeDataset();
        }
    }

    private static boolean downloadDataset(String dataset, int cacheDays) throws MalformedURLException {
        LOGGER.debug("Downloading dataset {}", (Object)dataset);
        Path downloadedFile = Paths.get(Globals.CACHE_FOLDER, dataset + ".gz");
        Utils.deleteFileSafely(downloadedFile);
        OnDiskCachedUrl imdbUrl = new OnDiskCachedUrl("https://datasets.imdbws.com/" + dataset + ".gz", cacheDays, TimeUnit.DAYS);
        return imdbUrl.download(downloadedFile);
    }

    private static Path unpackDataset(String dataset) throws FileNotFoundException, IOException {
        LOGGER.debug("Unpacking dataset {}", (Object)dataset);
        Path downloadedFile = Paths.get(Globals.CACHE_FOLDER, dataset + ".gz");
        Path extractedFile = Paths.get(Globals.CACHE_FOLDER, dataset);
        Utils.deleteFileSafely(extractedFile);
        try (GZIPInputStream gis = new GZIPInputStream(new FileInputStream(downloadedFile.toFile()));){
            Files.copy(gis, extractedFile, new CopyOption[0]);
        }
        Utils.deleteFileSafely(downloadedFile);
        return extractedFile;
    }

    public List<MediaMetadata> getEpisodesByShowId(String showId) {
        ImdbDatasetUtils.initMap();
        try {
            List epsTsv = (List)dbEpisodeMap.get((Object)showId);
            if (epsTsv == null || epsTsv.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<MediaMetadata> ret = new ArrayList<MediaMetadata>();
            epsTsv.forEach(ep -> {
                String[] tsv = ep.split("\t");
                DatasetEpisode data = new DatasetEpisode(tsv[0], tsv[2], tsv[3]);
                MediaMetadata md = new MediaMetadata("imdb");
                md.setId("imdb", data.id);
                MediaEpisodeNumber see = new MediaEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, data.s, data.e);
                md.setEpisodeNumber(see);
                md.setTitle("found S" + see.season() + " E" + see.episode() + " - title will be scraped later");
                ret.add(md);
            });
            return ret;
        }
        catch (Exception e) {
            LOGGER.debug("could not read the MVstore - '{}'", (Object)e.getMessage());
            ImdbDatasetUtils.shutdown();
            Utils.deleteFileSafely(Paths.get(Globals.CACHE_FOLDER, "title.episode.tsv.db"));
            return Collections.emptyList();
        }
    }

    private static void initEpisodeDataset() {
        block16: {
            Path databaseFile = Paths.get(Globals.CACHE_FOLDER, "title.episode.tsv.db");
            long cut = LocalDateTime.now().minusMonths(1L).toEpochSecond(ZoneOffset.UTC);
            try {
                if (!Files.exists(databaseFile, new LinkOption[0]) || Files.getLastModifiedTime(databaseFile, new LinkOption[0]).to(TimeUnit.SECONDS) < cut) {
                    LOGGER.debug("Preparing IMDB episode dataset...");
                    boolean ok = ImdbDatasetUtils.downloadDataset(IMDB_DATASET_TITLE_EPISODE, 90);
                    if (ok) {
                        Path extractedFile = ImdbDatasetUtils.unpackDataset(IMDB_DATASET_TITLE_EPISODE);
                        LOGGER.debug("Parsing dataset...");
                        javaEpisodeMap = new TreeMap<String, List<String>>();
                        try (Stream<String> stream = Files.lines(extractedFile, StandardCharsets.UTF_8);){
                            stream.skip(1L).forEach(line -> {
                                String[] data = line.split("\t");
                                javaEpisodeMap.computeIfAbsent(data[1], k -> new ArrayList()).add(line);
                            });
                        }
                        catch (Exception e) {
                            LOGGER.debug("Error writing archive {}", (Object)e.getMessage());
                        }
                        LOGGER.debug("Copying map to database...");
                        try {
                            mvStore = new MVStore.Builder().fileName(databaseFile.toString()).compress().autoCommitDisabled().open();
                        }
                        catch (Exception e) {
                            LOGGER.debug("Could not open IMDB episode database - '{}'", (Object)e.getMessage());
                            Utils.deleteFileSafely(databaseFile);
                            mvStore = new MVStore.Builder().fileName(databaseFile.toString()).compress().autoCommitDisabled().open();
                        }
                        dbEpisodeMap = mvStore.openMap("imdbEpisodes");
                        dbEpisodeMap.putAll(javaEpisodeMap);
                        mvStore.commit();
                        javaEpisodeMap.clear();
                        javaEpisodeMap = null;
                        LOGGER.debug("Done!");
                        break block16;
                    }
                    if (Files.exists(databaseFile, new LinkOption[0])) {
                        LOGGER.debug("download failed - using old copy");
                        mvStore = new MVStore.Builder().fileName(databaseFile.toString()).readOnly().open();
                        dbEpisodeMap = mvStore.openMap("imdbEpisodes");
                    }
                    break block16;
                }
                LOGGER.debug("Dataset young enough, no need to download...");
                mvStore = new MVStore.Builder().fileName(databaseFile.toString()).readOnly().open();
                dbEpisodeMap = mvStore.openMap("imdbEpisodes");
            }
            catch (Exception e) {
                LOGGER.debug("Error initializing dataset: IMDB_DATASET_TITLE_EPISODE {}", (Object)e.getMessage());
                Utils.deleteFileSafely(databaseFile);
            }
        }
    }

    private static synchronized void shutdown() {
        try {
            if (mvStore != null && !mvStore.isClosed()) {
                mvStore.close();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Could not close MVstore - deleting the cache");
        }
        finally {
            mvStore = null;
            dbEpisodeMap = null;
            javaEpisodeMap = null;
        }
    }

    static class DatasetEpisode
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String id;
        int s = -1;
        int e = -1;

        public DatasetEpisode(String episodeId, String seasonNr, String episodeNr) {
            this.id = episodeId;
            try {
                this.s = Integer.parseInt(seasonNr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.e = Integer.parseInt(episodeNr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

