/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import com.floreysoft.jmte.Engine;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.jmte.JmteUtils;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.tree.TmmTreeTextFilter;
import org.tinymediamanager.ui.tvshows.TvShowTreeDataProvider;

public class TvShowTreeTextFilter<E extends TmmTreeNode>
extends TmmTreeTextFilter<E> {
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private static final Engine ENGINE = TvShowRenamer.createEngine();

    @Override
    protected String prepareFilterText() {
        return StrgUtils.normalizeString(this.getText());
    }

    @Override
    public boolean accept(E node) {
        if (StringUtils.isBlank((CharSequence)this.filterText)) {
            return true;
        }
        if (node instanceof TvShowTreeDataProvider.AbstractTvShowTreeNode) {
            Matcher matcher;
            TvShowTreeDataProvider.AbstractTvShowTreeNode treeNode = (TvShowTreeDataProvider.AbstractTvShowTreeNode)node;
            if (this.settings.getNode() && (matcher = this.filterPattern.matcher(StrgUtils.normalizeString(treeNode.toString()))).find()) {
                return true;
            }
            if (this.settings.getTitle() && (matcher = this.filterPattern.matcher(StrgUtils.normalizeString(treeNode.getTitle()))).find()) {
                return true;
            }
            if (this.settings.getOriginalTitle() && (matcher = this.filterPattern.matcher(StrgUtils.normalizeString(treeNode.getOriginalTitle()))).find()) {
                return true;
            }
            if (this.settings.getEnglishTitle() && (matcher = this.filterPattern.matcher(StrgUtils.normalizeString(treeNode.getEnglishTitle()))).find()) {
                return true;
            }
            Enumeration<TreeNode> e = ((DefaultMutableTreeNode)node).children();
            while (e.hasMoreElements()) {
                if (!this.accept((TmmTreeNode)e.nextElement())) continue;
                return true;
            }
            if (this.checkParent(((TmmTreeNode)node).getDataProvider().getParent(treeNode), this.filterPattern)) {
                return true;
            }
            return this.matchByShortFilter(treeNode);
        }
        return super.accept(node);
    }

    @Override
    protected boolean checkParent(TmmTreeNode node, Pattern pattern) {
        if (node == null) {
            return false;
        }
        if (node instanceof TvShowTreeDataProvider.AbstractTvShowTreeNode) {
            TvShowTreeDataProvider.AbstractTvShowTreeNode treeNode = (TvShowTreeDataProvider.AbstractTvShowTreeNode)node;
            Matcher matcher = pattern.matcher(StrgUtils.normalizeString(treeNode.toString()));
            if (matcher.find()) {
                return true;
            }
            matcher = pattern.matcher(StrgUtils.normalizeString(treeNode.getTitle()));
            if (matcher.find()) {
                return true;
            }
            matcher = pattern.matcher(StrgUtils.normalizeString(treeNode.getOriginalTitle()));
            if (matcher.find()) {
                return true;
            }
            if (this.checkParent(node.getDataProvider().getParent(node), pattern)) {
                return true;
            }
            return this.matchByShortFilter(treeNode);
        }
        return super.checkParent(node, pattern);
    }

    private boolean matchByShortFilter(TvShowTreeDataProvider.AbstractTvShowTreeNode treeNode) {
        block14: {
            if (this.filterText.matches("\\w+:\\w[\\w\\s]+")) {
                String[] kv = this.filterText.split(":");
                Object userObject = treeNode.getUserObject();
                try {
                    PropertyDescriptor pd = null;
                    if (userObject instanceof TvShow) {
                        pd = new PropertyDescriptor(kv[0], TvShow.class);
                    } else if (userObject instanceof TvShowSeason) {
                        pd = new PropertyDescriptor(kv[0], TvShowSeason.class);
                    } else if (userObject instanceof TvShowEpisode) {
                        pd = new PropertyDescriptor(kv[0], TvShowEpisode.class);
                    }
                    Method getter = pd.getReadMethod();
                    Object f = getter.invoke(userObject, new Object[0]);
                    String res = String.valueOf(f).toLowerCase(Locale.ROOT);
                    if (res.contains(kv[1].toLowerCase(Locale.ROOT))) {
                        return true;
                    }
                }
                catch (Exception e) {
                    if (!TvShowRenamer.getTokenMap().containsKey(kv[0])) break block14;
                    HashMap<String, MediaEntity> root = new HashMap<String, MediaEntity>();
                    if (userObject instanceof TvShow) {
                        root.put("tvShow", (TvShow)userObject);
                    } else if (userObject instanceof TvShowSeason) {
                        root.put("season", (TvShowSeason)userObject);
                    } else if (userObject instanceof TvShowEpisode) {
                        root.put("episode", (TvShowEpisode)userObject);
                    }
                    String val = ENGINE.transform(JmteUtils.morphTemplate("${" + kv[0] + "}", TvShowRenamer.getTokenMap()), root);
                    if (!StringUtils.containsIgnoreCase((CharSequence)val, (CharSequence)kv[1])) break block14;
                    return true;
                }
            }
        }
        return false;
    }
}

