/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.formdev.flatlaf.ui.FlatTableHeaderUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TmmTableHeaderUI
extends FlatTableHeaderUI {
    public static ComponentUI createUI(JComponent c) {
        return new TmmTableHeaderUI();
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.bottomSeparatorColor = null;
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        TableCellRenderer defaultRenderer = this.header.getDefaultRenderer();
        boolean paintBorders = this.isDefaultRenderer(defaultRenderer);
        if (!paintBorders && this.header.getColumnModel().getColumnCount() > 0) {
            Component rendererComponent = defaultRenderer.getTableCellRendererComponent(this.header.getTable(), "", false, false, -1, 0);
            paintBorders = this.isDefaultRenderer(rendererComponent);
        }
        if (paintBorders) {
            this.paintMyColumnBorders(g, c);
        }
        if (paintBorders) {
            this.paintMyDraggedColumnBorders(g, c);
        }
    }

    private boolean isDefaultRenderer(Object headerRenderer) {
        String rendererClassName = headerRenderer.getClass().getName();
        return rendererClassName.equals("sun.swing.table.DefaultTableCellHeaderRenderer") || rendererClassName.equals("sun.swing.FilePane$AlignableTableHeaderRenderer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintMyColumnBorders(Graphics g, JComponent c) {
        float lineWidth;
        int width = c.getWidth();
        int height = c.getHeight();
        float topLineIndent = lineWidth = UIScale.scale((float)1.0f);
        float bottomLineIndent = 0.0f;
        TableColumnModel columnModel = this.header.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            FlatUIUtils.setRenderingHints((Graphics)g2);
            g2.setColor(this.bottomSeparatorColor);
            g2.fill(new Rectangle2D.Float(0.0f, (float)height - lineWidth, width, lineWidth));
            int sepCount = columnCount - 1;
            ArrayList colsWoRightGrid = new ArrayList();
            if (this.header.getTable().getClientProperty("borderNotToDraw") != null) {
                colsWoRightGrid = (ArrayList)this.header.getTable().getClientProperty("borderNotToDraw");
            }
            if (this.header.getComponentOrientation().isLeftToRight()) {
                int x = 0;
                for (int i = 0; i < sepCount; ++i) {
                    x += columnModel.getColumn(i).getWidth();
                    if (colsWoRightGrid.contains(i)) continue;
                    g2.drawLine(x - 1, (int)topLineIndent, x - 1, (int)((float)height - bottomLineIndent));
                }
            } else {
                int x = width;
                for (int i = 0; i < sepCount; ++i) {
                    g2.fill(new Rectangle2D.Float((float)(x -= columnModel.getColumn(i).getWidth()) - (i < sepCount - 1 ? lineWidth : 0.0f), topLineIndent, lineWidth, (float)height - bottomLineIndent));
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintMyDraggedColumnBorders(Graphics g, JComponent c) {
        TableColumn draggedColumn = this.header.getDraggedColumn();
        if (draggedColumn != null) {
            TableColumnModel columnModel = this.header.getColumnModel();
            int columnCount = columnModel.getColumnCount();
            int draggedColumnIndex = -1;
            for (int i = 0; i < columnCount; ++i) {
                if (columnModel.getColumn(i) != draggedColumn) continue;
                draggedColumnIndex = i;
                break;
            }
            if (draggedColumnIndex >= 0) {
                float lineWidth;
                float topLineIndent = lineWidth = UIScale.scale((float)1.0f);
                float bottomLineIndent = lineWidth * 3.0f;
                Rectangle r = this.header.getHeaderRect(draggedColumnIndex);
                r.x += this.header.getDraggedDistance();
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    FlatUIUtils.setRenderingHints((Graphics)g2);
                    g2.setColor(this.bottomSeparatorColor);
                    g2.fill(new Rectangle2D.Float(r.x, (float)(r.y + r.height) - lineWidth, r.width, lineWidth));
                    g2.fill(new Rectangle2D.Float(r.x, topLineIndent, lineWidth, (float)r.height - bottomLineIndent));
                    g2.fill(new Rectangle2D.Float((float)(r.x + r.width) - lineWidth, (float)r.y + topLineIndent, lineWidth, (float)r.height - bottomLineIndent));
                }
                finally {
                    g2.dispose();
                }
            }
        }
    }

    private JScrollPane getMyScrollPane() {
        Container parent = this.header.getParent();
        if (parent == null) {
            return null;
        }
        return (parent = parent.getParent()) instanceof JScrollPane ? (JScrollPane)parent : null;
    }
}

