/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.component;

import java.util.Collection;
import java.util.Formatter;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.component.AuditDuration;

@XmlRootElement(name="duration")
public final class AuditDurationImpl
implements AuditDuration {
    private static final AuditDuration defaultInstance = new AuditDurationImpl();
    private static final long msInSec = 1000L;
    private static final int secInMin = 60;
    private static final int minInHour = 60;
    @XmlAttribute
    private final long start;
    @XmlAttribute
    private final long finish;

    private AuditDurationImpl() {
        this(0L, 0L);
    }

    private AuditDurationImpl(long start, long finish) {
        this.start = start;
        this.finish = finish;
        assert (finish >= start);
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getFinish() {
        return this.finish;
    }

    @Override
    public long getDifference() {
        return this.finish - this.start;
    }

    @Override
    @XmlValue
    public String getDuration() {
        return AuditDurationImpl.getStringDuration(this.getDifference());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AuditDurationImpl that = (AuditDurationImpl)obj;
        return this.start == that.start && this.finish == that.finish;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.finish);
    }

    public String toString() {
        return "AuditDurationImpl [start=" + this.start + ", finish=" + this.finish + ", getDifference()=" + this.getDifference() + ", getDuration()=" + this.getDuration() + "]";
    }

    static AuditDuration defaultInstance() {
        return defaultInstance;
    }

    static AuditDuration fromValues(long start, long finish) {
        if (start < 0L || finish < 0L) {
            throw new IllegalArgumentException("start:" + start + " and finish:" + finish + " must be >= 0");
        }
        if (start > finish) {
            throw new IllegalArgumentException("start:" + start + " must not be > finish:" + finish);
        }
        return new AuditDurationImpl(start, finish);
    }

    public static String getStringDuration(long difference) {
        try (Formatter formatter = new Formatter();){
            long hours = difference / 3600000L;
            long minutes = difference / 60000L % 60L;
            long seconds = difference / 1000L % 60L;
            long millis = difference % 1000L;
            formatter.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, millis);
            String string = formatter.toString();
            return string;
        }
    }

    public static AuditDuration sumDuration(Collection<AuditDuration> durations) {
        long start = 0L;
        long finish = 0L;
        if (durations != null) {
            for (AuditDuration duration : durations) {
                if (start == 0L || duration.getStart() < start) {
                    start = duration.getStart();
                }
                if (duration.getFinish() <= finish) continue;
                finish = duration.getFinish();
            }
        }
        return AuditDurationImpl.fromValues(start, finish);
    }

    static class Adapter
    extends XmlAdapter<AuditDurationImpl, AuditDuration> {
        Adapter() {
        }

        @Override
        public AuditDuration unmarshal(AuditDurationImpl procResultImpl) {
            return procResultImpl;
        }

        @Override
        public AuditDurationImpl marshal(AuditDuration procResult) {
            return (AuditDurationImpl)procResult;
        }
    }
}

