/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.ArrayList;
import java.util.List;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.ExtGStateFeaturesObjectAdapter;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.tools.FeatureTreeNode;

public class ExtGStateFeaturesObject
extends FeaturesObject {
    private static final String ID = "id";
    private static final String GRAPHICS_STATE = "graphicsState";
    private static final String TRANSPARENCY = "transparency";
    private static final String STROKE_ADJUSTMENT = "strokeAdjustment";
    private static final String OVERPRINT_FOR_STROKE = "overprintForStroke";
    private static final String OVERPRINT_FOR_FILL = "overprintForFill";

    public ExtGStateFeaturesObject(ExtGStateFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.EXT_G_STATE;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        String fontChildID;
        Boolean overprintForFill;
        Boolean overprintForStroke;
        Boolean strokeAdjustment;
        Boolean transparency;
        ExtGStateFeaturesObjectAdapter docSecAdapter = (ExtGStateFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode(GRAPHICS_STATE);
        String id = docSecAdapter.getId();
        if (id != null) {
            root.setAttribute(ID, id);
        }
        if ((transparency = docSecAdapter.getTransparency()) != null) {
            root.addChild(TRANSPARENCY).setValue(String.valueOf(transparency));
        }
        if ((strokeAdjustment = docSecAdapter.getStrokeAdjustment()) != null) {
            root.addChild(STROKE_ADJUSTMENT).setValue(String.valueOf(strokeAdjustment));
        }
        if ((overprintForStroke = docSecAdapter.getOverprintForStroke()) != null) {
            root.addChild(OVERPRINT_FOR_STROKE).setValue(String.valueOf(overprintForStroke));
        }
        if ((overprintForFill = docSecAdapter.getOverprintForFill()) != null) {
            root.addChild(OVERPRINT_FOR_FILL).setValue(String.valueOf(overprintForFill));
        }
        if ((fontChildID = docSecAdapter.getFontChildId()) != null) {
            FeatureTreeNode resources = root.addChild("resources");
            FeatureTreeNode fonts = resources.addChild("fonts");
            FeatureTreeNode font = fonts.addChild("font");
            font.setAttribute(ID, fontChildID);
        }
        return root;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        ArrayList<Feature> featuresList = new ArrayList<Feature>();
        featuresList.add(new Feature("Transparency", ExtGStateFeaturesObject.generateVariableXPath(GRAPHICS_STATE, TRANSPARENCY), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Stroke Adjustment", ExtGStateFeaturesObject.generateVariableXPath(GRAPHICS_STATE, STROKE_ADJUSTMENT), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Overprint For Stroke", ExtGStateFeaturesObject.generateVariableXPath(GRAPHICS_STATE, OVERPRINT_FOR_STROKE), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Overprint For Fill", ExtGStateFeaturesObject.generateVariableXPath(GRAPHICS_STATE, OVERPRINT_FOR_FILL), Feature.FeatureType.BOOLEAN));
        featuresList.add(new Feature("Error IDs", ExtGStateFeaturesObject.generateAttributeXPath(GRAPHICS_STATE, "errorId"), Feature.FeatureType.STRING));
        return featuresList;
    }
}

