/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ'\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0012J/\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u0006\u0012\u0002\b\u00030\u0011H\u0002J=\u0010\u0019\u001a\u00020\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnSyntaxAndLabelChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;)V", "returnNotAllowedFactoryOrNull", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "targetSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;)Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "returnNotAllowedInExpressionBodyFactoryOrNull", "edgeCase", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;Z)Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "expressionBodyOrNull", "Lorg/jetbrains/kotlin/fir/expressions/impl/FirSingleExpressionBlock;", "checkBuiltInSuspend", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirReturnSyntaxAndLabelChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReturnSyntaxAndLabelChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnSyntaxAndLabelChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1#2:157\n56#3:158\n1761#4,3:159\n*S KotlinDebug\n*F\n+ 1 FirReturnSyntaxAndLabelChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReturnSyntaxAndLabelChecker\n*L\n146#1:158\n146#1:159,3\n*E\n"})
public final class FirReturnSyntaxAndLabelChecker
extends FirExpressionChecker<FirReturnExpression> {
    @NotNull
    public static final FirReturnSyntaxAndLabelChecker INSTANCE = new FirReturnSyntaxAndLabelChecker();

    private FirReturnSyntaxAndLabelChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirReturnExpression expression2) {
        KtDiagnosticFactory0 ktDiagnosticFactory0;
        KtSourceElement source;
        block11: {
            block10: {
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                KtSourceElement ktSourceElement = source = expression2.getSource();
                if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.ImplicitReturn) break block10;
                KtSourceElement ktSourceElement2 = source;
                if (!((ktSourceElement2 != null ? ktSourceElement2.getKind() : null) instanceof KtFakeSourceElementKind.DelegatedPropertyAccessor)) break block11;
            }
            return;
        }
        FirFunction labeledElement = expression2.getTarget().getLabeledElement();
        FirFunctionSymbol<FirFunction> targetSymbol = labeledElement.getSymbol();
        FirErrorFunction firErrorFunction = labeledElement instanceof FirErrorFunction ? (FirErrorFunction)labeledElement : null;
        ConeDiagnostic coneDiagnostic = firErrorFunction != null ? firErrorFunction.getDiagnostic() : null;
        ConeSimpleDiagnostic coneSimpleDiagnostic = coneDiagnostic instanceof ConeSimpleDiagnostic ? (ConeSimpleDiagnostic)coneDiagnostic : null;
        DiagnosticKind diagnosticKind = coneSimpleDiagnostic != null ? coneSimpleDiagnostic.getKind() : null;
        switch (diagnosticKind == null ? -1 : WhenMappings.$EnumSwitchMapping$0[diagnosticKind.ordinal()]) {
            case 1: {
                KtDiagnosticFactory0 ktDiagnosticFactory02 = FirErrors.INSTANCE.getNOT_A_FUNCTION_LABEL();
                break;
            }
            case 2: {
                KtDiagnosticFactory0 ktDiagnosticFactory02 = FirErrors.INSTANCE.getUNRESOLVED_LABEL();
                break;
            }
            default: {
                KtDiagnosticFactory0 ktDiagnosticFactory02 = ktDiagnosticFactory0 = this.returnNotAllowedFactoryOrNull(context2, targetSymbol);
            }
        }
        if (ktDiagnosticFactory0 != null) {
            KtDiagnosticFactory0 it = ktDiagnosticFactory0;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, it, null, 8, null);
        }
        this.checkBuiltInSuspend(context2, reporter, targetSymbol, source);
        if (LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.AllowReturnInExpressionBodyWithExplicitType)) {
            FirSingleExpressionBlock firSingleExpressionBlock = this.expressionBodyOrNull(targetSymbol);
            FirStatement it = firSingleExpressionBlock != null ? firSingleExpressionBlock.getStatement() : null;
            boolean bl = false;
            boolean bl2 = it instanceof FirReturnExpression && Intrinsics.areEqual((Object)((FirReturnExpression)it).getResult(), (Object)expression2);
            if (bl2 && DeclarationUtilsKt.getHasExplicitReturnType((FirCallableSymbol)targetSymbol)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getREDUNDANT_RETURN(), null, 8, null);
            }
        }
    }

    private final KtDiagnosticFactory0 returnNotAllowedFactoryOrNull(CheckerContext context2, FirFunctionSymbol<?> targetSymbol) {
        boolean existingFalseNegative = false;
        for (FirBasedSymbol containingDeclaration : CollectionsKt.asReversed(context2.getContainingDeclarations())) {
            FirBasedSymbol firBasedSymbol = containingDeclaration;
            if (firBasedSymbol instanceof FirClassSymbol) {
                return FirErrors.INSTANCE.getRETURN_NOT_ALLOWED();
            }
            if (firBasedSymbol instanceof FirFunctionSymbol && Intrinsics.areEqual((Object)containingDeclaration, targetSymbol)) {
                return this.returnNotAllowedInExpressionBodyFactoryOrNull(context2, targetSymbol, existingFalseNegative);
            }
            if (firBasedSymbol instanceof FirAnonymousFunctionSymbol) {
                if (!((FirAnonymousFunctionSymbol)containingDeclaration).getInlineStatus().getReturnAllowed()) {
                    return FirErrors.INSTANCE.getRETURN_NOT_ALLOWED();
                }
                existingFalseNegative = true;
                continue;
            }
            if (firBasedSymbol instanceof FirFunctionSymbol) {
                return FirErrors.INSTANCE.getRETURN_NOT_ALLOWED();
            }
            if (firBasedSymbol instanceof FirPropertySymbol) {
                if (!((FirPropertySymbol)containingDeclaration).isLocal()) {
                    return FirErrors.INSTANCE.getRETURN_NOT_ALLOWED();
                }
                existingFalseNegative = true;
                continue;
            }
            if (!(firBasedSymbol instanceof FirValueParameterSymbol)) continue;
            return FirErrors.INSTANCE.getRETURN_NOT_ALLOWED();
        }
        return null;
    }

    private final KtDiagnosticFactory0 returnNotAllowedInExpressionBodyFactoryOrNull(CheckerContext context2, FirFunctionSymbol<?> targetSymbol, boolean edgeCase) {
        if (this.expressionBodyOrNull(targetSymbol) == null) {
            return null;
        }
        boolean allowWithExplicitType = LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.AllowReturnInExpressionBodyWithExplicitType);
        if ((allowWithExplicitType || edgeCase) && DeclarationUtilsKt.getHasExplicitReturnType((FirCallableSymbol)targetSymbol)) {
            return null;
        }
        boolean forbidEdgeCases = LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ForbidReturnInExpressionBodyWithoutExplicitTypeEdgeCases) && allowWithExplicitType;
        return forbidEdgeCases ? FirErrors.INSTANCE.getRETURN_IN_FUNCTION_WITH_EXPRESSION_BODY_AND_IMPLICIT_TYPE() : (allowWithExplicitType && edgeCase ? FirErrors.INSTANCE.getRETURN_IN_FUNCTION_WITH_EXPRESSION_BODY_WARNING() : (allowWithExplicitType && !edgeCase ? FirErrors.INSTANCE.getRETURN_IN_FUNCTION_WITH_EXPRESSION_BODY_AND_IMPLICIT_TYPE() : (edgeCase ? null : FirErrors.INSTANCE.getRETURN_IN_FUNCTION_WITH_EXPRESSION_BODY())));
    }

    private final FirSingleExpressionBlock expressionBodyOrNull(FirFunctionSymbol<?> $this$expressionBodyOrNull) {
        FirBlock firBlock = ((FirFunction)$this$expressionBodyOrNull.getFir()).getBody();
        return firBlock instanceof FirSingleExpressionBlock ? (FirSingleExpressionBlock)firBlock : null;
    }

    /*
     * Unable to fully structure code
     */
    private final void checkBuiltInSuspend(CheckerContext context, DiagnosticReporter reporter, FirFunctionSymbol<? extends FirFunction> targetSymbol, KtSourceElement source) {
        block10: {
            block8: {
                if (!(targetSymbol instanceof FirAnonymousFunctionSymbol) || ((v0 = (label = ((FirAnonymousFunctionSymbol)targetSymbol).getLabel())) != null && (v0 = v0.getSource()) != null ? v0.getKind() : null) instanceof KtRealSourceElementKind) break block10;
                var8_6 = CollectionsKt.asReversed(context.getCallsOrAssignments());
                for (T var10_9 : var8_6) {
                    it = (FirStatement)var10_9;
                    $i$a$-find-FirReturnSyntaxAndLabelChecker$checkBuiltInSuspend$functionCall$1 = false;
                    if (!(it instanceof FirFunctionCall)) ** GOTO lbl-1000
                    v1 = FirReferenceUtilsKt.toResolvedNamedFunctionSymbol$default(((FirFunctionCall)it).getCalleeReference(), false, 1, null);
                    if (Intrinsics.areEqual((Object)(v1 != null ? v1.getCallableId() : null), (Object)StandardClassIds.Callables.INSTANCE.getSuspend())) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (!v2) continue;
                    v3 = var10_9;
                    break block8;
                }
                v3 = null;
            }
            functionCall = v3;
            if (functionCall instanceof FirFunctionCall) {
                block9: {
                    $this$arguments$iv = (FirCall)functionCall;
                    $i$f$getArguments = false;
                    $this$any$iv = $this$arguments$iv.getArgumentList().getArguments();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v4 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (FirExpression)element$iv;
                            $i$a$-any-FirReturnSyntaxAndLabelChecker$checkBuiltInSuspend$1 = false;
                            if (!(it instanceof FirAnonymousFunctionExpression != false && Intrinsics.areEqual((Object)((FirAnonymousFunctionExpression)it).getAnonymousFunction().getSymbol(), targetSymbol) != false)) continue;
                            v4 = true;
                            break block9;
                        }
                        v4 = false;
                    }
                }
                if (v4) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getRETURN_FOR_BUILT_IN_SUSPEND(), null, 8, null);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DiagnosticKind.values().length];
            try {
                nArray[DiagnosticKind.NotAFunctionLabel.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DiagnosticKind.UnresolvedLabel.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

