/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import javajs.util.BS;
import org.jmol.modelset.Atom;
import org.jmol.quantum.MepCalculation;
import org.jmol.util.Logger;

public class MlpCalculation
extends MepCalculation {
    public MlpCalculation() {
        this.distanceMode = 3;
    }

    @Override
    public void assignPotentials(Atom[] atoms, float[] potentials, BS bsAromatic, BS bsCarbonyl, BS bsIgnore, String data) {
        this.getAtomicPotentials(data, "atomicLipophilicity.txt");
        for (int i = 0; i < atoms.length; ++i) {
            float f = Math.abs(atoms[i].getFormalCharge());
            if (f == 0.0f) {
                if (bsIgnore != null && bsIgnore.get(i)) {
                    f = Float.NaN;
                } else {
                    f = this.getTabulatedPotential(atoms[i]);
                    if (Float.isNaN(f)) {
                        switch (atoms[i].getElementNumber()) {
                            case 6: {
                                f = bsAromatic.get(i) ? 0.31f : (bsCarbonyl.get(i) ? -0.54f : 0.45f);
                                break;
                            }
                            case 7: {
                                f = bsAromatic.get(i) ? -0.6f : (bsCarbonyl.get(i) ? -0.44f : -1.0f);
                                break;
                            }
                            case 8: {
                                f = bsCarbonyl.get(i) ? -0.9f : -0.17f;
                                break;
                            }
                            default: {
                                f = Float.NaN;
                            }
                        }
                    }
                }
            }
            if (Logger.debugging) {
                Logger.debug(atoms[i].getInfo() + " " + f);
            }
            potentials[i] = f;
        }
    }
}

