/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.juife.Task;
import net.sf.juife.TaskQueue;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import net.sf.juife.event.TaskQueueEvent;
import net.sf.juife.event.TaskQueueListener;
import org.jsampler.DOMUtils;
import org.jsampler.DefaultOrchestraListModel;
import org.jsampler.DefaultSamplerChannelModel;
import org.jsampler.DefaultSamplerModel;
import org.jsampler.HF;
import org.jsampler.JSI18n;
import org.jsampler.JSPrefs;
import org.jsampler.LostFilesModel;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.OrchestraListModel;
import org.jsampler.OrchestraModel;
import org.jsampler.Prefs;
import org.jsampler.Resource;
import org.jsampler.SamplerChannelModel;
import org.jsampler.SamplerModel;
import org.jsampler.Server;
import org.jsampler.ServerList;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.jsampler.event.OrchestraEvent;
import org.jsampler.event.OrchestraListener;
import org.jsampler.task.Audio;
import org.jsampler.task.Channel;
import org.jsampler.task.EnhancedTask;
import org.jsampler.task.Global;
import org.jsampler.task.LaunchBackend;
import org.jsampler.task.Midi;
import org.jsampler.task.SetServerAddress;
import org.jsampler.task.UpdateChannels;
import org.jsampler.view.InstrumentsDbTreeModel;
import org.jsampler.view.JSMainFrame;
import org.jsampler.view.JSProgress;
import org.jsampler.view.JSViewConfig;
import org.linuxsampler.lscp.AudioOutputDriver;
import org.linuxsampler.lscp.Client;
import org.linuxsampler.lscp.FxSend;
import org.linuxsampler.lscp.MidiInputDriver;
import org.linuxsampler.lscp.SamplerEngine;
import org.linuxsampler.lscp.ServerInfo;
import org.linuxsampler.lscp.event.ChannelCountEvent;
import org.linuxsampler.lscp.event.ChannelCountListener;
import org.linuxsampler.lscp.event.ChannelInfoEvent;
import org.linuxsampler.lscp.event.ChannelInfoListener;
import org.linuxsampler.lscp.event.ChannelMidiDataEvent;
import org.linuxsampler.lscp.event.ChannelMidiDataListener;
import org.linuxsampler.lscp.event.FxSendCountEvent;
import org.linuxsampler.lscp.event.FxSendCountListener;
import org.linuxsampler.lscp.event.FxSendInfoEvent;
import org.linuxsampler.lscp.event.FxSendInfoListener;
import org.linuxsampler.lscp.event.GlobalInfoEvent;
import org.linuxsampler.lscp.event.GlobalInfoListener;
import org.linuxsampler.lscp.event.ItemCountEvent;
import org.linuxsampler.lscp.event.ItemCountListener;
import org.linuxsampler.lscp.event.ItemInfoEvent;
import org.linuxsampler.lscp.event.ItemInfoListener;
import org.linuxsampler.lscp.event.MidiInstrumentCountEvent;
import org.linuxsampler.lscp.event.MidiInstrumentCountListener;
import org.linuxsampler.lscp.event.MidiInstrumentInfoEvent;
import org.linuxsampler.lscp.event.MidiInstrumentInfoListener;
import org.linuxsampler.lscp.event.StreamCountEvent;
import org.linuxsampler.lscp.event.StreamCountListener;
import org.linuxsampler.lscp.event.TotalStreamCountEvent;
import org.linuxsampler.lscp.event.TotalStreamCountListener;
import org.linuxsampler.lscp.event.TotalVoiceCountEvent;
import org.linuxsampler.lscp.event.TotalVoiceCountListener;
import org.linuxsampler.lscp.event.VoiceCountEvent;
import org.linuxsampler.lscp.event.VoiceCountListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CC {
    private static Handler handler;
    private static FileOutputStream fos;
    private static JSViewConfig viewConfig;
    private static JSMainFrame mainFrame;
    private static JSProgress progress;
    private static final Client lsClient;
    private static String jSamplerHome;
    private static final TaskQueue taskQueue;
    private static final Timer timer;
    private static int connectionFailureCount;
    private static final OrchestraListModel orchestras;
    private static final ServerList servers;
    private static ServerListListener serverListListener;
    private static final Vector<ChangeListener> idtmListeners;
    private static InstrumentsDbTreeModel instrumentsDbTreeModel;
    private static final LostFilesModel lostFilesModel;
    private static final Vector<ActionListener> listeners;
    private static final Vector<ActionListener> ceListeners;
    private static final SamplerModel samplerModel;
    private static Server currentServer;
    private static final Vector<ActionListener> pListeners;
    private static Process backendProcess;
    private static final Object backendMonitor;
    private static final EventHandler eventHandler;
    private static final AudioDeviceCountListener audioDeviceCountListener;
    private static final AudioDeviceInfoListener audioDeviceInfoListener;
    private static final MidiDeviceCountListener midiDeviceCountListener;
    private static final MidiDeviceInfoListener midiDeviceInfoListener;
    private static final MidiInstrMapCountListener midiInstrMapCountListener;
    private static final MidiInstrMapInfoListener midiInstrMapInfoListener;

    private CC() {
    }

    public static Logger getLogger() {
        return Logger.getLogger("org.jsampler", "org.jsampler.langprops.LogsBundle");
    }

    public static synchronized TaskQueue getTaskQueue() {
        return taskQueue;
    }

    public static synchronized void scheduleTask(Task task) {
        while (CC.getTaskQueue().removeTask(task)) {
        }
        CC.getTaskQueue().add(task);
    }

    public static synchronized void addTask(Task task) {
        Task[] taskArray = CC.getTaskQueue().getPendingTasks();
        if (taskArray.length > 0 && taskArray[taskArray.length - 1].equals(task)) {
            return;
        }
        CC.getTaskQueue().add(task);
    }

    public static JSViewConfig getViewConfig() {
        return viewConfig;
    }

    public static JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    public static void setViewConfig(JSViewConfig jSViewConfig) {
        viewConfig = jSViewConfig;
    }

    public static JSMainFrame getMainFrame() {
        return mainFrame;
    }

    public static void setMainFrame(JSMainFrame jSMainFrame) {
        mainFrame = jSMainFrame;
    }

    public static JSProgress getProgressIndicator() {
        return progress;
    }

    public static void setProgressIndicator(JSProgress jSProgress) {
        progress = jSProgress;
    }

    public static String getJSamplerHome() {
        return jSamplerHome;
    }

    public static void setJSamplerHome(String string) {
        jSamplerHome = string;
        Prefs.setJSamplerHome(jSamplerHome);
    }

    protected static void initJSampler() {
        fos = null;
        CC.setJSamplerHome(Prefs.getJSamplerHome());
        String string = CC.getJSamplerHome();
        try {
            if (string != null) {
                File file = new File(string = string + File.separator + "jsampler.log");
                if (file.isFile()) {
                    HF.createBackup("jsampler.log", "jsampler.log.0");
                }
                fos = new FileOutputStream(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        handler = fos == null ? new StreamHandler(System.out, new SimpleFormatter()) : new StreamHandler(fos, new SimpleFormatter());
        handler.setLevel(Level.FINE);
        CC.getLogger().addHandler(handler);
        CC.getLogger().setLevel(Level.FINE);
        Logger.getLogger("org.linuxsampler.lscp").setLevel(Level.FINE);
        Logger.getLogger("org.linuxsampler.lscp").addHandler(handler);
        new java.util.Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                if (handler != null) {
                    handler.flush();
                }
            }
        }, 1000L, 1000L);
        CC.getLogger().fine("CC.jsStarted");
        HF.setUIDefaultFont(Prefs.getInterfaceFont());
        timer.setRepeats(false);
        timer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CC.getProgressIndicator().start();
            }
        });
        CC.getTaskQueue().addTaskQueueListener(CC.getHandler());
        CC.getTaskQueue().start();
        CC.getClient().removeChannelCountListener(CC.getHandler());
        CC.getClient().addChannelCountListener(CC.getHandler());
        CC.getClient().removeChannelInfoListener(CC.getHandler());
        CC.getClient().addChannelInfoListener(CC.getHandler());
        CC.getClient().removeFxSendCountListener(CC.getHandler());
        CC.getClient().addFxSendCountListener(CC.getHandler());
        CC.getClient().removeFxSendInfoListener(CC.getHandler());
        CC.getClient().addFxSendInfoListener(CC.getHandler());
        CC.getClient().removeStreamCountListener(CC.getHandler());
        CC.getClient().addStreamCountListener(CC.getHandler());
        CC.getClient().removeVoiceCountListener(CC.getHandler());
        CC.getClient().addVoiceCountListener(CC.getHandler());
        CC.getClient().removeTotalStreamCountListener(CC.getHandler());
        CC.getClient().addTotalStreamCountListener(CC.getHandler());
        CC.getClient().removeTotalVoiceCountListener(CC.getHandler());
        CC.getClient().addTotalVoiceCountListener(CC.getHandler());
        CC.getClient().removeAudioDeviceCountListener(audioDeviceCountListener);
        CC.getClient().addAudioDeviceCountListener(audioDeviceCountListener);
        CC.getClient().removeAudioDeviceInfoListener(audioDeviceInfoListener);
        CC.getClient().addAudioDeviceInfoListener(audioDeviceInfoListener);
        CC.getClient().removeMidiDeviceCountListener(midiDeviceCountListener);
        CC.getClient().addMidiDeviceCountListener(midiDeviceCountListener);
        CC.getClient().removeMidiDeviceInfoListener(midiDeviceInfoListener);
        CC.getClient().addMidiDeviceInfoListener(midiDeviceInfoListener);
        CC.getClient().removeMidiInstrumentMapCountListener(midiInstrMapCountListener);
        CC.getClient().addMidiInstrumentMapCountListener(midiInstrMapCountListener);
        CC.getClient().removeMidiInstrumentMapInfoListener(midiInstrMapInfoListener);
        CC.getClient().addMidiInstrumentMapInfoListener(midiInstrMapInfoListener);
        CC.getClient().removeMidiInstrumentCountListener(CC.getHandler());
        CC.getClient().addMidiInstrumentCountListener(CC.getHandler());
        CC.getClient().removeMidiInstrumentInfoListener(CC.getHandler());
        CC.getClient().addMidiInstrumentInfoListener(CC.getHandler());
        CC.getClient().removeGlobalInfoListener(CC.getHandler());
        CC.getClient().addGlobalInfoListener(CC.getHandler());
        CC.getClient().removeChannelMidiDataListener(CC.getHandler());
        CC.getClient().addChannelMidiDataListener(CC.getHandler());
        CC.addConnectionEstablishedListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                connectionFailureCount = 0;
            }
        });
    }

    public static OrchestraListModel getOrchestras() {
        return orchestras;
    }

    public static ServerList getServerList() {
        return servers;
    }

    public static InstrumentsDbTreeModel getInstrumentsDbTreeModel() {
        if (CC.getSamplerModel().getServerInfo() == null) {
            return null;
        }
        if (!CC.getSamplerModel().getServerInfo().hasInstrumentsDbSupport()) {
            return null;
        }
        if (instrumentsDbTreeModel == null) {
            instrumentsDbTreeModel = new InstrumentsDbTreeModel();
            for (ChangeListener changeListener : idtmListeners) {
                changeListener.stateChanged(null);
            }
        }
        return instrumentsDbTreeModel;
    }

    public static void addInstrumentsDbChangeListener(ChangeListener changeListener) {
        idtmListeners.add(changeListener);
    }

    public static void removeInstrumentsDbChangeListener(ChangeListener changeListener) {
        idtmListeners.remove(changeListener);
    }

    public static LostFilesModel getLostFilesModel() {
        return lostFilesModel;
    }

    public static void loadOrchestras() {
        if (CC.getJSamplerHome() == null) {
            return;
        }
        try {
            String string = CC.getJSamplerHome();
            File file = new File(string + File.separator + "orchestras.xml.bkp");
            if (file.isFile()) {
                HF.createBackup("orchestras.xml.bkp", "orchestras.xml.rec");
            }
            FileInputStream fileInputStream = new FileInputStream(string + File.separator + "orchestras.xml");
            CC.loadOrchestras(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
        }
        CC.getOrchestras().addOrchestraListListener(CC.getHandler());
    }

    private static void loadOrchestras(InputStream inputStream) {
        Document document = DOMUtils.readObject(inputStream);
        try {
            CC.getOrchestras().readObject(document.getDocumentElement());
        }
        catch (Exception exception) {
            HF.showErrorMessage(exception, "Loading orchestras: ");
            return;
        }
        for (int i = 0; i < CC.getOrchestras().getOrchestraCount(); ++i) {
            CC.getOrchestras().getOrchestra(i).addOrchestraListener(CC.getHandler());
        }
    }

    private static void saveOrchestras() {
        try {
            String string = CC.getJSamplerHome();
            if (string == null) {
                return;
            }
            HF.createBackup("orchestras.xml", "orchestras.xml.bkp");
            FileOutputStream fileOutputStream = new FileOutputStream(string + File.separator + "orchestras.xml", false);
            Document document = DOMUtils.createEmptyDocument();
            Element element = document.createElement("temp");
            document.appendChild(element);
            CC.getOrchestras().writeObject(document, document.getDocumentElement());
            document.replaceChild(element.getFirstChild(), element);
            DOMUtils.writeObject(document, fileOutputStream);
            fileOutputStream.close();
            HF.deleteFile("orchestras.xml.bkp");
        }
        catch (Exception exception) {
            HF.showErrorMessage(exception, "Saving orchestras: ");
            return;
        }
    }

    public static void loadServerList() {
        Object object;
        if (CC.getJSamplerHome() == null) {
            return;
        }
        try {
            object = CC.getJSamplerHome();
            File file = new File((String)object + File.separator + "servers.xml.bkp");
            if (file.isFile()) {
                HF.createBackup("servers.xml.bkp", "servers.xml.rec");
            }
            FileInputStream fileInputStream = new FileInputStream((String)object + File.separator + "servers.xml");
            CC.loadServerList(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
        }
        CC.getServerList().addChangeListener(serverListListener);
        if (CC.getServerList().getServerCount() == 0) {
            object = new Server();
            ((Resource)object).setName("127.0.0.1:8888");
            ((Server)object).setAddress("127.0.0.1");
            ((Server)object).setPort(8888);
            CC.getServerList().addServer((Server)object);
        }
    }

    private static void loadServerList(InputStream inputStream) {
        Document document = DOMUtils.readObject(inputStream);
        try {
            CC.getServerList().readObject(document.getDocumentElement());
        }
        catch (Exception exception) {
            HF.showErrorMessage(exception, "Loading server list: ");
            return;
        }
    }

    private static void saveServerList() {
        try {
            String string = CC.getJSamplerHome();
            if (string == null) {
                return;
            }
            HF.createBackup("servers.xml", "servers.xml.bkp");
            FileOutputStream fileOutputStream = new FileOutputStream(string + File.separator + "servers.xml", false);
            Document document = DOMUtils.createEmptyDocument();
            Element element = document.createElement("temp");
            document.appendChild(element);
            CC.getServerList().writeObject(document, document.getDocumentElement());
            document.replaceChild(element.getFirstChild(), element);
            DOMUtils.writeObject(document, fileOutputStream);
            fileOutputStream.close();
            HF.deleteFile("servers.xml.bkp");
        }
        catch (Exception exception) {
            HF.showErrorMessage(exception, "Saving server list: ");
            return;
        }
    }

    public static void cleanExit() {
        CC.cleanExit(0);
    }

    public static void cleanExit(int n) {
        CC.getLogger().fine("CC.jsEnded");
        try {
            CC.getClient().disconnect();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (backendProcess != null) {
            backendProcess.destroy();
        }
        backendProcess = null;
        CC.fireBackendProcessEvent();
        System.exit(n);
    }

    public static Client getClient() {
        return lsClient;
    }

    public static void addReconnectListener(ActionListener actionListener) {
        listeners.add(actionListener);
    }

    public static void removeReconnectListener(ActionListener actionListener) {
        listeners.remove(actionListener);
    }

    private static void fireReconnectEvent() {
        ActionEvent actionEvent = new ActionEvent(CC.class, 1001, null);
        for (ActionListener actionListener : listeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public static void addConnectionEstablishedListener(ActionListener actionListener) {
        ceListeners.add(actionListener);
    }

    public static void removeConnectionEstablishedListener(ActionListener actionListener) {
        ceListeners.remove(actionListener);
    }

    private static void fireConnectionEstablishedEvent() {
        ActionEvent actionEvent = new ActionEvent(CC.class, 1001, null);
        for (ActionListener actionListener : ceListeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public static SamplerModel getSamplerModel() {
        return samplerModel;
    }

    public static void connect() {
        CC.initSamplerModel();
    }

    public static void reconnect() {
        CC.initSamplerModel(CC.getCurrentServer());
    }

    public static Server getCurrentServer() {
        return currentServer;
    }

    public static void setCurrentServer(Server server) {
        if (server == currentServer) {
            return;
        }
        connectionFailureCount = 0;
        currentServer = server;
    }

    public static void setClientReadTimeout(int n) {
        CC.getTaskQueue().add(new Global.SetClientReadTimeout(n));
    }

    private static void initSamplerModel() {
        Server server = CC.getMainFrame().getServer();
        if (server == null) {
            return;
        }
        CC.initSamplerModel(server);
    }

    private static void initSamplerModel(Server server) {
        CC.setCurrentServer(server);
        SetServerAddress setServerAddress = new SetServerAddress(server.getAddress(), server.getPort());
        final DefaultSamplerModel defaultSamplerModel = (DefaultSamplerModel)CC.getSamplerModel();
        final Global.GetServerInfo getServerInfo = new Global.GetServerInfo();
        getServerInfo.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (getServerInfo.doneWithErrors()) {
                    return;
                }
                defaultSamplerModel.setServerInfo((ServerInfo)getServerInfo.getResult());
                if (CC.getViewConfig().getInstrumentsDbSupport()) {
                    CC.getInstrumentsDbTreeModel();
                }
            }
        });
        final Audio.GetDrivers getDrivers = new Audio.GetDrivers();
        getDrivers.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (!getDrivers.doneWithErrors()) {
                    defaultSamplerModel.setAudioOutputDrivers((AudioOutputDriver[])getDrivers.getResult());
                }
            }
        });
        final Global.GetEngines getEngines = new Global.GetEngines();
        getEngines.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (!getEngines.doneWithErrors()) {
                    defaultSamplerModel.setEngines((SamplerEngine[])getEngines.getResult());
                }
            }
        });
        final Midi.GetDrivers getDrivers2 = new Midi.GetDrivers();
        getDrivers2.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (!getDrivers2.doneWithErrors()) {
                    defaultSamplerModel.setMidiInputDrivers((MidiInputDriver[])getDrivers2.getResult());
                }
            }
        });
        final Global.GetVolume getVolume = new Global.GetVolume();
        getVolume.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (!getVolume.doneWithErrors()) {
                    defaultSamplerModel.setVolume(((Float)getVolume.getResult()).floatValue());
                }
            }
        });
        final Midi.GetInstrumentMaps getInstrumentMaps = new Midi.GetInstrumentMaps();
        getInstrumentMaps.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (getInstrumentMaps.doneWithErrors()) {
                    return;
                }
                defaultSamplerModel.removeAllMidiInstrumentMaps();
                for (MidiInstrumentMap midiInstrumentMap : (MidiInstrumentMap[])getInstrumentMaps.getResult()) {
                    defaultSamplerModel.addMidiInstrumentMap(midiInstrumentMap);
                }
            }
        });
        final UpdateChannels updateChannels = new UpdateChannels();
        updateChannels.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                for (SamplerChannelModel samplerChannelModel : defaultSamplerModel.getChannels()) {
                    if (samplerChannelModel.getChannelInfo().getEngine() == null) continue;
                    Channel.GetFxSends getFxSends = new Channel.GetFxSends();
                    getFxSends.setChannel(samplerChannelModel.getChannelId());
                    getFxSends.addTaskListener(new GetFxSendsListener());
                    CC.getTaskQueue().add(getFxSends);
                }
            }
        });
        final Global.Connect connect = new Global.Connect();
        boolean bl = CC.preferences().getBoolProperty("launchBackednLocally");
        if (bl && server.isLocal() && backendProcess == null) {
            connect.setSilent(true);
        }
        connect.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (connect.doneWithErrors()) {
                    CC.onConnectFailure();
                    return;
                }
                CC.getTaskQueue().add(getServerInfo);
                CC.getTaskQueue().add(getDrivers);
                CC.getTaskQueue().add(getDrivers2);
                CC.getTaskQueue().add(getEngines);
                CC.getTaskQueue().add(getVolume);
                CC.getTaskQueue().add(getInstrumentMaps);
                CC.getTaskQueue().add(new Midi.UpdateDevices());
                CC.getTaskQueue().add(new Audio.UpdateDevices());
                CC.addTask(updateChannels);
                int n = CC.preferences().getIntProperty("globalVoiceLimit");
                int n2 = CC.preferences().getIntProperty("globalStreamLimit");
                CC.getTaskQueue().add(new Global.SetPolyphony(n, n2));
                CC.fireConnectionEstablishedEvent();
            }
        });
        setServerAddress.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                int n = CC.preferences().getIntProperty("socketReadTimeout");
                CC.setClientReadTimeout(n * 1000);
                CC.getTaskQueue().add(connect);
            }
        });
        CC.getSamplerModel().reset();
        if (instrumentsDbTreeModel != null) {
            instrumentsDbTreeModel.reset();
            instrumentsDbTreeModel = null;
        }
        CC.getTaskQueue().removePendingTasks();
        CC.getTaskQueue().add(setServerAddress);
        CC.fireReconnectEvent();
    }

    private static void onConnectFailure() {
        if (++connectionFailureCount > 50) {
            CC.getLogger().warning("Reached maximum number of connection failures");
            return;
        }
        try {
            if (CC.launchBackend()) {
                int n = CC.preferences().getIntProperty("backendLaunchDelay");
                if (n < 1) {
                    CC.initSamplerModel(CC.getCurrentServer());
                    return;
                }
                LaunchBackend launchBackend = new LaunchBackend(n, CC.getBackendMonitor());
                new Thread(launchBackend).start();
                return;
            }
        }
        catch (Exception exception) {
            final String string = JSI18n.i18n.getError("CC.failedToLaunchBackend");
            CC.getLogger().log(Level.INFO, string, exception);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HF.showErrorMessage(string);
                }
            });
            return;
        }
        CC.retryToConnect();
    }

    private static void retryToConnect() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CC.changeBackend();
            }
        });
    }

    public static void changeBackend() {
        Server server = CC.getMainFrame().getServer(true);
        if (server != null) {
            connectionFailureCount = 0;
            CC.initSamplerModel(server);
        }
    }

    public static void addBackendProcessListener(ActionListener actionListener) {
        pListeners.add(actionListener);
    }

    public static void removeBackendProcessListener(ActionListener actionListener) {
        pListeners.remove(actionListener);
    }

    private static void fireBackendProcessEvent() {
        ActionEvent actionEvent = new ActionEvent(CC.class, 1001, null);
        for (ActionListener actionListener : pListeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public static Process getBackendProcess() {
        return backendProcess;
    }

    public static Object getBackendMonitor() {
        return backendMonitor;
    }

    private static boolean launchBackend() throws Exception {
        if (backendProcess != null) {
            try {
                int n = backendProcess.exitValue();
                CC.getLogger().info("Backend exited with exit value " + n);
                backendProcess = null;
                CC.fireBackendProcessEvent();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return false;
            }
        }
        if (!CC.preferences().getBoolProperty("launchBackednLocally")) {
            return false;
        }
        if (connectionFailureCount > 1) {
            return false;
        }
        Server server = CC.getCurrentServer();
        if (server != null && server.isLocal()) {
            String string = CC.preferences().getStringProperty("backendLaunchCommand");
            backendProcess = Runtime.getRuntime().exec(string);
            CC.fireBackendProcessEvent();
            return true;
        }
        return false;
    }

    public static void scheduleInTaskQueue(final Runnable runnable) {
        Global.DummyTask dummyTask = new Global.DummyTask();
        dummyTask.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                SwingUtilities.invokeLater(runnable);
            }
        });
        CC.getTaskQueue().add(dummyTask);
    }

    public static boolean verifyConnection() {
        if (CC.getCurrentServer() == null) {
            HF.showErrorMessage(JSI18n.i18n.getError("CC.notConnected"));
            return false;
        }
        return true;
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac os x");
    }

    private static EventHandler getHandler() {
        return eventHandler;
    }

    private static void fireChannelMidiDataEvent(ChannelMidiDataEvent channelMidiDataEvent) {
        SamplerChannelModel samplerChannelModel = CC.getSamplerModel().getChannelById(channelMidiDataEvent.getChannelId());
        if (samplerChannelModel == null) {
            CC.getLogger().info("Unknown channel ID: " + channelMidiDataEvent.getChannelId());
        }
        ((DefaultSamplerChannelModel)samplerChannelModel).fireMidiDataEvent(channelMidiDataEvent);
    }

    static {
        viewConfig = null;
        mainFrame = null;
        progress = null;
        lsClient = new Client();
        jSamplerHome = null;
        taskQueue = new TaskQueue();
        timer = new Timer(2000, null);
        connectionFailureCount = 0;
        orchestras = new DefaultOrchestraListModel();
        servers = new ServerList();
        serverListListener = new ServerListListener();
        idtmListeners = new Vector();
        instrumentsDbTreeModel = null;
        lostFilesModel = new LostFilesModel();
        listeners = new Vector();
        ceListeners = new Vector();
        samplerModel = new DefaultSamplerModel();
        currentServer = null;
        pListeners = new Vector();
        backendProcess = null;
        backendMonitor = new Object();
        eventHandler = new EventHandler();
        audioDeviceCountListener = new AudioDeviceCountListener();
        audioDeviceInfoListener = new AudioDeviceInfoListener();
        midiDeviceCountListener = new MidiDeviceCountListener();
        midiDeviceInfoListener = new MidiDeviceInfoListener();
        midiInstrMapCountListener = new MidiInstrMapCountListener();
        midiInstrMapInfoListener = new MidiInstrMapInfoListener();
    }

    private static class MidiInstrMapInfoListener
    implements ItemInfoListener {
        private MidiInstrMapInfoListener() {
        }

        @Override
        public void itemInfoChanged(ItemInfoEvent itemInfoEvent) {
            CC.getTaskQueue().add(new Midi.UpdateInstrumentMapInfo(itemInfoEvent.getItemID()));
        }
    }

    private static class MidiInstrMapCountListener
    implements ItemCountListener {
        private MidiInstrMapCountListener() {
        }

        @Override
        public void itemCountChanged(ItemCountEvent itemCountEvent) {
            CC.getTaskQueue().add(new Midi.UpdateInstrumentMaps());
        }
    }

    private static class MidiDeviceInfoListener
    implements ItemInfoListener {
        private MidiDeviceInfoListener() {
        }

        @Override
        public void itemInfoChanged(ItemInfoEvent itemInfoEvent) {
            CC.getTaskQueue().add(new Midi.UpdateDeviceInfo(itemInfoEvent.getItemID()));
        }
    }

    private static class MidiDeviceCountListener
    implements ItemCountListener {
        private MidiDeviceCountListener() {
        }

        @Override
        public void itemCountChanged(ItemCountEvent itemCountEvent) {
            CC.getTaskQueue().add(new Midi.UpdateDevices());
        }
    }

    private static class AudioDeviceInfoListener
    implements ItemInfoListener {
        private AudioDeviceInfoListener() {
        }

        @Override
        public void itemInfoChanged(ItemInfoEvent itemInfoEvent) {
            CC.getTaskQueue().add(new Audio.UpdateDeviceInfo(itemInfoEvent.getItemID()));
        }
    }

    private static class AudioDeviceCountListener
    implements ItemCountListener {
        private AudioDeviceCountListener() {
        }

        @Override
        public void itemCountChanged(ItemCountEvent itemCountEvent) {
            CC.getTaskQueue().add(new Audio.UpdateDevices());
        }
    }

    private static class EventHandler
    implements ChannelCountListener,
    ChannelInfoListener,
    FxSendCountListener,
    FxSendInfoListener,
    StreamCountListener,
    VoiceCountListener,
    TotalStreamCountListener,
    TotalVoiceCountListener,
    TaskQueueListener,
    OrchestraListener,
    ListListener<OrchestraModel>,
    MidiInstrumentCountListener,
    MidiInstrumentInfoListener,
    GlobalInfoListener,
    ChannelMidiDataListener {
        private EventHandler() {
        }

        @Override
        public void channelCountChanged(ChannelCountEvent channelCountEvent) {
            if (channelCountEvent.getChannelCount() == 0) {
                CC.getSamplerModel().removeAllChannels();
                return;
            }
            CC.addTask(new UpdateChannels());
        }

        @Override
        public void channelInfoChanged(ChannelInfoEvent channelInfoEvent) {
            Task task;
            Task task2;
            boolean bl = true;
            Task[] taskArray = CC.getTaskQueue().getPendingTasks();
            for (int i = taskArray.length - 1; i >= 0; --i) {
                task2 = taskArray[i];
                if (task2 instanceof Channel.UpdateInfo) {
                    Channel.UpdateInfo updateInfo = (Channel.UpdateInfo)task2;
                    if (updateInfo.getChannelId() != channelInfoEvent.getSamplerChannel()) continue;
                    return;
                }
                bl = false;
                break;
            }
            if (bl && (task = CC.getTaskQueue().getRunningTask()) instanceof Channel.UpdateInfo && ((Channel.UpdateInfo)(task2 = (Channel.UpdateInfo)task)).getChannelId() == channelInfoEvent.getSamplerChannel()) {
                return;
            }
            CC.getTaskQueue().add(new Channel.UpdateInfo(channelInfoEvent.getSamplerChannel()));
        }

        @Override
        public void fxSendCountChanged(FxSendCountEvent fxSendCountEvent) {
            CC.getTaskQueue().add(new Channel.UpdateFxSends(fxSendCountEvent.getChannel()));
        }

        @Override
        public void fxSendInfoChanged(FxSendInfoEvent fxSendInfoEvent) {
            Channel.UpdateFxSendInfo updateFxSendInfo = new Channel.UpdateFxSendInfo(fxSendInfoEvent.getChannel(), fxSendInfoEvent.getFxSend());
            CC.getTaskQueue().add(updateFxSendInfo);
        }

        @Override
        public void streamCountChanged(StreamCountEvent streamCountEvent) {
            SamplerChannelModel samplerChannelModel = CC.getSamplerModel().getChannelById(streamCountEvent.getSamplerChannel());
            if (samplerChannelModel == null) {
                CC.getLogger().log(Level.WARNING, "CC.unknownChannel!", streamCountEvent.getSamplerChannel());
                return;
            }
            samplerChannelModel.setStreamCount(streamCountEvent.getStreamCount());
        }

        @Override
        public void voiceCountChanged(VoiceCountEvent voiceCountEvent) {
            SamplerChannelModel samplerChannelModel = CC.getSamplerModel().getChannelById(voiceCountEvent.getSamplerChannel());
            if (samplerChannelModel == null) {
                CC.getLogger().log(Level.WARNING, "CC.unknownChannel!", voiceCountEvent.getSamplerChannel());
                return;
            }
            samplerChannelModel.setVoiceCount(voiceCountEvent.getVoiceCount());
        }

        @Override
        public void totalStreamCountChanged(TotalStreamCountEvent totalStreamCountEvent) {
            CC.getSamplerModel().updateActiveStreamsInfo(totalStreamCountEvent.getTotalStreamCount());
        }

        @Override
        public void totalVoiceCountChanged(TotalVoiceCountEvent totalVoiceCountEvent) {
            CC.scheduleTask(new Global.UpdateTotalVoiceCount());
        }

        @Override
        public void instrumentCountChanged(MidiInstrumentCountEvent midiInstrumentCountEvent) {
            CC.scheduleTask(new Midi.UpdateInstruments(midiInstrumentCountEvent.getMapId()));
        }

        @Override
        public void instrumentInfoChanged(MidiInstrumentInfoEvent midiInstrumentInfoEvent) {
            Midi.UpdateInstrumentInfo updateInstrumentInfo = new Midi.UpdateInstrumentInfo(midiInstrumentInfoEvent.getMapId(), midiInstrumentInfoEvent.getMidiBank(), midiInstrumentInfoEvent.getMidiProgram());
            CC.getTaskQueue().add(updateInstrumentInfo);
        }

        @Override
        public void volumeChanged(GlobalInfoEvent globalInfoEvent) {
            CC.getSamplerModel().setVolume(globalInfoEvent.getVolume());
        }

        @Override
        public void voiceLimitChanged(GlobalInfoEvent globalInfoEvent) {
        }

        @Override
        public void streamLimitChanged(GlobalInfoEvent globalInfoEvent) {
        }

        @Override
        public void stateChanged(TaskQueueEvent taskQueueEvent) {
            switch (taskQueueEvent.getEventID()) {
                case TASK_FETCHED: {
                    CC.getProgressIndicator().setString(((Task)taskQueueEvent.getSource()).getDescription());
                    break;
                }
                case TASK_DONE: {
                    EnhancedTask enhancedTask = (EnhancedTask)taskQueueEvent.getSource();
                    if (!enhancedTask.doneWithErrors() || enhancedTask.isSilent()) break;
                    if (enhancedTask.getErrorCode() == 1) {
                        CC.getMainFrame().handleConnectionFailure();
                        break;
                    }
                    if (enhancedTask.isStopped()) break;
                    this.showError(enhancedTask);
                    break;
                }
                case NOT_IDLE: {
                    timer.start();
                    break;
                }
                case IDLE: {
                    timer.stop();
                    CC.getProgressIndicator().stop();
                }
            }
        }

        private void showError(final Task task) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (task.getErrorDetails() == null) {
                        HF.showErrorMessage(task.getErrorMessage());
                    } else {
                        CC.getMainFrame().showDetailedErrorMessage(CC.getMainFrame(), task.getErrorMessage(), task.getErrorDetails());
                    }
                }
            });
        }

        @Override
        public void nameChanged(OrchestraEvent orchestraEvent) {
            CC.saveOrchestras();
        }

        @Override
        public void descriptionChanged(OrchestraEvent orchestraEvent) {
            CC.saveOrchestras();
        }

        @Override
        public void instrumentAdded(OrchestraEvent orchestraEvent) {
            CC.saveOrchestras();
        }

        @Override
        public void instrumentRemoved(OrchestraEvent orchestraEvent) {
            CC.saveOrchestras();
        }

        @Override
        public void instrumentChanged(OrchestraEvent orchestraEvent) {
            CC.saveOrchestras();
        }

        @Override
        public void entryAdded(ListEvent<OrchestraModel> listEvent) {
            listEvent.getEntry().addOrchestraListener(CC.getHandler());
            CC.saveOrchestras();
        }

        @Override
        public void entryRemoved(ListEvent<OrchestraModel> listEvent) {
            listEvent.getEntry().removeOrchestraListener(CC.getHandler());
            CC.saveOrchestras();
        }

        @Override
        public void midiDataArrived(final ChannelMidiDataEvent channelMidiDataEvent) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        CC.fireChannelMidiDataEvent(channelMidiDataEvent);
                    }
                });
            }
            catch (Exception exception) {
                CC.getLogger().log(Level.INFO, "Failed!", exception);
            }
        }
    }

    private static class GetFxSendsListener
    implements TaskListener {
        private GetFxSendsListener() {
        }

        @Override
        public void taskPerformed(TaskEvent taskEvent) {
            Channel.GetFxSends getFxSends = (Channel.GetFxSends)taskEvent.getSource();
            if (getFxSends.doneWithErrors()) {
                return;
            }
            SamplerChannelModel samplerChannelModel = CC.getSamplerModel().getChannelById(getFxSends.getChannel());
            samplerChannelModel.removeAllFxSends();
            for (FxSend fxSend : (FxSend[])getFxSends.getResult()) {
                samplerChannelModel.addFxSend(fxSend);
            }
        }
    }

    private static class ServerListListener
    implements ChangeListener {
        private ServerListListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            CC.saveServerList();
        }
    }
}

