
#ifndef BALOO_WIDGETS_EXPORT_H
#define BALOO_WIDGETS_EXPORT_H

#ifdef BALOO_WIDGETS_STATIC_DEFINE
#  define BALOO_WIDGETS_EXPORT
#  define BALOO_WIDGETS_NO_EXPORT
#else
#  ifndef BALOO_WIDGETS_EXPORT
#    ifdef KF6BalooWidgets_EXPORTS
        /* We are building this library */
#      define BALOO_WIDGETS_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define BALOO_WIDGETS_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef BALOO_WIDGETS_NO_EXPORT
#    define BALOO_WIDGETS_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef BALOO_WIDGETS_DECL_DEPRECATED
#  define BALOO_WIDGETS_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef BALOO_WIDGETS_DECL_DEPRECATED_EXPORT
#  define BALOO_WIDGETS_DECL_DEPRECATED_EXPORT BALOO_WIDGETS_EXPORT BALOO_WIDGETS_DECL_DEPRECATED
#endif

#ifndef BALOO_WIDGETS_DECL_DEPRECATED_NO_EXPORT
#  define BALOO_WIDGETS_DECL_DEPRECATED_NO_EXPORT BALOO_WIDGETS_NO_EXPORT BALOO_WIDGETS_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef BALOO_WIDGETS_NO_DEPRECATED
#    define BALOO_WIDGETS_NO_DEPRECATED
#  endif
#endif

#define BALOO_WIDGETS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(BALOO_WIDGETS_NO_DEPRECATED)
#  undef BALOO_WIDGETS_DEPRECATED
#  define BALOO_WIDGETS_DEPRECATED_EXPORT BALOO_WIDGETS_EXPORT
#  define BALOO_WIDGETS_DEPRECATED_NO_EXPORT BALOO_WIDGETS_NO_EXPORT
#elif defined(BALOO_WIDGETS_NO_DEPRECATED_WARNINGS)
#  define BALOO_WIDGETS_DEPRECATED
#  define BALOO_WIDGETS_DEPRECATED_EXPORT BALOO_WIDGETS_EXPORT
#  define BALOO_WIDGETS_DEPRECATED_NO_EXPORT BALOO_WIDGETS_NO_EXPORT
#else
#  define BALOO_WIDGETS_DEPRECATED BALOO_WIDGETS_DECL_DEPRECATED
#  define BALOO_WIDGETS_DEPRECATED_EXPORT BALOO_WIDGETS_DECL_DEPRECATED_EXPORT
#  define BALOO_WIDGETS_DEPRECATED_NO_EXPORT BALOO_WIDGETS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define BALOO_WIDGETS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define BALOO_WIDGETS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef BALOO_WIDGETS_NO_DEPRECATED
#  define BALOO_WIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x190b50
#endif
#ifdef BALOO_WIDGETS_NO_DEPRECATED_WARNINGS
#  define BALOO_WIDGETS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef BALOO_WIDGETS_DEPRECATED_WARNINGS_SINCE
#  ifdef BALOO_WIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define BALOO_WIDGETS_DEPRECATED_WARNINGS_SINCE BALOO_WIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define BALOO_WIDGETS_DEPRECATED_WARNINGS_SINCE 0x190b50
#  endif
#endif

#ifndef BALOO_WIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define BALOO_WIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef BALOO_WIDGETS_DEPRECATED
#  define BALOO_WIDGETS_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > BALOO_WIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define BALOO_WIDGETS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if BALOO_WIDGETS_DEPRECATED_WARNINGS_SINCE >= 0x170800
#  define BALOO_WIDGETS_DEPRECATED_VERSION_23_08(text) BALOO_WIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define BALOO_WIDGETS_DEPRECATED_VERSION_23_08(text)
#endif
#define BALOO_WIDGETS_DEPRECATED_VERSION_23(minor, text)      BALOO_WIDGETS_DEPRECATED_VERSION_23_##minor(text)
#define BALOO_WIDGETS_DEPRECATED_VERSION(major, minor, text) BALOO_WIDGETS_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define BALOO_WIDGETS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) BALOO_WIDGETS_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define BALOO_WIDGETS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) BALOO_WIDGETS_DEPRECATED_VERSION(major, minor, text)
#  define BALOO_WIDGETS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) BALOO_WIDGETS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define BALOO_WIDGETS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define BALOO_WIDGETS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* BALOO_WIDGETS_EXPORT_H */
