# SPDX-FileCopyrightText: Copyright (c) 2023-2024 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
# SPDX-License-Identifier: LicenseRef-NvidiaProprietary
#
# NVIDIA CORPORATION, its affiliates and licensors retain all intellectual
# property and proprietary rights in and to this material, related
# documentation and any modifications thereto. Any use, reproduction,
# disclosure or distribution of this material and related documentation
# without an express license agreement from NVIDIA CORPORATION or
# its affiliates is strictly prohibited.


class RecipeException(Exception):
    """A base Exception class for all Recipe exceptions to inherit from."""

    def __init__(self, message=""):
        self._message = message.rstrip()
        super().__init__(self._message)


class ModeModuleNotFoundError(RecipeException):
    pass


class StatsModuleNotFoundError(RecipeException):
    pass


class StatsInternalError(RecipeException):
    pass


class NoDataError(RecipeException):
    pass


class ValueError(RecipeException):
    pass
