/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceInfo;
import org.jkiss.utils.CommonUtils;

class PostgreDataSourceInfo
extends JDBCDataSourceInfo {
    private final PostgreDataSource dataSource;

    public PostgreDataSourceInfo(PostgreDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super(metaData);
        this.dataSource = dataSource;
    }

    public String getDatabaseProductVersion() {
        String serverVersion = this.dataSource.getServerVersion();
        return CommonUtils.isEmpty((String)serverVersion) ? super.getDatabaseProductVersion() : super.getDatabaseProductVersion() + "\n" + serverVersion;
    }

    public boolean supportsMultipleResults() {
        return true;
    }

    public boolean needsTableMetaForColumnResolution() {
        return this.dataSource.getServerType().supportsEntityMetadataInResults();
    }

    public boolean supportsResultSetLimit() {
        return this.dataSource.getServerType().supportsResultSetLimits();
    }

    public boolean supportsTransactions() {
        return this.dataSource.getServerType().supportsTransactions();
    }

    protected boolean isIgnoreReadOnlyFlag() {
        return true;
    }
}

