/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.cli;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.cli.ApplicationInstanceController;
import org.jkiss.dbeaver.model.cli.CliException;
import org.jkiss.dbeaver.model.cli.CliProcessResult;
import org.jkiss.dbeaver.model.cli.CommandLineContext;
import org.jkiss.dbeaver.model.cli.registry.CommandLineParameterDescriptor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class ApplicationCommandLine<T extends ApplicationInstanceController> {
    private static final Log log;
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.commandLine";
    public static final String PARAM_HELP = "help";
    public static final String PARAM_THREAD_DUMP = "dump";
    public static final String PARAM_DB_LIST = "databaseList";
    private static final String PARAM_VERSION = "version";
    private static final Gson gson;
    public static final Options ALL_OPTIONS;
    protected static final Map<String, CommandLineParameterDescriptor> customParameters;

    static {
        IConfigurationElement[] extElements;
        log = Log.getLog(ApplicationCommandLine.class);
        gson = new GsonBuilder().setPrettyPrinting().create();
        ALL_OPTIONS = new Options().addOption(PARAM_HELP, PARAM_HELP, false, "Help").addOption(PARAM_DB_LIST, "database-driver-list", true, "Show list of supported database drivers in json format").addOption(PARAM_THREAD_DUMP, "thread-dump", false, "Print instance thread dump").addOption(PARAM_VERSION, PARAM_VERSION, false, "Displays the app name, edition, and version in Major.Minor.Micro.Timestamp format");
        customParameters = new LinkedHashMap<String, CommandLineParameterDescriptor>();
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extElements = er.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("parameter".equals(ext.getName())) {
                try {
                    CommandLineParameterDescriptor parameter = new CommandLineParameterDescriptor(ext);
                    customParameters.put(parameter.getName(), parameter);
                }
                catch (Exception e) {
                    log.error((Object)"Can't load contributed parameter", (Throwable)e);
                }
            }
            ++n2;
        }
        for (CommandLineParameterDescriptor param : customParameters.values()) {
            ALL_OPTIONS.addOption(param.getName(), param.getLongName(), param.hasArg(), param.getDescription());
        }
    }

    protected ApplicationCommandLine() {
    }

    /*
     * Loose catch block
     */
    public CliProcessResult executeCommandLineCommands(@Nullable CommandLine commandLine, @Nullable T controller, boolean uiActivated) throws Exception {
        if (commandLine == null || ArrayUtils.isEmpty((Object[])commandLine.getArgs()) && ArrayUtils.isEmpty((Object[])commandLine.getOptions())) {
            return new CliProcessResult(CliProcessResult.PostAction.START_INSTANCE);
        }
        for (CommandLineParameterDescriptor param : customParameters.values()) {
            if (!param.isExclusiveMode() || !commandLine.hasOption(param.getName()) && !commandLine.hasOption(param.getLongName())) continue;
            if (!param.isForceNewInstance()) break;
            return new CliProcessResult(CliProcessResult.PostAction.START_INSTANCE);
        }
        if (commandLine.hasOption(PARAM_HELP)) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.setWidth(120);
            helpFormatter.setOptionComparator((o1, o2) -> 0);
            helpFormatter.printHelp("dbeaver", GeneralUtils.getProductTitle(), ALL_OPTIONS, "(C) 2010-2025 DBeaver Corp", true);
            try {
                Object object = null;
                Object var6_8 = null;
                try {
                    CliProcessResult cliProcessResult;
                    PrintWriter print;
                    StringWriter out;
                    block24: {
                        out = new StringWriter();
                        print = new PrintWriter(out);
                        helpFormatter.printHelp(print, 100, "dbeaver", GeneralUtils.getProductTitle(), ALL_OPTIONS, 4, 4, "(C) 2010-2025 DBeaver Corp", true);
                        cliProcessResult = new CliProcessResult(CliProcessResult.PostAction.SHUTDOWN, out.toString());
                        if (print != null) {
                            print.close();
                        }
                        if (out == null) break block24;
                        out.close();
                    }
                    return cliProcessResult;
                    {
                        catch (Throwable throwable) {
                            try {
                                if (print != null) {
                                    print.close();
                                }
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                if (object == null) {
                                    object = throwable2;
                                } else if (object != throwable2) {
                                    ((Throwable)object).addSuppressed(throwable2);
                                }
                                if (out != null) {
                                    out.close();
                                }
                                throw object;
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            catch (Exception e) {
                log.error((Object)("Error handling command line: " + e.getMessage()));
                return new CliProcessResult(CliProcessResult.PostAction.ERROR, e.getMessage());
            }
        }
        if (commandLine.hasOption(PARAM_VERSION)) {
            String version = GeneralUtils.getLongProductTitle();
            System.out.println(version);
            return new CliProcessResult(CliProcessResult.PostAction.SHUTDOWN, version);
        }
        if (!uiActivated && commandLine.hasOption(PARAM_THREAD_DUMP)) {
            if (controller == null) {
                log.debug((Object)"Can't process commands because no running instance is present");
                return new CliProcessResult(CliProcessResult.PostAction.START_INSTANCE);
            }
            String threadDump = controller.getThreadDump();
            System.out.println(threadDump);
            return new CliProcessResult(CliProcessResult.PostAction.SHUTDOWN, threadDump);
        }
        return this.handleCustomParameters(commandLine);
    }

    public CliProcessResult handleCustomParameters(CommandLine commandLine) {
        CliProcessResult result = new CliProcessResult(CliProcessResult.PostAction.UNKNOWN_COMMAND);
        if (commandLine == null) {
            return result;
        }
        ArrayList<CommandLineParameterDescriptor> initialParameters = new ArrayList<CommandLineParameterDescriptor>();
        ArrayList<CommandLineParameterDescriptor> parameters = new ArrayList<CommandLineParameterDescriptor>();
        Option[] optionArray = commandLine.getOptions();
        int n = optionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Option cliOption = optionArray[n2];
            CommandLineParameterDescriptor param = customParameters.get(cliOption.getOpt());
            if (param == null) {
                param = customParameters.get(cliOption.getLongOpt());
            }
            if (param != null) {
                if (param.isContextInitializer()) {
                    initialParameters.add(param);
                } else {
                    parameters.add(param);
                }
            }
            ++n2;
        }
        ArrayList<CommandLineParameterDescriptor> allParameters = new ArrayList<CommandLineParameterDescriptor>(initialParameters);
        allParameters.addAll(parameters);
        Throwable throwable = null;
        Object var7_7 = null;
        try (CommandLineContext context = new CommandLineContext();){
            for (CommandLineParameterDescriptor param : allParameters) {
                try {
                    if (param.hasArg()) {
                        String[] stringArray = commandLine.getOptionValues(param.getName());
                        int n3 = stringArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String optValue = stringArray[n4];
                            param.getHandler().handleParameter(commandLine, param.getName(), optValue, context);
                            ++n4;
                        }
                    } else {
                        param.getHandler().handleParameter(commandLine, param.getName(), null, context);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error evaluating parameter '" + param.getName() + "'"), (Throwable)e);
                    String output = "Error evaluating parameter '" + param.getName() + "': " + CommonUtils.getAllExceptionMessages((Throwable)e);
                    if (e instanceof CliException) {
                        CliException cliException = (CliException)e;
                        result = new CliProcessResult(CliProcessResult.PostAction.ERROR, output, cliException.getExitCode());
                        break;
                    }
                    result = new CliProcessResult(CliProcessResult.PostAction.ERROR, output);
                    break;
                }
                if (!param.isExitAfterExecute()) continue;
                result = new CliProcessResult(CliProcessResult.PostAction.SHUTDOWN);
                break;
            }
            if (!CommonUtils.isEmpty(context.getResults())) {
                result = new CliProcessResult(CliProcessResult.PostAction.SHUTDOWN, gson.toJson(context.getResults()));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    @Nullable
    public CommandLine getCommandLine() {
        return this.getCommandLine(Platform.getApplicationArgs());
    }

    @Nullable
    public CommandLine getCommandLine(@NotNull String[] args) {
        try {
            List<String> applicationArgs = Arrays.stream(args).collect(Collectors.toList());
            Iterator iterator = applicationArgs.iterator();
            boolean removeArgs = false;
            while (iterator.hasNext()) {
                String arg = (String)iterator.next();
                if (CommonUtils.isEmpty((String)arg)) continue;
                if (arg.startsWith("-")) {
                    boolean argSupported = ALL_OPTIONS.hasOption(arg);
                    if (argSupported) {
                        removeArgs = false;
                        continue;
                    }
                    iterator.remove();
                    removeArgs = true;
                    continue;
                }
                if (!removeArgs) continue;
                iterator.remove();
            }
            return new DefaultParser().parse(ALL_OPTIONS, applicationArgs.toArray(new String[0]), false);
        }
        catch (Exception e) {
            log.warn((Object)("Error parsing command line: " + e.getMessage()));
            return null;
        }
    }
}

