/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.render.awt.viewer.Renderable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class InputHandler
implements ErrorListener,
Renderable {
    protected File sourcefile;
    private File stylesheet;
    private Vector xsltParams;
    private EntityResolver entityResolver;
    private URIResolver uriResolver;
    protected Log log = LogFactory.getLog(InputHandler.class);

    public InputHandler(File xmlfile, File xsltfile, Vector params) {
        this.sourcefile = xmlfile;
        this.stylesheet = xsltfile;
        this.xsltParams = params;
    }

    public InputHandler(File fofile) {
        this.sourcefile = fofile;
    }

    public void renderTo(FOUserAgent userAgent, String outputFormat, OutputStream out) throws FOPException {
        Fop fop = out != null ? userAgent.newFop(outputFormat, out) : userAgent.newFop(outputFormat);
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        this.transformTo(res);
    }

    @Override
    public void renderTo(FOUserAgent userAgent, String outputFormat) throws FOPException {
        this.renderTo(userAgent, outputFormat, null);
    }

    public void transformTo(OutputStream out) throws FOPException {
        StreamResult res = new StreamResult(out);
        this.transformTo(res);
    }

    protected Source createMainSource() {
        Source source;
        String uri;
        InputStream in;
        if (this.sourcefile != null) {
            try {
                in = new FileInputStream(this.sourcefile);
                uri = this.sourcefile.toURI().toASCIIString();
            }
            catch (FileNotFoundException e) {
                return new StreamSource(this.sourcefile);
            }
        } else {
            in = System.in;
            uri = null;
        }
        try {
            InputSource is = new InputSource(in);
            is.setSystemId(uri);
            XMLReader xr = this.getXMLReader();
            if (this.entityResolver != null) {
                xr.setEntityResolver(this.entityResolver);
            }
            source = new SAXSource(xr, is);
        }
        catch (SAXException e) {
            source = this.sourcefile != null ? new StreamSource(this.sourcefile) : new StreamSource(in, uri);
        }
        catch (ParserConfigurationException e) {
            source = this.sourcefile != null ? new StreamSource(this.sourcefile) : new StreamSource(in, uri);
        }
        return source;
    }

    public void createCatalogResolver(FOUserAgent userAgent) {
        String[] classNames = new String[]{"org.apache.xml.resolver.tools.CatalogResolver", "com.sun.org.apache.xml.internal.resolver.tools.CatalogResolver"};
        ResourceEventProducer eventProducer = ResourceEventProducer.Provider.get(userAgent.getEventBroadcaster());
        Class<?> resolverClass = null;
        for (int i = 0; i < classNames.length && resolverClass == null; ++i) {
            try {
                resolverClass = Class.forName(classNames[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (resolverClass == null) {
            eventProducer.catalogResolverNotFound(this);
            return;
        }
        try {
            this.entityResolver = (EntityResolver)resolverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.uriResolver = (URIResolver)resolverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            this.log.error((Object)("Error creating the catalog resolver: " + e.getMessage()));
            eventProducer.catalogResolverNotCreated(this, e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)("Error creating the catalog resolver: " + e.getMessage()));
            eventProducer.catalogResolverNotCreated(this, e.getMessage());
        }
        catch (NoSuchMethodException e) {
            this.log.error((Object)("Error creating the catalog resolver: " + e.getMessage()));
            eventProducer.catalogResolverNotCreated(this, e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.log.error((Object)("Error creating the catalog resolver: " + e.getMessage()));
            eventProducer.catalogResolverNotCreated(this, e.getMessage());
        }
    }

    protected Source createXSLTSource() {
        Source xslt = null;
        if (this.stylesheet != null) {
            if (this.entityResolver != null) {
                try {
                    InputSource is = new InputSource(this.stylesheet.getPath());
                    XMLReader xr = this.getXMLReader();
                    xr.setEntityResolver(this.entityResolver);
                    xslt = new SAXSource(xr, is);
                }
                catch (SAXException sAXException) {
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
            if (xslt == null) {
                xslt = new StreamSource(this.stylesheet);
            }
        }
        return xslt;
    }

    private XMLReader getXMLReader() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://xml.org/sax/features/namespaces", true);
        spf.setFeature("http://apache.org/xml/features/xinclude", true);
        spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        XMLReader xr = spf.newSAXParser().getXMLReader();
        return xr;
    }

    protected void transformTo(Result result) throws FOPException {
        try {
            Transformer transformer;
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Source xsltSource = this.createXSLTSource();
            if (xsltSource == null) {
                transformer = factory.newTransformer();
            } else {
                transformer = factory.newTransformer(xsltSource);
                if (this.xsltParams != null) {
                    for (int i = 0; i < this.xsltParams.size(); i += 2) {
                        transformer.setParameter((String)this.xsltParams.elementAt(i), (String)this.xsltParams.elementAt(i + 1));
                    }
                }
                if (this.uriResolver != null) {
                    transformer.setURIResolver(this.uriResolver);
                }
            }
            transformer.setErrorListener(this);
            Source src = this.createMainSource();
            transformer.transform(src, result);
        }
        catch (Exception e) {
            throw new FOPException(e);
        }
    }

    @Override
    public void warning(TransformerException exc) {
        this.log.warn((Object)exc.getLocalizedMessage());
    }

    @Override
    public void error(TransformerException exc) {
        this.log.error((Object)exc.toString());
    }

    @Override
    public void fatalError(TransformerException exc) throws TransformerException {
        throw exc;
    }
}

