#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 wai-extra
version:              3.1.18
visibility:           public
id:                   wai-extra-3.1.18-5NpCHuT3Y8lC33oFBldZ6y
key:                  wai-extra-3.1.18-5NpCHuT3Y8lC33oFBldZ6y
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
stability:            Stable
homepage:             http://github.com/yesodweb/wai
synopsis:             Provides some basic WAI handlers and middleware.
description:
    Provides basic WAI handler and middleware functionality:

    * WAI Testing Framework

    Hspec testing facilities and helpers for WAI.

    * Event Source/Event Stream

    Send server events to the client. Compatible with the JavaScript
    EventSource API.

    * Accept Override

    Override the Accept header in a request. Special handling for the
    _accept query parameter (which is used throughout WAI override the
    Accept header).

    * Add Headers

    WAI Middleware for adding arbitrary headers to an HTTP request.

    * Clean Path

    Clean a request path to a canonical form.

    * Combine Headers

    Combine duplicate headers into one.

    * GZip Compression

    Negotiate HTTP payload gzip compression.

    * Health check endpoint

    Add an empty health check endpoint.

    * HTTP Basic Authentication

    WAI Basic Authentication Middleware which uses Authorization header.

    * JSONP

    \"JSON with Padding\" middleware. Automatic wrapping of JSON
    responses to convert into JSONP.

    * Method Override / Post

    Allows overriding of the HTTP request method via the _method query string
    parameter.

    * Request Logging

    Request logging middleware for development and production environments

    * Request Rewrite

    Rewrite request path info based on a custom conversion rules.

    * Select

    Dynamically choose between Middlewares.

    * Stream Files

    Convert ResponseFile type responses into ResponseStream type.

    * Virtual Host

    Redirect incoming requests to a new host based on custom rules.


    API docs and the README are available at <http://www.stackage.org/package/wai-extra>.

category:             Web
abi:                  f77c0933fddba1d42346e8022ae15542
exposed:              True
exposed-modules:
    Network.Wai.EventSource Network.Wai.EventSource.EventStream
    Network.Wai.Handler.CGI Network.Wai.Handler.SCGI Network.Wai.Header
    Network.Wai.Middleware.AcceptOverride
    Network.Wai.Middleware.AddHeaders Network.Wai.Middleware.Approot
    Network.Wai.Middleware.Autohead Network.Wai.Middleware.CleanPath
    Network.Wai.Middleware.CombineHeaders
    Network.Wai.Middleware.ForceDomain Network.Wai.Middleware.ForceSSL
    Network.Wai.Middleware.Gzip
    Network.Wai.Middleware.HealthCheckEndpoint
    Network.Wai.Middleware.HttpAuth Network.Wai.Middleware.Jsonp
    Network.Wai.Middleware.Local Network.Wai.Middleware.MethodOverride
    Network.Wai.Middleware.MethodOverridePost
    Network.Wai.Middleware.RealIp Network.Wai.Middleware.RequestLogger
    Network.Wai.Middleware.RequestLogger.JSON
    Network.Wai.Middleware.RequestSizeLimit
    Network.Wai.Middleware.RequestSizeLimit.Internal
    Network.Wai.Middleware.Rewrite Network.Wai.Middleware.Routed
    Network.Wai.Middleware.Select Network.Wai.Middleware.StreamFile
    Network.Wai.Middleware.StripHeaders Network.Wai.Middleware.Timeout
    Network.Wai.Middleware.ValidateHeaders Network.Wai.Middleware.Vhost
    Network.Wai.Parse Network.Wai.Request Network.Wai.Test
    Network.Wai.Test.Internal Network.Wai.UrlMap

hidden-modules:
    Network.Wai.Middleware.RequestLogger.Internal Network.Wai.Util

import-dirs:          /usr/lib/ghc-9.6.6/site-local/wai-extra-3.1.18
library-dirs:         /usr/lib/ghc-9.6.6/site-local/wai-extra-3.1.18
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/wai-extra-3.1.18
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wai-extra
hs-libraries:         HSwai-extra-3.1.18-5NpCHuT3Y8lC33oFBldZ6y
depends:
    HUnit-1.6.2.0-DydRkK1Ty562EFYgxreweA
    aeson-2.1.2.1-JZeWX2s1eQL7Ta3HF3w6fW
    ansi-terminal-1.0.2-3wM6DfsGeit89xAznbDC0C base-4.18.2.1
    base64-bytestring-1.2.1.0-B0w0hfBZVmq3UW6lmjr7G bytestring-0.11.5.3
    call-stack-0.4.0-2bP2isqo6m56I7hpBeHX0O
    case-insensitive-1.2.1.0-LnNRkIvaVf25YvATjz2MZ1 containers-0.6.7
    cookie-0.5.0-Dqi2dsQ09KG8Z0mbWITxu5
    data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz directory-1.3.8.5
    fast-logger-3.2.4-FGVYT6e0rhuAv7u1tJcO4s
    http-types-0.12.4-Ab6499xPt6j7ocIybq2ygA
    iproute-1.7.15-60NLZ4uf2hCB2Eo5ul1FMn
    network-3.1.4.0-DqImTC0JtBs7wAjAQOfbw6
    resourcet-1.2.6-6GDX0mNNFVQIZmMacsito5
    streaming-commons-0.2.3.1-5B3GfFRukpC1TsahHGTkYo text-2.0.2
    time-1.12.2 transformers-0.6.1.0 unix-2.8.4.0
    vault-0.3.1.5-6XoCCfgXDmrK1lP7OIwi21
    wai-3.2.4-L3dKuQqjqvcGg94VR3jCz4
    wai-logger-2.5.0-KTJJVUbAJTmLVONr4EO435
    warp-3.4.0-LfUCTpM1bnI8xt0ZKskiuC
    word8-0.1.3-7y8d2ts6b899pqfTpiB4ap

haddock-interfaces:   /usr/share/doc/haskell-wai-extra/html/wai-extra.haddock
haddock-html:         /usr/share/doc/haskell-wai-extra/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

