/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.impl.IrTryImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/UnhandledExceptionLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "throwableType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "irBooleanType", "throwAsJsException", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getThrowAsJsException", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "isNotFirstWasmExportCallGetter", "isNotFirstWasmExportCallSetter", "processExportFunction", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nUnhandledExceptionLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnhandledExceptionLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/UnhandledExceptionLowering\n+ 2 WasmBackendContext.kt\norg/jetbrains/kotlin/backend/wasm/WasmBackendContext\n+ 3 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 4 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n82#2:154\n414#3,13:155\n414#3,13:171\n133#4,2:168\n133#4,2:184\n1#5:170\n*S KotlinDebug\n*F\n+ 1 UnhandledExceptionLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/UnhandledExceptionLowering\n*L\n64#1:154\n94#1:155,13\n130#1:171,13\n94#1:168,2\n130#1:184,2\n*E\n"})
public final class UnhandledExceptionLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final IrType throwableType;
    @NotNull
    private final IrType irBooleanType;
    @NotNull
    private final IrSimpleFunctionSymbol isNotFirstWasmExportCallGetter;
    @NotNull
    private final IrSimpleFunctionSymbol isNotFirstWasmExportCallSetter;

    public UnhandledExceptionLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.throwableType = this.context.getIrBuiltIns().getThrowableType();
        this.irBooleanType = this.context.getWasmSymbols().getIrBuiltIns().getBooleanType();
        IrSimpleFunction irSimpleFunction = ((IrProperty)this.context.getWasmSymbols().isNotFirstWasmExportCall$backend_wasm().getOwner()).getGetter();
        Intrinsics.checkNotNull(irSimpleFunction);
        this.isNotFirstWasmExportCallGetter = irSimpleFunction.getSymbol();
        IrSimpleFunction irSimpleFunction2 = ((IrProperty)this.context.getWasmSymbols().isNotFirstWasmExportCall$backend_wasm().getOwner()).getSetter();
        Intrinsics.checkNotNull(irSimpleFunction2);
        this.isNotFirstWasmExportCallSetter = irSimpleFunction2.getSymbol();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    private final IrSimpleFunctionSymbol getThrowAsJsException() {
        return this.context.getWasmSymbols().getJsRelatedSymbols().getThrowAsJsException$backend_wasm();
    }

    /*
     * WARNING - void declaration
     */
    private final void processExportFunction(IrFunction irFunction) {
        void $this$processExportFunction_u24lambda_u245_u24lambda_u242;
        void this_$iv$iv;
        IrType irType;
        IrBody irBody;
        void this_$iv;
        IrBody irBody2 = irFunction.getBody();
        if (irBody2 == null) {
            return;
        }
        IrBody body = irBody2;
        if (body instanceof IrBlockBody && ((IrBlockBody)body).getStatements().isEmpty()) {
            return;
        }
        WasmBackendContext wasmBackendContext = this.context;
        IrFile irFile$iv = IrUtilsKt.getFile(irFunction);
        boolean $i$f$applyIfDefined = false;
        WasmBackendContext.CrossFileContext crossFileContext = this_$iv.getFileContexts().get(irFile$iv);
        if (crossFileContext != null) {
            WasmBackendContext.CrossFileContext crossFileContext2;
            WasmBackendContext.CrossFileContext it = crossFileContext2 = crossFileContext;
            boolean bl = false;
            if (CollectionsKt.contains((Iterable)it.getClosureCallExports().values(), irFunction)) {
                return;
            }
        }
        if ((irBody = body) instanceof IrExpressionBody) {
            irType = ((IrExpressionBody)body).getExpression().getType();
        } else if (irBody instanceof IrBlockBody) {
            irType = this.context.getIrBuiltIns().getUnitType();
        } else {
            if (irBody instanceof IrSyntheticBody) {
                org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.syntheticBodyIsNotSupported(irFunction);
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
        IrType bodyType = irType;
        DeclarationIrBuilder $this$processExportFunction_u24lambda_u245 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)irFunction.getSymbol(), 0, 0, 6, null);
        boolean bl = false;
        IrDeclarationParent irDeclarationParent = irFunction;
        IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE();
        Name name2 = Name.identifier("currentIsNotFirstWasmExportCall");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        IrVariable currentIsNotFirstWasmExportCall = DeclarationBuildersKt.buildVariable$default(irDeclarationParent, -1, -1, irDeclarationOrigin, name2, this.irBooleanType, false, false, false, 448, null);
        IrDeclarationParent irDeclarationParent2 = irFunction;
        IrDeclarationOrigin irDeclarationOrigin2 = IrDeclarationOrigin.Companion.getCATCH_PARAMETER();
        Name name3 = Name.identifier("e");
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        IrVariable e2 = DeclarationBuildersKt.buildVariable$default(irDeclarationParent2, -1, -1, irDeclarationOrigin2, name3, this.throwableType, false, false, false, 448, null);
        currentIsNotFirstWasmExportCall.setInitializer(ExpressionHelpersKt.irGet($this$processExportFunction_u24lambda_u245, this.irBooleanType, null, this.isNotFirstWasmExportCallGetter));
        IrBuilderWithScope $this$irComposite_u24default$iv = $this$processExportFunction_u24lambda_u245;
        int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
        int endOffset$iv22 = $this$irComposite_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irComposite = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv22, origin$iv, resultType$iv, true);
        boolean $i$f$block = false;
        void $this$processExportFunction_u24lambda_u245_u24lambda_u241 = this_$iv$iv;
        boolean bl2 = false;
        $this$processExportFunction_u24lambda_u245_u24lambda_u241.unaryPlus(ExpressionHelpersKt.irSet((IrBuilder)$this$processExportFunction_u24lambda_u245_u24lambda_u241, ((IrSimpleFunction)this.isNotFirstWasmExportCallSetter.getOwner()).getReturnType(), null, this.isNotFirstWasmExportCallSetter, IrUtilsKt.toIrConst$default(true, this.irBooleanType, 0, 0, 6, null)));
        $this$processExportFunction_u24lambda_u245_u24lambda_u241.unaryPlus(IrUtilsKt.getStatements(body));
        IrExpression tryBody = (IrExpression)this_$iv$iv.doBuild();
        IrCall endOffset$iv22 = startOffset$iv = ExpressionHelpersKt.irCall((IrBuilder)$this$processExportFunction_u24lambda_u245, this.getThrowAsJsException());
        IrExpression irExpression = LowerUtilsKt.irThrow($this$processExportFunction_u24lambda_u245, ExpressionHelpersKt.irGet((IrBuilder)$this$processExportFunction_u24lambda_u245, e2, this.throwableType));
        IrExpression irExpression2 = ExpressionHelpersKt.irGet((IrBuilder)$this$processExportFunction_u24lambda_u245, currentIsNotFirstWasmExportCall, this.irBooleanType);
        IrType irType2 = bodyType;
        IrBuilder irBuilder = $this$processExportFunction_u24lambda_u245;
        IrVariable irVariable = e2;
        Object object = $this$processExportFunction_u24lambda_u245;
        boolean bl3 = false;
        $this$processExportFunction_u24lambda_u245_u24lambda_u242.getArguments().set(0, ExpressionHelpersKt.irGet((IrBuilder)$this$processExportFunction_u24lambda_u245, e2, this.throwableType));
        Unit unit = Unit.INSTANCE;
        IrCatch irCatch = LowerUtilsKt.irCatch$default((IrBuilderWithScope)object, irVariable, ExpressionHelpersKt.irIfThenElse$default(irBuilder, irType2, irExpression2, irExpression, startOffset$iv, null, 16, null), null, 4, null);
        IrCall irCall = ExpressionHelpersKt.irSet($this$processExportFunction_u24lambda_u245, ((IrSimpleFunction)this.isNotFirstWasmExportCallSetter.getOwner()).getReturnType(), null, this.isNotFirstWasmExportCallSetter, ExpressionHelpersKt.irGet((IrBuilder)$this$processExportFunction_u24lambda_u245, currentIsNotFirstWasmExportCall, this.irBooleanType));
        IrTryImpl tryWrap = ExpressionHelpersKt.irTry($this$processExportFunction_u24lambda_u245, bodyType, tryBody, CollectionsKt.listOf(irCatch), irCall);
        IrBody irBody3 = body;
        if (irBody3 instanceof IrExpressionBody) {
            void $this$processExportFunction_u24lambda_u245_u24lambda_u243;
            void this_$iv$iv2;
            IrBuilderWithScope $this$irComposite_u24default$iv2 = $this$processExportFunction_u24lambda_u245;
            int startOffset$iv2 = $this$irComposite_u24default$iv2.getStartOffset();
            int endOffset$iv = $this$irComposite_u24default$iv2.getEndOffset();
            IrStatementOrigin origin$iv2 = null;
            IrType resultType$iv2 = null;
            boolean $i$f$irComposite2 = false;
            IrBlockBuilder irBlockBuilder2 = new IrBlockBuilder($this$irComposite_u24default$iv2.getContext(), $this$irComposite_u24default$iv2.getScope(), startOffset$iv2, endOffset$iv, origin$iv2, resultType$iv2, true);
            boolean $i$f$block2 = false;
            void var29_40 = this_$iv$iv2;
            object = (IrExpressionBody)body;
            boolean bl4 = false;
            $this$processExportFunction_u24lambda_u245_u24lambda_u243.unaryPlus(currentIsNotFirstWasmExportCall);
            $this$processExportFunction_u24lambda_u245_u24lambda_u243.unaryPlus(tryWrap);
            ((IrExpressionBody)object).setExpression((IrExpression)this_$iv$iv2.doBuild());
        } else if (irBody3 instanceof IrBlockBody) {
            List<IrStatement> $this$processExportFunction_u24lambda_u245_u24lambda_u244 = ((IrBlockBody)body).getStatements();
            boolean bl5 = false;
            $this$processExportFunction_u24lambda_u245_u24lambda_u244.clear();
            $this$processExportFunction_u24lambda_u245_u24lambda_u244.add(currentIsNotFirstWasmExportCall);
            $this$processExportFunction_u24lambda_u245_u24lambda_u244.add(tryWrap);
        } else {
            if (irBody3 instanceof IrSyntheticBody) {
                org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.syntheticBodyIsNotSupported(irFunction);
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        if (!this.context.isWasmJsTarget()) {
            return;
        }
        for (IrDeclaration declaration : irFile.getDeclarations()) {
            if (!(declaration instanceof IrFunction) || !AnnotationUtilsKt.isJsExport(declaration)) continue;
            this.processExportFunction((IrFunction)declaration);
        }
    }
}

