/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedAttribute;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedVisibility;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\"\u0010\r\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\fH\u0002\u001a\"\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\fH\u0002\u001a\u0016\u0010\u0012\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u0014\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u0015\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0016\u001a\u00020\u0003*\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0017\u001a\u00020\u0003*\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u001a\u001a!\u0010!\u001a\u0002H\"\"\b\b\u0000\u0010\"*\u00020#*\u0002H\"2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010$\u001a\n\u0010%\u001a\u00020\u0001*\u00020&\u001a\n\u0010'\u001a\u00020\u0001*\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\"\u0018\u0010\u0006\u001a\u00020\u0003*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\"\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"magicPropertyName", "", "isInterface", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;)Z", "isStaticMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "getExportCandidate", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "shouldDeclarationBeExportedImplicitlyOrExplicitly", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "source", "shouldDeclarationBeExported", "isAllowedFakeOverriddenDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableDeclaration;", "isOverriddenEnumProperty", "isOverriddenExported", "isExported", "isExportedImplicitlyOrExplicitly", "toExportedVisibility", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedVisibility;", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "reservedWords", "", "strictModeReservedWords", "getStrictModeReservedWords", "()Ljava/util/Set;", "allReservedWords", "withAttributesFor", "T", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedDeclaration;", "(Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedDeclaration;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedDeclaration;", "getExportedIdentifierForClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getExportedIdentifier", "backend.js"})
@SourceDebugExtension(value={"SMAP\nExportModelGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/export/ExportModelGeneratorKt\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CollectionUtil.kt\norg/jetbrains/kotlin/utils/CollectionUtilKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n*L\n1#1,917:1\n233#2:918\n1563#3:919\n1634#3,3:920\n1761#3,3:931\n32#4,2:923\n9#4,6:925\n1#5:934\n1#5:936\n28#6:935\n29#6:937\n*S KotlinDebug\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/export/ExportModelGeneratorKt\n*L\n802#1:918\n811#1:919\n811#1:920,3\n819#1:931,3\n812#1:923,2\n812#1:925,6\n911#1:936\n911#1:935\n911#1:937\n*E\n"})
public final class ExportModelGeneratorKt {
    @NotNull
    private static final Set<String> reservedWords;
    @NotNull
    private static final Set<String> strictModeReservedWords;
    @NotNull
    private static final Set<String> allReservedWords;

    private static final boolean isInterface(IrClassifierSymbol $this$isInterface) {
        IrSymbolOwner irSymbolOwner = $this$isInterface.getOwner();
        IrClass irClass = irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null;
        return irClass != null ? IrUtilsKt.isInterface(irClass) : false;
    }

    private static final boolean isStaticMethod(IrFunction $this$isStaticMethod) {
        return ES6ConstructorLoweringKt.isEs6ConstructorReplacement($this$isStaticMethod) || IrDeclarationsKt.isStaticMethodOfClass($this$isStaticMethod);
    }

    private static final IrDeclarationWithName getExportCandidate(IrDeclaration declaration) {
        if (!(declaration instanceof IrDeclarationWithVisibility) || !(declaration instanceof IrDeclarationWithName) || !((IrDeclarationWithVisibility)declaration).getVisibility().isPublicAPI() || IrUtilsKt.isExpect(declaration)) {
            return null;
        }
        if (declaration instanceof IrSimpleFunction) {
            IrProperty property2;
            IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)declaration).getCorrespondingPropertySymbol();
            IrProperty irProperty = property2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (property2 != null) {
                return Intrinsics.areEqual(property2.getGetter(), declaration) ? (IrDeclarationWithName)property2 : null;
            }
        }
        return (IrDeclarationWithName)declaration;
    }

    private static final boolean shouldDeclarationBeExportedImplicitlyOrExplicitly(IrDeclarationWithName declaration, JsIrBackendContext context2, IrDeclaration source) {
        return AnnotationUtilsKt.isJsImplicitExport(declaration) || ExportModelGeneratorKt.shouldDeclarationBeExported(declaration, context2, source);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldDeclarationBeExported(IrDeclarationWithName declaration, JsIrBackendContext context2, IrDeclaration source) {
        boolean bl;
        boolean bl2;
        if (declaration instanceof IrClass && ((IrClass)declaration).getKind() == ClassKind.ENUM_ENTRY) {
            return false;
        }
        if (AnnotationUtilsKt.isJsExportIgnore(declaration)) return false;
        Object object = declaration instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)((Object)declaration) : null;
        if (object != null && (object = object.getVisibility()) != null) {
            if (!((DescriptorVisibility)object).isPublicAPI()) {
                return false;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) {
            return false;
        }
        if (CollectionsKt.contains((Iterable)context2.getAdditionalExportedDeclarationNames(), IrUtilsKt.getFqNameWhenAvailable(declaration))) {
            return true;
        }
        if (((HashSet)context2.getAdditionalExportedDeclarations()).contains(declaration)) {
            return true;
        }
        if (source instanceof IrOverridableDeclaration) {
            boolean overriddenNonEmpty;
            boolean bl3 = overriddenNonEmpty = !((Collection)((IrOverridableDeclaration)source).getOverriddenSymbols()).isEmpty();
            if (overriddenNonEmpty) {
                boolean bl4;
                if (ExportModelGeneratorKt.isOverriddenExported((IrOverridableDeclaration)source, context2)) return true;
                IrDeclaration irDeclaration = source;
                IrSimpleFunction irSimpleFunction = irDeclaration instanceof IrSimpleFunction ? (IrSimpleFunction)irDeclaration : null;
                if (irSimpleFunction != null) {
                    if (IrUtilsKt.isMethodOfAny(irSimpleFunction)) {
                        return true;
                    }
                    bl4 = false;
                } else {
                    bl4 = false;
                }
                if (bl4) return true;
                if (!ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration((IrOverridableDeclaration)source, context2)) return false;
                return true;
            }
        }
        if (AnnotationUtilsKt.isJsExport(declaration)) {
            return true;
        }
        IrDeclarationParent parent2 = declaration.getParent();
        if (parent2 instanceof IrDeclarationWithName) {
            bl = ExportModelGeneratorKt.shouldDeclarationBeExported$default((IrDeclarationWithName)((Object)parent2), context2, null, 4, null);
            return bl;
        } else {
            if (!(parent2 instanceof IrAnnotationContainer)) return false;
            bl = AnnotationUtilsKt.isJsExport((IrAnnotationContainer)((Object)parent2));
        }
        return bl;
    }

    static /* synthetic */ boolean shouldDeclarationBeExported$default(IrDeclarationWithName irDeclarationWithName, JsIrBackendContext jsIrBackendContext, IrDeclaration irDeclaration, int n2, Object object) {
        if ((n2 & 4) != 0) {
            irDeclaration = irDeclarationWithName;
        }
        return ExportModelGeneratorKt.shouldDeclarationBeExported(irDeclarationWithName, jsIrBackendContext, irDeclaration);
    }

    public static final boolean isAllowedFakeOverriddenDeclaration(@NotNull IrOverridableDeclaration<?> $this$isAllowedFakeOverriddenDeclaration, @NotNull JsIrBackendContext context2) {
        IrOverridableDeclaration<?> irOverridableDeclaration;
        Intrinsics.checkNotNullParameter($this$isAllowedFakeOverriddenDeclaration, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (ExportModelGeneratorKt.isOverriddenEnumProperty($this$isAllowedFakeOverriddenDeclaration, context2)) {
            return true;
        }
        boolean condition$iv = $this$isAllowedFakeOverriddenDeclaration.isFakeOverride();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            irOverridableDeclaration = IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstract($this$isAllowedFakeOverriddenDeclaration, new Function1<?, Boolean>($this$isAllowedFakeOverriddenDeclaration, context2){
                final /* synthetic */ IrOverridableDeclaration<?> $this_isAllowedFakeOverriddenDeclaration;
                final /* synthetic */ JsIrBackendContext $context;
                {
                    this.$this_isAllowedFakeOverriddenDeclaration = $receiver;
                    this.$context = $context;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final Boolean invoke(IrOverridableDeclaration<?> it) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (it != this.$this_isAllowedFakeOverriddenDeclaration && !it.isFakeOverride()) {
                        IrClass irClass = IrUtilsKt.getParentClassOrNull(it);
                        boolean bl2 = irClass != null ? ExportModelGeneratorKt.isExported(irClass, this.$context) : false;
                        if (bl2) {
                            bl = false;
                            return bl;
                        }
                    }
                    bl = true;
                    return bl;
                }
            });
        } else {
            irOverridableDeclaration = null;
        }
        if (irOverridableDeclaration == null) {
            return false;
        }
        IrOverridableDeclaration<?> firstExportedRealOverride2 = irOverridableDeclaration;
        return IrJsUtilsKt.isExportedInterface(IrUtilsKt.getParentClassOrNull(firstExportedRealOverride2), context2) && !AnnotationUtilsKt.isJsExportIgnore(firstExportedRealOverride2);
    }

    /*
     * Unable to fully structure code
     */
    public static final boolean isOverriddenEnumProperty(@NotNull IrOverridableDeclaration<?> $this$isOverriddenEnumProperty, @NotNull JsIrBackendContext context) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter($this$isOverriddenEnumProperty, "<this>");
                Intrinsics.checkNotNullParameter(context, "context");
                $this$map$iv = $this$isOverriddenEnumProperty.getOverriddenSymbols();
                $i$f$map = false;
                var4_4 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var9_9 = (IrSymbol)item$iv$iv;
                    var11_11 = destination$iv$iv;
                    $i$a$-map-ExportModelGeneratorKt$isOverriddenEnumProperty$1 = false;
                    var11_11.add(it.getOwner());
                }
                $this$filterIsInstanceAnd$iv = (List)destination$iv$iv;
                $i$f$filterIsInstanceAnd = false;
                if (!$this$filterIsInstanceAnd$iv.isEmpty()) break block4;
                v0 = CollectionsKt.emptyList();
                break block5;
            }
            $this$mapTo$iv$iv = $this$filterIsInstanceAnd$iv;
            destination$iv$iv = new SmartList<E>();
            $i$f$filterIsInstanceAndTo = false;
            for (T element$iv$iv : $this$filterIsInstanceAndTo$iv$iv) {
                if (!(element$iv$iv instanceof IrOverridableDeclaration)) continue;
                it = (IrOverridableDeclaration)element$iv$iv;
                $i$a$-filterIsInstanceAnd-ExportModelGeneratorKt$isOverriddenEnumProperty$2 = false;
                if (!it.getOverriddenSymbols().isEmpty()) ** GOTO lbl-1000
                v1 = IrUtilsKt.getParentClassOrNull(it);
                if (Intrinsics.areEqual(v1 != null ? v1.getSymbol() : null, context.getIrBuiltIns().getEnumClass())) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v0 = (List)destination$iv$iv;
        }
        return ((Collection)v0).isEmpty() == false;
    }

    public static final boolean isOverriddenExported(@NotNull IrOverridableDeclaration<?> $this$isOverriddenExported, @NotNull JsIrBackendContext context2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter($this$isOverriddenExported, "<this>");
            Intrinsics.checkNotNullParameter(context2, "context");
            Iterable $this$any$iv = $this$isOverriddenExported.getOverriddenSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrDeclarationWithName candidate2;
                    IrSymbol it = (IrSymbol)element$iv;
                    boolean bl2 = false;
                    IrSymbolOwner irSymbolOwner = it.getOwner();
                    Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
                    IrDeclarationWithName owner = (IrDeclarationWithName)irSymbolOwner;
                    IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.getExportCandidate(owner);
                    if (irDeclarationWithName == null) {
                        irDeclarationWithName = owner;
                    }
                    if (!ExportModelGeneratorKt.shouldDeclarationBeExported(candidate2 = irDeclarationWithName, context2, owner)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isExported(@NotNull IrDeclaration $this$isExported, @NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter($this$isExported, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.getExportCandidate($this$isExported);
        if (irDeclarationWithName == null) {
            return false;
        }
        IrDeclarationWithName candidate2 = irDeclarationWithName;
        return ExportModelGeneratorKt.shouldDeclarationBeExported(candidate2, context2, $this$isExported);
    }

    public static final boolean isExportedImplicitlyOrExplicitly(@NotNull IrDeclaration $this$isExportedImplicitlyOrExplicitly, @NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter($this$isExportedImplicitlyOrExplicitly, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.getExportCandidate($this$isExportedImplicitlyOrExplicitly);
        if (irDeclarationWithName == null) {
            return false;
        }
        IrDeclarationWithName candidate2 = irDeclarationWithName;
        return ExportModelGeneratorKt.shouldDeclarationBeExportedImplicitlyOrExplicitly(candidate2, context2, $this$isExportedImplicitlyOrExplicitly);
    }

    @NotNull
    public static final ExportedVisibility toExportedVisibility(@NotNull DescriptorVisibility $this$toExportedVisibility) {
        Intrinsics.checkNotNullParameter($this$toExportedVisibility, "<this>");
        return Intrinsics.areEqual($this$toExportedVisibility, DescriptorVisibilities.PROTECTED) ? ExportedVisibility.PROTECTED : ExportedVisibility.DEFAULT;
    }

    @NotNull
    public static final Set<String> getStrictModeReservedWords() {
        return strictModeReservedWords;
    }

    @NotNull
    public static final <T extends ExportedDeclaration> T withAttributesFor(@NotNull T $this$withAttributesFor, @NotNull IrDeclaration declaration) {
        block0: {
            Intrinsics.checkNotNullParameter($this$withAttributesFor, "<this>");
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            String string = AnnotationUtilsKt.getDeprecated(declaration);
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            $this$withAttributesFor.getAttributes().add(new ExportedAttribute.DeprecatedAttribute(it));
        }
        return $this$withAttributesFor;
    }

    @NotNull
    public static final String getExportedIdentifierForClass(@NotNull IrClass $this$getExportedIdentifierForClass) {
        Intrinsics.checkNotNullParameter($this$getExportedIdentifierForClass, "<this>");
        IrClass parentClass = IrUtilsKt.getParentClassOrNull($this$getExportedIdentifierForClass);
        return parentClass != null && $this$getExportedIdentifierForClass.isCompanion() && IrUtilsKt.isInterface(parentClass) ? ExportModelGeneratorKt.getExportedIdentifierForClass(parentClass) : ExportModelGeneratorKt.getExportedIdentifier($this$getExportedIdentifierForClass);
    }

    @NotNull
    public static final String getExportedIdentifier(@NotNull IrDeclarationWithName $this$getExportedIdentifier) {
        Intrinsics.checkNotNullParameter($this$getExportedIdentifier, "<this>");
        Name $this$getExportedIdentifier_u24lambda_u246 = AnnotationUtilsKt.getJsNameOrKotlinName($this$getExportedIdentifier);
        boolean bl = false;
        if ($this$getExportedIdentifier_u24lambda_u246.isSpecial()) {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Cannot export special name: " + $this$getExportedIdentifier.getName().asString() + " for declaration";
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl2 = false;
            IrExceptionBuilder $this$getExportedIdentifier_u24lambda_u246_u24lambda_u245 = $this$irError_u24lambda_u240$iv;
            boolean bl3 = false;
            $this$getExportedIdentifier_u24lambda_u246_u24lambda_u245.withIrEntry("this", $this$getExportedIdentifier);
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        String string = $this$getExportedIdentifier_u24lambda_u246.getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string, "with(...)");
        return string;
    }

    public static final /* synthetic */ IrDeclarationWithName access$getExportCandidate(IrDeclaration declaration) {
        return ExportModelGeneratorKt.getExportCandidate(declaration);
    }

    public static final /* synthetic */ boolean access$shouldDeclarationBeExportedImplicitlyOrExplicitly(IrDeclarationWithName declaration, JsIrBackendContext context2, IrDeclaration source) {
        return ExportModelGeneratorKt.shouldDeclarationBeExportedImplicitlyOrExplicitly(declaration, context2, source);
    }

    public static final /* synthetic */ boolean access$isStaticMethod(IrFunction $receiver) {
        return ExportModelGeneratorKt.isStaticMethod($receiver);
    }

    public static final /* synthetic */ Set access$getAllReservedWords$p() {
        return allReservedWords;
    }

    public static final /* synthetic */ boolean access$isInterface(IrClassifierSymbol $receiver) {
        return ExportModelGeneratorKt.isInterface($receiver);
    }

    static {
        String[] stringArray = new String[]{"break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "enum", "export", "extends", "false", "finally", "for", "function", "if", "import", "in", "instanceof", "new", "null", "return", "super", "switch", "this", "throw", "true", "try", "typeof", "var", "void", "while", "with"};
        reservedWords = SetsKt.setOf(stringArray);
        stringArray = new String[]{"as", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"};
        strictModeReservedWords = SetsKt.setOf(stringArray);
        allReservedWords = SetsKt.plus(reservedWords, (Iterable)strictModeReservedWords);
    }
}

