/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.logging;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.logging.LoggerTypeSearcher;
import com.intellij.codeInspection.logging.LoggingPlaceholderUtilKt;
import com.intellij.codeInspection.logging.LoggingSimilarMessageInspectionKt;
import com.intellij.codeInspection.logging.LoggingStringPartEvaluator;
import com.intellij.codeInspection.logging.LoggingUtil;
import com.intellij.codeInspection.logging.MessageLog;
import com.intellij.codeInspection.logging.NavigateToDuplicateFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\"\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0016H\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0014H\u0002R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/codeInspection/logging/LoggingSimilarMessageInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "mySkipErrorLogLevel", "", "myMinTextLength", "", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "runForWholeFile", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "hasSetThrowable", "node", "Lorg/jetbrains/uast/UCallExpression;", "loggerType", "Lcom/intellij/codeInspection/logging/LoggerTypeSearcher;", "collectParts", "", "Lcom/intellij/codeInspection/logging/LoggingStringPartEvaluator$PartHolder;", "searcher", "registerProblem", "", "current", "other", "PlaceholderCountMatchesArgumentCountVisitor", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nLoggingSimilarMessageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingSimilarMessageInspection.kt\ncom/intellij/codeInspection/logging/LoggingSimilarMessageInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,482:1\n1869#2,2:483\n*S KotlinDebug\n*F\n+ 1 LoggingSimilarMessageInspection.kt\ncom/intellij/codeInspection/logging/LoggingSimilarMessageInspection\n*L\n199#1:483,2\n*E\n"})
public final class LoggingSimilarMessageInspection
extends AbstractBaseUastLocalInspectionTool {
    @JvmField
    public boolean mySkipErrorLogLevel = true;
    @JvmField
    public int myMinTextLength = 5;

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.number((String)"myMinTextLength", (String)JvmAnalysisBundle.message("jvm.inspection.logging.similar.message.problem.min.similar.length", new Object[0]), (int)3, (int)100), OptPane.checkbox((String)"mySkipErrorLogLevel", (String)JvmAnalysisBundle.message("jvm.inspection.logging.similar.message.problem.skip.on.error", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile file = holder.getFile().getOriginalFile().getVirtualFile();
        if (file == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Module fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project2);
        if (!(JavaLibraryUtil.hasLibraryClass((Module)fileModule, (String)"org.slf4j.Logger") || JavaLibraryUtil.hasLibraryClass((Module)fileModule, (String)"org.apache.logging.log4j.Logger") || JavaLibraryUtil.hasLibraryClass((Module)fileModule, (String)"com.intellij.openapi.diagnostic.Logger"))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        Class[] classArray = new Class[]{UFile.class};
        return UastHintedVisitorAdapter.Companion.create(language, (AbstractUastNonRecursiveVisitor)new PlaceholderCountMatchesArgumentCountVisitor(holder, this.myMinTextLength), classArray, true);
    }

    private final boolean hasSetThrowable(UCallExpression node, LoggerTypeSearcher loggerType) {
        if (loggerType == null) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)loggerType, (Object)LoggingPlaceholderUtilKt.getSLF4J_BUILDER_HOLDER()) && !Intrinsics.areEqual((Object)loggerType, (Object)LoggingPlaceholderUtilKt.getLOG4J_LOG_BUILDER_HOLDER())) {
            return false;
        }
        UExpression currentCall = null;
        currentCall = node.getReceiver();
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, 20);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            String methodName;
            int element$iv;
            int ignore = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            if (currentCall instanceof UQualifiedReferenceExpression) {
                currentCall = ((UQualifiedReferenceExpression)currentCall).getSelector();
                continue;
            }
            if (!(currentCall instanceof UCallExpression)) {
                return false;
            }
            if (((UCallExpression)currentCall).getMethodName() == null) {
                return false;
            }
            if (Intrinsics.areEqual((Object)methodName, (Object)"withThrowable") || Intrinsics.areEqual((Object)methodName, (Object)"setCause")) {
                return true;
            }
            currentCall = ((UCallExpression)currentCall).getReceiver();
        }
        return false;
    }

    private final List<LoggingStringPartEvaluator.PartHolder> collectParts(UCallExpression node, LoggerTypeSearcher searcher) {
        if (searcher == null) {
            return null;
        }
        List arguments = node.getValueArguments();
        UElement uElement = UResolvableKt.resolveToUElement((UResolvable)((UResolvable)node));
        UMethod uMethod = uElement instanceof UMethod ? (UMethod)uElement : null;
        if (uMethod == null) {
            return null;
        }
        UMethod method = uMethod;
        List parameters = method.getUastParameters();
        UExpression logStringArgument = null;
        if (parameters.isEmpty() || arguments.isEmpty()) {
            UExpression uExpression = LoggingPlaceholderUtilKt.findMessageSetterStringArg(node, searcher);
            if (uExpression == null) {
                return null;
            }
            logStringArgument = uExpression;
        } else {
            Integer n = LoggingPlaceholderUtilKt.getLogStringIndex(parameters);
            if (n == null) {
                return null;
            }
            int index = n;
            logStringArgument = (UExpression)arguments.get(index - 1);
        }
        return LoggingStringPartEvaluator.Companion.calculateValue$intellij_jvm_analysis_impl(logStringArgument);
    }

    private final void registerProblem(ProblemsHolder holder, UCallExpression current, UCallExpression other) {
        PsiElement psiElement = current.getSourcePsi();
        if (psiElement == null) {
            return;
        }
        PsiElement anchor = psiElement;
        PsiElement psiElement2 = other.getSourcePsi();
        if (psiElement2 == null) {
            return;
        }
        PsiElement otherElement = psiElement2;
        PsiElement psiElement3 = PsiTreeUtil.findCommonParent((PsiElement)anchor, (PsiElement)otherElement);
        if (psiElement3 == null) {
            return;
        }
        PsiElement commonParent = psiElement3;
        TextRange textRange = anchor.getTextRange();
        TextRange textRange2 = commonParent.getTextRange();
        if (textRange2 == null) {
            return;
        }
        int delta = textRange2.getStartOffset();
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new NavigateToDuplicateFix(otherElement)};
        holder.registerProblem(commonParent, textRange.shiftLeft(delta), JvmAnalysisBundle.message("jvm.inspection.logging.similar.message.problem.descriptor", new Object[0]), localQuickFixArray);
    }

    public static final /* synthetic */ boolean access$hasSetThrowable(LoggingSimilarMessageInspection $this, UCallExpression node, LoggerTypeSearcher loggerType) {
        return $this.hasSetThrowable(node, loggerType);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInspection/logging/LoggingSimilarMessageInspection$PlaceholderCountMatchesArgumentCountVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "myMinTextLength", "", "<init>", "(Lcom/intellij/codeInspection/logging/LoggingSimilarMessageInspection;Lcom/intellij/codeInspection/ProblemsHolder;I)V", "visitFile", "", "node", "Lorg/jetbrains/uast/UFile;", "sequenceOfCalls", "call1", "Lorg/jetbrains/uast/UCallExpression;", "call2", "collectCalls", "", "file", "intellij.jvm.analysis.impl"})
    @SourceDebugExtension(value={"SMAP\nLoggingSimilarMessageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingSimilarMessageInspection.kt\ncom/intellij/codeInspection/logging/LoggingSimilarMessageInspection$PlaceholderCountMatchesArgumentCountVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,482:1\n1491#2:483\n1516#2,2:484\n1518#2:487\n1519#2,3:495\n1563#2:498\n1634#2,2:499\n1491#2:501\n1516#2,3:502\n1519#2,3:512\n1636#2:515\n1563#2:516\n1634#2,2:517\n1563#2:519\n1634#2,3:520\n774#2:523\n865#2:524\n1761#2,3:525\n866#2:528\n1636#2:529\n1617#2,9:530\n1869#2:539\n1870#2:541\n1626#2:542\n774#2:543\n865#2,2:544\n1617#2,9:547\n1869#2:556\n1870#2:558\n1626#2:559\n774#2:560\n865#2,2:561\n1491#2:564\n1516#2,3:565\n1519#2,3:575\n171#3:486\n382#4,7:488\n382#4,7:505\n382#4,7:568\n1#5:540\n1#5:546\n1#5:557\n1#5:563\n*S KotlinDebug\n*F\n+ 1 LoggingSimilarMessageInspection.kt\ncom/intellij/codeInspection/logging/LoggingSimilarMessageInspection$PlaceholderCountMatchesArgumentCountVisitor\n*L\n80#1:483\n80#1:484,2\n80#1:487\n80#1:495,3\n81#1:498\n81#1:499,2\n82#1:501\n82#1:502,3\n82#1:512,3\n81#1:515\n84#1:516\n84#1:517,2\n85#1:519\n85#1:520,3\n86#1:523\n86#1:524\n86#1:525,3\n86#1:528\n84#1:529\n95#1:530,9\n95#1:539\n95#1:541\n95#1:542\n96#1:543\n96#1:544,2\n103#1:547,9\n103#1:556\n103#1:558\n103#1:559\n104#1:560\n104#1:561,2\n113#1:564\n113#1:565,3\n113#1:575,3\n80#1:486\n80#1:488,7\n82#1:505,7\n113#1:568,7\n95#1:540\n103#1:557\n*E\n"})
    public final class PlaceholderCountMatchesArgumentCountVisitor
    extends AbstractUastNonRecursiveVisitor {
        @NotNull
        private final ProblemsHolder holder;
        private final int myMinTextLength;

        public PlaceholderCountMatchesArgumentCountVisitor(ProblemsHolder holder, int myMinTextLength) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
            this.myMinTextLength = myMinTextLength;
        }

        /*
         * WARNING - void declaration
         */
        public boolean visitFile(@NotNull UFile node) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object value$iv$iv$iv;
            boolean $i$f$getOrPut;
            Object $this$getOrPut$iv$iv$iv;
            String key$iv$iv;
            Iterable $this$groupBy$iv;
            Object object;
            LoggingSimilarMessageInspection $this$mapTo$iv$iv2;
            List list$iv$iv;
            Object key$iv$iv2;
            Iterable $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Set calls = CollectionsKt.toMutableSet((Iterable)this.collectCalls(node));
            if (calls.isEmpty()) {
                return true;
            }
            Iterable $this$groupBy$iv2 = calls;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv2;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                UCallExpression it = (UCallExpression)element$iv$iv;
                boolean bl = false;
                UExpression uExpression = it.getReceiver();
                PsiElement $this$toUElementOfType$iv = uExpression != null ? UastUtils.tryResolve((UElement)((UElement)uExpression)) : null;
                boolean $i$f$toUElementOfType = false;
                key$iv$iv2 = (UVariable)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UVariable.class);
                Object $this$getOrPut$iv$iv$iv2 = destination$iv$iv;
                boolean $i$f$getOrPut2 = false;
                Object value$iv$iv$iv2 = $this$getOrPut$iv$iv$iv2.get(key$iv$iv2);
                if (value$iv$iv$iv2 == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv2.put(key$iv$iv2, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv2;
                }
                list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv2 = destination$iv$iv.values();
            boolean $i$f$map22 = false;
            $this$groupByTo$iv$iv = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            Iterator iterator = $this$mapTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                void $this$groupByTo$iv$iv2;
                Iterator group;
                Object item$iv$iv = iterator.next();
                list$iv$iv = (List)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                $this$groupBy$iv = (Iterable)((Object)group);
                boolean $i$f$groupBy2 = false;
                key$iv$iv2 = $this$groupBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$groupByTo2 = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                    Object object3;
                    UCallExpression it = (UCallExpression)element$iv$iv;
                    boolean bl3 = false;
                    key$iv$iv = it.getMethodName();
                    $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                    $i$f$getOrPut = false;
                    value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl4 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object3 = answer$iv$iv$iv;
                    } else {
                        object3 = value$iv$iv$iv;
                    }
                    Iterator list$iv$iv2 = (List)object3;
                    list$iv$iv2.add(element$iv$iv);
                }
                object.add(destination$iv$iv2.values());
            }
            List groupedCalls = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            Iterable $i$f$map22 = groupedCalls;
            $this$mapTo$iv$iv2 = LoggingSimilarMessageInspection.this;
            boolean $i$f$map = false;
            void $i$f$mapTo22 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$filterTo$iv$iv2;
                void $this$filter$iv;
                void $this$mapTo$iv$iv3;
                void group;
                $this$groupBy$iv = (List)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl = false;
                Iterable $this$map$iv3 = (Iterable)group;
                boolean $i$f$map3 = false;
                Iterable $i$f$groupByTo2 = $this$map$iv3;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo3 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                    void it;
                    key$iv$iv = (UCallExpression)item$iv$iv2;
                    $this$getOrPut$iv$iv$iv = destination$iv$iv4;
                    boolean bl5 = false;
                    $this$getOrPut$iv$iv$iv.add(new MessageLog((UCallExpression)it, LoggingSimilarMessageInspectionKt.access$splitWithPlaceholders($this$mapTo$iv$iv2.collectParts((UCallExpression)it, (LoggerTypeSearcher)LoggingPlaceholderUtilKt.getLOGGER_TYPE_SEARCHERS().mapFirst((UCallExpression)it)))));
                }
                $this$map$iv3 = (List)destination$iv$iv4;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv3 = $this$filter$iv;
                destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    boolean bl6;
                    block46: {
                        MessageLog log = (MessageLog)element$iv$iv;
                        boolean bl7 = false;
                        List<LoggingStringPartEvaluator.PartHolder> list = log.getParts();
                        if (list != null) {
                            Iterable $this$any$iv = list;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl6 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    LoggingStringPartEvaluator.PartHolder it = (LoggingStringPartEvaluator.PartHolder)element$iv;
                                    boolean bl8 = false;
                                    if (!(it.isConstant() && it.getText() != null)) continue;
                                    bl6 = true;
                                    break block46;
                                }
                                bl6 = false;
                            }
                        } else {
                            bl6 = false;
                        }
                    }
                    if (!bl6) continue;
                    destination$iv$iv4.add(element$iv$iv);
                }
                object.add((List)destination$iv$iv4);
            }
            List groups = (List)destination$iv$iv3;
            for (List group : groups) {
                if (group.size() <= 1) continue;
                Set currentGroups = SetsKt.setOf((Object)group);
                if (group.size() > 5) {
                    void $this$groupByTo$iv$iv3;
                    void $this$groupBy$iv3;
                    Object parts;
                    Object parts2;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    List<LoggingStringPartEvaluator.PartHolder> it$iv$iv;
                    boolean bl;
                    Iterable $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    boolean firstIsTaken = false;
                    firstIsTaken = true;
                    Object minLength = null;
                    Iterable $i$f$mapTo4 = group;
                    boolean $i$f$mapNotNull = false;
                    void item$iv$iv = $this$mapNotNull$iv;
                    Collection destination$iv$iv5 = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator $this$filterTo$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
                    while ($this$filterTo$iv$iv2.hasNext()) {
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = $this$filterTo$iv$iv2.next();
                        boolean bl9 = false;
                        MessageLog messageLog = (MessageLog)element$iv$iv;
                        boolean bl10 = false;
                        if (messageLog.getParts() == null) continue;
                        bl = false;
                        destination$iv$iv5.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv5;
                    boolean $i$f$filter22 = false;
                    $this$mapNotNullTo$iv$iv = $this$filter$iv;
                    destination$iv$iv5 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        parts2 = (List)element$iv$iv;
                        boolean bl11 = false;
                        if (!LoggingSimilarMessageInspectionKt.access$firstIsText((List)parts2)) continue;
                        destination$iv$iv5.add(element$iv$iv);
                    }
                    Iterator $i$f$filter22 = ((Iterable)((List)destination$iv$iv5)).iterator();
                    if (!$i$f$filter22.hasNext()) {
                        v5 = null;
                    } else {
                        parts = (List)$i$f$filter22.next();
                        boolean bl12 = false;
                        String string = ((LoggingStringPartEvaluator.PartHolder)parts.get(0)).getText();
                        parts = string != null ? string.length() : 0;
                        while ($i$f$filter22.hasNext()) {
                            Object parts3 = (List)$i$f$filter22.next();
                            $i$a$-minOfOrNull-LoggingSimilarMessageInspection$PlaceholderCountMatchesArgumentCountVisitor$visitFile$minLength$3 = false;
                            String string2 = ((LoggingStringPartEvaluator.PartHolder)parts3.get(0)).getText();
                            parts3 = string2 != null ? string2.length() : 0;
                            if (parts.compareTo(parts3) <= 0) continue;
                            parts = parts3;
                        }
                        v5 = minLength = parts;
                    }
                    if (minLength == null || (Integer)minLength == 0) {
                        firstIsTaken = false;
                        $this$filter$iv = group;
                        $i$f$mapNotNull = false;
                        parts = $this$mapNotNull$iv;
                        destination$iv$iv = new ArrayList();
                        $i$f$mapNotNullTo = false;
                        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        $i$f$forEach = false;
                        parts2 = $this$forEach$iv$iv$iv.iterator();
                        while (parts2.hasNext()) {
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = parts2.next();
                            boolean bl13 = false;
                            MessageLog messageLog = (MessageLog)element$iv$iv;
                            boolean bl14 = false;
                            if (messageLog.getParts() == null) continue;
                            bl = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        $this$mapNotNull$iv = (List)destination$iv$iv;
                        boolean $i$f$filter = false;
                        $this$mapNotNullTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList();
                        $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            parts2 = (List)element$iv$iv;
                            boolean bl15 = false;
                            if (!LoggingSimilarMessageInspectionKt.access$lastIsText((List)parts2)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $i$f$filter22 = ((Iterable)((List)destination$iv$iv)).iterator();
                        if (!$i$f$filter22.hasNext()) {
                            v8 = null;
                        } else {
                            parts = (List)$i$f$filter22.next();
                            boolean bl16 = false;
                            String string = ((LoggingStringPartEvaluator.PartHolder)CollectionsKt.last((List)parts)).getText();
                            parts = string != null ? string.length() : 0;
                            while ($i$f$filter22.hasNext()) {
                                Object parts4 = (List)$i$f$filter22.next();
                                $i$a$-minOfOrNull-LoggingSimilarMessageInspection$PlaceholderCountMatchesArgumentCountVisitor$visitFile$3 = false;
                                String string3 = ((LoggingStringPartEvaluator.PartHolder)CollectionsKt.last((List)parts4)).getText();
                                parts4 = string3 != null ? string3.length() : 0;
                                if (parts.compareTo(parts4) <= 0) continue;
                                parts = parts4;
                            }
                            v8 = minLength = parts;
                        }
                    }
                    if (minLength == null || (Integer)minLength == 0) {
                        return true;
                    }
                    $this$filter$iv = group;
                    boolean $i$f$groupBy3 = false;
                    parts = $this$groupBy$iv3;
                    Map destination$iv$iv2 = new LinkedHashMap();
                    boolean $i$f$groupByTo3 = false;
                    for (Object element$iv$iv : $this$groupByTo$iv$iv3) {
                        Object object4;
                        List<LoggingStringPartEvaluator.PartHolder> parts5;
                        String string;
                        MessageLog it = (MessageLog)element$iv$iv;
                        boolean bl17 = false;
                        if (it.getParts() == null) {
                            string = "";
                        } else if (parts5.isEmpty()) {
                            string = "";
                        } else {
                            LoggingStringPartEvaluator.PartHolder part0 = firstIsTaken ? parts5.get(0) : (LoggingStringPartEvaluator.PartHolder)CollectionsKt.last(parts5);
                            String text = part0.getText();
                            if (!part0.isConstant() || text == null || text.length() < ((Number)minLength).intValue()) {
                                string = "";
                            } else {
                                String string4 = text.substring(0, ((Number)minLength).intValue());
                                string = string4;
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                            }
                        }
                        String key$iv$iv3 = string;
                        $this$getOrPut$iv$iv$iv = destination$iv$iv2;
                        $i$f$getOrPut = false;
                        value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv3);
                        if (value$iv$iv$iv == null) {
                            boolean bl18 = false;
                            List answer$iv$iv$iv = new ArrayList();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv3, answer$iv$iv$iv);
                            object4 = answer$iv$iv$iv;
                        } else {
                            object4 = value$iv$iv$iv;
                        }
                        List list$iv$iv3 = (List)object4;
                        list$iv$iv3.add(element$iv$iv);
                    }
                    currentGroups = CollectionsKt.toSet((Iterable)destination$iv$iv2.values());
                }
                block15: for (List currentGroup : currentGroups) {
                    Set alreadyHasWarning = new LinkedHashSet();
                    int firstIndex = 0;
                    int n = CollectionsKt.getLastIndex((List)currentGroup);
                    if (firstIndex > n) continue;
                    while (true) {
                        int n2;
                        int secondIndex;
                        if ((secondIndex = firstIndex + 1) <= (n2 = CollectionsKt.getLastIndex((List)currentGroup))) {
                            while (true) {
                                if (LoggingSimilarMessageInspectionKt.access$similar(((MessageLog)currentGroup.get(firstIndex)).getParts(), ((MessageLog)currentGroup.get(secondIndex)).getParts(), this.myMinTextLength) && !this.sequenceOfCalls(((MessageLog)currentGroup.get(firstIndex)).getCall(), ((MessageLog)currentGroup.get(secondIndex)).getCall())) {
                                    if (alreadyHasWarning.add(firstIndex)) {
                                        LoggingSimilarMessageInspection.this.registerProblem(this.holder, ((MessageLog)currentGroup.get(firstIndex)).getCall(), ((MessageLog)currentGroup.get(secondIndex)).getCall());
                                    }
                                    if (alreadyHasWarning.add(secondIndex)) {
                                        LoggingSimilarMessageInspection.this.registerProblem(this.holder, ((MessageLog)currentGroup.get(secondIndex)).getCall(), ((MessageLog)currentGroup.get(firstIndex)).getCall());
                                    }
                                }
                                if (secondIndex == n2) break;
                                ++secondIndex;
                            }
                        }
                        if (firstIndex == n) continue block15;
                        ++firstIndex;
                    }
                }
            }
            return super.visitFile(node);
        }

        private final boolean sequenceOfCalls(UCallExpression call1, UCallExpression call2) {
            block2: {
                block3: {
                    UElement uastParent2;
                    UElement commonParent;
                    block5: {
                        UElement uastParent1;
                        block4: {
                            PsiElement[] psiElementArray = new PsiElement[]{UElementKt.getSourcePsiElement((UElement)((UElement)call1)), UElementKt.getSourcePsiElement((UElement)((UElement)call2))};
                            PsiElement psiElement = PsiTreeUtil.findCommonParent((PsiElement[])psiElementArray);
                            Object object = commonParent = psiElement != null ? UastContextKt.toUElement((PsiElement)psiElement) : null;
                            if (!(commonParent instanceof UBlockExpression) && !(commonParent instanceof UMethod)) break block2;
                            UElement uElement = call1.getUastParent();
                            uastParent1 = uElement != null ? uElement.getUastParent() : null;
                            UElement uElement2 = call2.getUastParent();
                            Object object2 = uastParent2 = uElement2 != null ? uElement2.getUastParent() : null;
                            if (Intrinsics.areEqual((Object)uastParent1, (Object)commonParent)) break block3;
                            UElement uElement3 = uastParent1;
                            if (!((uElement3 != null ? uElement3.getUastParent() : null) instanceof UIfExpression)) break block4;
                            UElement uElement4 = uastParent1.getUastParent();
                            if (Intrinsics.areEqual((Object)(uElement4 != null ? uElement4.getUastParent() : null), (Object)commonParent)) break block3;
                        }
                        if (uastParent1 instanceof UIfExpression && Intrinsics.areEqual((Object)((UIfExpression)uastParent1).getUastParent(), (Object)commonParent) || Intrinsics.areEqual((Object)uastParent2, (Object)commonParent)) break block3;
                        UElement uElement = uastParent2;
                        if (!((uElement != null ? uElement.getUastParent() : null) instanceof UIfExpression)) break block5;
                        UElement uElement5 = uastParent2.getUastParent();
                        if (Intrinsics.areEqual((Object)(uElement5 != null ? uElement5.getUastParent() : null), (Object)commonParent)) break block3;
                    }
                    if (!(uastParent2 instanceof UIfExpression) || !Intrinsics.areEqual((Object)((UIfExpression)uastParent2).getUastParent(), (Object)commonParent)) break block2;
                }
                return true;
            }
            return false;
        }

        private final Set<UCallExpression> collectCalls(UFile file) {
            Set result = new LinkedHashSet();
            file.accept((UastVisitor)new AbstractUastVisitor(LoggingSimilarMessageInspection.this, result){
                final /* synthetic */ LoggingSimilarMessageInspection this$0;
                final /* synthetic */ Set<UCallExpression> $result;
                {
                    this.this$0 = $receiver;
                    this.$result = $result;
                }

                public boolean visitCallExpression(UCallExpression node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    PsiElement psiElement = node.getSourcePsi();
                    if (psiElement == null) {
                        return false;
                    }
                    PsiElement place = psiElement;
                    if (SuppressionUtil.inspectionResultSuppressed((PsiElement)place, (LocalInspectionTool)((LocalInspectionTool)this.this$0))) {
                        return false;
                    }
                    LoggerTypeSearcher loggerTypeSearcher = (LoggerTypeSearcher)LoggingPlaceholderUtilKt.getLOGGER_TYPE_SEARCHERS().mapFirst(node);
                    if (loggerTypeSearcher == null) {
                        return false;
                    }
                    LoggerTypeSearcher loggerTypeSearcher2 = loggerTypeSearcher;
                    if (this.this$0.mySkipErrorLogLevel) {
                        boolean hasSetMessage = LoggingSimilarMessageInspection.access$hasSetThrowable(this.this$0, node, loggerTypeSearcher2);
                        if (hasSetMessage) {
                            return false;
                        }
                        LoggingUtil.Companion.LevelType loggerLevel = LoggingUtil.Companion.getLoggerLevel$intellij_jvm_analysis_impl$default(LoggingUtil.Companion, node, false, 2, null);
                        if (loggerLevel == LoggingUtil.Companion.LevelType.ERROR && Intrinsics.areEqual((Object)loggerTypeSearcher2, (Object)LoggingPlaceholderUtilKt.getIDEA_PLACEHOLDERS())) {
                            return false;
                        }
                        List valueArguments = node.getValueArguments();
                        if (!Intrinsics.areEqual((Object)loggerTypeSearcher2, (Object)LoggingPlaceholderUtilKt.getSLF4J_BUILDER_HOLDER()) && !Intrinsics.areEqual((Object)loggerTypeSearcher2, (Object)LoggingPlaceholderUtilKt.getLOG4J_LOG_BUILDER_HOLDER()) && !valueArguments.isEmpty() && LoggingPlaceholderUtilKt.hasThrowableType((UExpression)CollectionsKt.last((List)valueArguments))) {
                            return false;
                        }
                    }
                    this.$result.add(node);
                    return true;
                }
            });
            return result;
        }
    }
}

