/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class InterpretedIRBodyMethod
extends InterpretedIRMethod {
    public InterpretedIRBodyMethod(IRScope method2, RubyModule implementationClass) {
        super(method2, Visibility.PUBLIC, implementationClass);
        this.callCount = -1;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return ArgumentDescriptor.EMPTY_ARRAY;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        return this.call(context, self2, clazz, name2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        return this.callInternal(context, clazz);
    }

    protected IRubyObject callInternal(ThreadContext context, RubyModule clazz) {
        this.ensureInstrsReady();
        switch (this.getIRScope().getScopeType()) {
            case MODULE_BODY: {
                return Interpreter.INTERPRET_MODULE(context, this.getIRScope(), clazz, this.name);
            }
            case CLASS_BODY: {
                return Interpreter.INTERPRET_CLASS(context, this.getIRScope(), clazz, this.name);
            }
            case METACLASS_BODY: {
                return Interpreter.INTERPRET_METACLASS(context, this.getIRScope(), clazz, this.name, this.getVisibility());
            }
        }
        throw new RuntimeException("invalid body method type: " + String.valueOf(this.getIRScope()));
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        return this.call(context, self2, clazz, name2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.call(context, self2, clazz, name2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.call(context, self2, clazz, name2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
        return this.call(context, self2, clazz, name2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
        return this.call(context, self2, clazz, name2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0) {
        return this.call(context, self2, clazz, name2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        return this.call(context, self2, clazz, name2, Block.NULL_BLOCK);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return this.call(context, self2, clazz, name2, Block.NULL_BLOCK);
    }
}

