/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.config.MetricsOptions;
import org.keycloak.credential.CredentialProviderFactory;
import org.keycloak.credential.PasswordCredentialProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;

public class PasswordCredentialProviderFactory
implements CredentialProviderFactory<PasswordCredentialProvider> {
    public static final String PROVIDER_ID = "keycloak-password";
    private static final String HASHES_COUNTER_TAGS = "validations-counter-tags";
    private static final String KEYCLOAK_METER_NAME_PREFIX = "keycloak.";
    private static final String LOGIN_PASSWORD_VERIFY_METER_NAME = "keycloak.credentials.password.hashing";
    private static final String LOGIN_PASSWORD_VERIFY_METER_DESCRIPTION = "Password validations";
    public static final String METER_REALM_TAG = "realm";
    public static final String METER_ALGORITHM_TAG = "algorithm";
    public static final String METER_HASHING_STRENGTH_TAG = "hashing_strength";
    public static final String METER_VALIDATION_OUTCOME_TAG = "outcome";
    private static final String HASHES_COUNTER_TAGS_DEFAULT_VALUE = String.format("%s,%s,%s,%s", "realm", "algorithm", "hashing_strength", "outcome");
    private boolean metricsEnabled;
    private boolean withRealmInMetric;
    private boolean withAlgorithmInMetric;
    private boolean withHashingStrengthInMetric;
    private boolean withOutcomeInMetric;
    private Meter.MeterProvider<Counter> meterProvider;

    public PasswordCredentialProvider create(KeycloakSession session) {
        return new PasswordCredentialProvider(session, this.meterProvider, this.metricsEnabled, this.withRealmInMetric, this.withAlgorithmInMetric, this.withHashingStrengthInMetric, this.withOutcomeInMetric);
    }

    public void init(Config.Scope config) {
        this.metricsEnabled = config.root().getBoolean(MetricsOptions.METRICS_ENABLED.getKey(), Boolean.valueOf(false));
        if (this.metricsEnabled) {
            this.meterProvider = Counter.builder((String)LOGIN_PASSWORD_VERIFY_METER_NAME).description(LOGIN_PASSWORD_VERIFY_METER_DESCRIPTION).baseUnit("validations").withRegistry((MeterRegistry)Metrics.globalRegistry);
            Set tags = Arrays.stream(config.get(HASHES_COUNTER_TAGS, HASHES_COUNTER_TAGS_DEFAULT_VALUE).split(",")).collect(Collectors.toSet());
            this.withRealmInMetric = tags.contains(METER_REALM_TAG);
            this.withAlgorithmInMetric = tags.contains(METER_ALGORITHM_TAG);
            this.withHashingStrengthInMetric = tags.contains(METER_HASHING_STRENGTH_TAG);
            this.withOutcomeInMetric = tags.contains(METER_VALIDATION_OUTCOME_TAG);
        }
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name(HASHES_COUNTER_TAGS).type("string").helpText("Comma-separated list of tags to be used when publishing password validation counter metric.").options(new String[]{METER_REALM_TAG, METER_ALGORITHM_TAG, METER_HASHING_STRENGTH_TAG, METER_VALIDATION_OUTCOME_TAG}).defaultValue((Object)HASHES_COUNTER_TAGS_DEFAULT_VALUE).add().build();
    }
}

