# Vuex

[![npm](https://img.shields.io/npm/v/vuex/next.svg)](https://npmjs.com/package/vuex)
[![ci status](https://circleci.com/gh/vuejs/vuex/tree/dev.png?style=shield)](https://circleci.com/gh/vuejs/vuex)

---

:fire: **HEADS UP!** You're currently looking at Vuex 4 branch. If you're looking for Vuex 3, [please check out `dev` branch](https://github.com/vuejs/vuex).

---

Vuex is a state management pattern + library for Vue.js applications. It serves as a centralized store for all the components in an application, with rules ensuring that the state can only be mutated in a predictable fashion. It also integrates with Vue's official [devtools extension](https://github.com/vuejs/vue-devtools) to provide advanced features such as zero-config time-travel debugging and state snapshot export / import.

Learn more about Vuex at "[What is Vuex?](https://next.vuex.vuejs.org/)", or get started by looking into [full documentation](http://next.vuex.vuejs.org/).

## Documentation

To check out docs, visit [vuex.vuejs.org](https://next.vuex.vuejs.org/).

## Examples

You may find example applications built with Vuex under the `examples` directory.

Running the examples:

```bash
$ npm install
$ npm run dev # serve examples at localhost:8080
```

## Questions

For questions and support please use the [Discord chat server](https://chat.vuejs.org) or [the official forum](http://forum.vuejs.org). The issue list of this repo is **exclusively** for bug reports and feature requests.

## Issues

Please make sure to read the [Issue Reporting Checklist](https://github.com/vuejs/vuex/blob/dev/.github/contributing.md#issue-reporting-guidelines) before opening an issue. Issues not conforming to the guidelines may be closed immediately.

## Changelog

Detailed changes for each release are documented in the [release notes](https://github.com/vuejs/vuex/releases).

## Stay In Touch

For latest releases and announcements, follow on Twitter: [@vuejs](https://twitter.com/vuejs).

## Contribution

Please make sure to read the [Contributing Guide](https://github.com/vuejs/vuex/blob/dev/.github/contributing.md) before making a pull request.

## License

[MIT](http://opensource.org/licenses/MIT)

Copyright (c) 2015-present Evan You
