/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene50;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.backward_codecs.compressing.CompressionMode;
import org.apache.lucene.backward_codecs.compressing.Compressor;
import org.apache.lucene.backward_codecs.compressing.Decompressor;
import org.apache.lucene.backward_codecs.lucene50.compressing.Lucene50CompressingStoredFieldsFormat;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.compress.LZ4;

public class Lucene50StoredFieldsFormat
extends StoredFieldsFormat {
    public static final String MODE_KEY = Lucene50StoredFieldsFormat.class.getSimpleName() + ".mode";
    final Mode mode;
    static final CompressionMode FAST_MODE = new CompressionMode(){

        @Override
        public Compressor newCompressor() {
            return new LZ4FastCompressor();
        }

        @Override
        public Decompressor newDecompressor() {
            return LZ4_DECOMPRESSOR;
        }

        public String toString() {
            return "FAST";
        }
    };
    private static final Decompressor LZ4_DECOMPRESSOR = new Decompressor(){

        @Override
        public void decompress(DataInput in, int originalLength, int offset, int length, BytesRef bytes) throws IOException {
            int decompressedLength;
            assert (offset + length <= originalLength);
            if (bytes.bytes.length < originalLength + 7) {
                bytes.bytes = new byte[ArrayUtil.oversize((int)(originalLength + 7), (int)1)];
            }
            if ((decompressedLength = LZ4.decompress((DataInput)EndiannessReverserUtil.wrapDataInput(in), (int)(offset + length), (byte[])bytes.bytes, (int)0)) > originalLength) {
                throw new CorruptIndexException("Corrupted: lengths mismatch: " + decompressedLength + " > " + originalLength, in);
            }
            bytes.offset = offset;
            bytes.length = length;
        }

        @Override
        public Decompressor clone() {
            return this;
        }
    };

    public Lucene50StoredFieldsFormat() {
        this(Mode.BEST_SPEED);
    }

    public Lucene50StoredFieldsFormat(Mode mode) {
        this.mode = Objects.requireNonNull(mode);
    }

    public final StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        String value = si.getAttribute(MODE_KEY);
        if (value == null) {
            throw new IllegalStateException("missing value for " + MODE_KEY + " for segment: " + si.name);
        }
        Mode mode = Mode.valueOf(value);
        return this.impl(mode).fieldsReader(directory, si, fn, context);
    }

    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        throw new UnsupportedOperationException("Old codecs may only be used for reading");
    }

    StoredFieldsFormat impl(Mode mode) {
        switch (mode.ordinal()) {
            case 0: {
                return new Lucene50CompressingStoredFieldsFormat("Lucene50StoredFieldsFastData", FAST_MODE, 16384, 128, 10);
            }
            case 1: {
                return new Lucene50CompressingStoredFieldsFormat("Lucene50StoredFieldsHighData", CompressionMode.HIGH_COMPRESSION, 61440, 512, 10);
            }
        }
        throw new AssertionError();
    }

    public static enum Mode {
        BEST_SPEED,
        BEST_COMPRESSION;

    }

    private static final class LZ4FastCompressor
    extends Compressor {
        private final LZ4.FastCompressionHashTable ht = new LZ4.FastCompressionHashTable();

        LZ4FastCompressor() {
        }

        @Override
        public void compress(byte[] bytes, int off, int len, DataOutput out) throws IOException {
            LZ4.compress((byte[])bytes, (int)off, (int)len, (DataOutput)EndiannessReverserUtil.wrapDataOutput(out), (LZ4.HashTable)this.ht);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

