/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.cache;

import java.util.List;
import org.opensearch.common.annotation.ExperimentalApi;

@ExperimentalApi
public class ICacheKey<K> {
    public final K key;
    public final List<String> dimensions;
    private boolean dropStatsForDimensions;

    public ICacheKey(K key, List<String> dimensions) {
        this.key = key;
        this.dimensions = dimensions;
    }

    public ICacheKey(K key) {
        this.key = key;
        this.dimensions = List.of();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != ICacheKey.class) {
            return false;
        }
        ICacheKey other = (ICacheKey)o;
        if (!this.dimensions.equals(other.dimensions)) {
            return false;
        }
        if (this.key == null && other.key == null) {
            return true;
        }
        if (this.key == null || other.key == null) {
            return false;
        }
        return this.key.equals(other.key);
    }

    public int hashCode() {
        if (this.key == null) {
            return this.dimensions.hashCode();
        }
        return 31 * this.key.hashCode() + this.dimensions.hashCode();
    }

    public long ramBytesUsed(long underlyingKeyRamBytes) {
        long estimate = underlyingKeyRamBytes;
        for (String dim : this.dimensions) {
            estimate += (long)dim.length();
        }
        return estimate;
    }

    public boolean getDropStatsForDimensions() {
        return this.dropStatsForDimensions;
    }

    public void setDropStatsForDimensions(boolean newValue) {
        this.dropStatsForDimensions = newValue;
    }
}

