/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.util.UploadListener;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.RemoteStoreUploader;
import org.opensearch.index.store.CompositeDirectory;
import org.opensearch.index.store.RemoteSegmentStoreDirectory;

public class RemoteStoreUploaderService
implements RemoteStoreUploader {
    private final Logger logger;
    private final IndexShard indexShard;
    private final Directory storeDirectory;
    private final RemoteSegmentStoreDirectory remoteDirectory;

    public RemoteStoreUploaderService(IndexShard indexShard, Directory storeDirectory, RemoteSegmentStoreDirectory remoteDirectory) {
        this.logger = Loggers.getLogger(this.getClass(), indexShard.shardId(), new String[0]);
        this.indexShard = indexShard;
        this.storeDirectory = storeDirectory;
        this.remoteDirectory = remoteDirectory;
    }

    @Override
    public void uploadSegments(Collection<String> localSegments, Map<String, Long> localSegmentsSizeMap, ActionListener<Void> listener, Function<Map<String, Long>, UploadListener> uploadListenerFunction, boolean isLowPriorityUpload) {
        if (localSegments.isEmpty()) {
            this.logger.debug("No new segments to upload in uploadNewSegments");
            listener.onResponse(null);
            return;
        }
        this.logger.debug("Effective new segments files to upload {}", localSegments);
        ActionListener mappedListener = ActionListener.map(listener, resp -> null);
        GroupedActionListener batchUploadListener = new GroupedActionListener(mappedListener, localSegments.size());
        Directory directory = ((FilterDirectory)((FilterDirectory)this.storeDirectory).getDelegate()).getDelegate();
        for (String localSegment : localSegments) {
            UploadListener statsListener = uploadListenerFunction.apply(localSegmentsSizeMap);
            ActionListener aggregatedListener = ActionListener.wrap(resp -> {
                statsListener.onSuccess(localSegment);
                batchUploadListener.onResponse(resp);
                if (directory instanceof CompositeDirectory) {
                    ((CompositeDirectory)directory).afterSyncToRemote(localSegment);
                }
            }, ex -> {
                this.logger.warn(() -> new ParameterizedMessage("Exception: [{}] while uploading segment files", ex), (Throwable)ex);
                if (ex instanceof CorruptIndexException) {
                    this.indexShard.failShard(ex.getMessage(), (Exception)ex);
                }
                statsListener.onFailure(localSegment);
                batchUploadListener.onFailure((Exception)ex);
            });
            statsListener.beforeUpload(localSegment);
            this.remoteDirectory.copyFrom(this.storeDirectory, localSegment, IOContext.DEFAULT, (ActionListener<Void>)aggregatedListener, isLowPriorityUpload);
        }
    }
}

