"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataViewFieldList = void 0;
var _lodash = require("lodash");
var _data_view_field = require("./data_view_field");
var _utils = require("../../utils");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
// extending the array class and using a constructor doesn't work well
// when calling filter and similar so wrapping in a callback.
// to be removed in the future
const dataViewFieldList = (specs = [], shortDotsEnable = false) => {
  class FldList extends Array {
    constructor() {
      super();
      _defineProperty(this, "byName", new Map());
      _defineProperty(this, "groups", new Map());
      _defineProperty(this, "setByName", field => this.byName.set(field.name, field));
      _defineProperty(this, "setByGroup", field => {
        if (typeof this.groups.get(field.type) === 'undefined') {
          this.groups.set(field.type, new Map());
        }
        this.groups.get(field.type).set(field.name, field);
      });
      _defineProperty(this, "removeByGroup", field => this.groups.get(field.type).delete(field.name));
      _defineProperty(this, "calcDisplayName", name => shortDotsEnable ? (0, _utils.shortenDottedString)(name) : name);
      _defineProperty(this, "getAll", () => [...this.byName.values()]);
      _defineProperty(this, "getByName", name => this.byName.get(name));
      _defineProperty(this, "getByType", type => [...(this.groups.get(type) || new Map()).values()]);
      _defineProperty(this, "add", field => {
        const newField = new _data_view_field.DataViewField(field, this.calcDisplayName(field.name));
        this.push(newField);
        this.setByName(newField);
        this.setByGroup(newField);
      });
      _defineProperty(this, "remove", field => {
        this.removeByGroup(field);
        this.byName.delete(field.name);
        const fieldIndex = (0, _lodash.findIndex)(this, {
          name: field.name
        });
        this.splice(fieldIndex, 1);
      });
      _defineProperty(this, "update", field => {
        const newField = new _data_view_field.DataViewField(field, this.calcDisplayName(field.name));
        const index = this.findIndex(f => f.name === newField.name);
        this.splice(index, 1, newField);
        this.setByName(newField);
        this.removeByGroup(newField);
        this.setByGroup(newField);
      });
      _defineProperty(this, "removeAll", () => {
        this.length = 0;
        this.byName.clear();
        this.groups.clear();
      });
      _defineProperty(this, "replaceAll", (spcs = []) => {
        this.removeAll();
        spcs.forEach(this.add);
      });
      specs.map(field => this.add(field));
    }
    toSpec({
      getFormatterForField
    } = {}) {
      return {
        ...this.reduce((collector, field) => {
          collector[field.name] = field.toSpec({
            getFormatterForField
          });
          return collector;
        }, {})
      };
    }
  }
  return new FldList();
};
exports.dataViewFieldList = dataViewFieldList;