/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.cluster.stats.ClusterJvmMemory;
import org.opensearch.client.opensearch.cluster.stats.ClusterJvmVersion;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ClusterJvm
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ClusterJvm> {
    @Nullable
    private final Time maxUptime;
    private final long maxUptimeInMillis;
    @Nonnull
    private final ClusterJvmMemory mem;
    private final long threads;
    @Nonnull
    private final List<ClusterJvmVersion> versions;
    public static final JsonpDeserializer<ClusterJvm> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterJvm::setupClusterJvmDeserializer);

    private ClusterJvm(Builder builder) {
        this.maxUptime = builder.maxUptime;
        this.maxUptimeInMillis = ApiTypeHelper.requireNonNull(builder.maxUptimeInMillis, this, "maxUptimeInMillis");
        this.mem = ApiTypeHelper.requireNonNull(builder.mem, this, "mem");
        this.threads = ApiTypeHelper.requireNonNull(builder.threads, this, "threads");
        this.versions = ApiTypeHelper.unmodifiable(builder.versions);
    }

    public static ClusterJvm of(Function<Builder, ObjectBuilder<ClusterJvm>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time maxUptime() {
        return this.maxUptime;
    }

    public final long maxUptimeInMillis() {
        return this.maxUptimeInMillis;
    }

    @Nonnull
    public final ClusterJvmMemory mem() {
        return this.mem;
    }

    public final long threads() {
        return this.threads;
    }

    @Nonnull
    public final List<ClusterJvmVersion> versions() {
        return this.versions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxUptime != null) {
            generator.writeKey("max_uptime");
            this.maxUptime.serialize(generator, mapper);
        }
        generator.writeKey("max_uptime_in_millis");
        generator.write(this.maxUptimeInMillis);
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        generator.writeKey("threads");
        generator.write(this.threads);
        if (ApiTypeHelper.isDefined(this.versions)) {
            generator.writeKey("versions");
            generator.writeStartArray();
            for (ClusterJvmVersion item0 : this.versions) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupClusterJvmDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxUptime, Time._DESERIALIZER, "max_uptime");
        op.add(Builder::maxUptimeInMillis, JsonpDeserializer.longDeserializer(), "max_uptime_in_millis");
        op.add(Builder::mem, ClusterJvmMemory._DESERIALIZER, "mem");
        op.add(Builder::threads, JsonpDeserializer.longDeserializer(), "threads");
        op.add(Builder::versions, JsonpDeserializer.arrayDeserializer(ClusterJvmVersion._DESERIALIZER), "versions");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.maxUptime);
        result = 31 * result + Long.hashCode(this.maxUptimeInMillis);
        result = 31 * result + this.mem.hashCode();
        result = 31 * result + Long.hashCode(this.threads);
        result = 31 * result + Objects.hashCode(this.versions);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterJvm other = (ClusterJvm)o;
        return Objects.equals(this.maxUptime, other.maxUptime) && this.maxUptimeInMillis == other.maxUptimeInMillis && this.mem.equals(other.mem) && this.threads == other.threads && Objects.equals(this.versions, other.versions);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ClusterJvm> {
        @Nullable
        private Time maxUptime;
        private Long maxUptimeInMillis;
        private ClusterJvmMemory mem;
        private Long threads;
        @Nullable
        private List<ClusterJvmVersion> versions;

        public Builder() {
        }

        private Builder(ClusterJvm o) {
            this.maxUptime = o.maxUptime;
            this.maxUptimeInMillis = o.maxUptimeInMillis;
            this.mem = o.mem;
            this.threads = o.threads;
            this.versions = Builder._listCopy(o.versions);
        }

        private Builder(Builder o) {
            this.maxUptime = o.maxUptime;
            this.maxUptimeInMillis = o.maxUptimeInMillis;
            this.mem = o.mem;
            this.threads = o.threads;
            this.versions = Builder._listCopy(o.versions);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder maxUptime(@Nullable Time value) {
            this.maxUptime = value;
            return this;
        }

        @Nonnull
        public final Builder maxUptime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.maxUptime(fn.apply(new Time.Builder()).build());
        }

        @Nonnull
        public final Builder maxUptimeInMillis(long value) {
            this.maxUptimeInMillis = value;
            return this;
        }

        @Nonnull
        public final Builder mem(ClusterJvmMemory value) {
            this.mem = value;
            return this;
        }

        @Nonnull
        public final Builder mem(Function<ClusterJvmMemory.Builder, ObjectBuilder<ClusterJvmMemory>> fn) {
            return this.mem(fn.apply(new ClusterJvmMemory.Builder()).build());
        }

        @Nonnull
        public final Builder threads(long value) {
            this.threads = value;
            return this;
        }

        @Nonnull
        public final Builder versions(List<ClusterJvmVersion> list) {
            this.versions = Builder._listAddAll(this.versions, list);
            return this;
        }

        @Nonnull
        public final Builder versions(ClusterJvmVersion value, ClusterJvmVersion ... values) {
            this.versions = Builder._listAdd(this.versions, value, values);
            return this;
        }

        @Nonnull
        public final Builder versions(Function<ClusterJvmVersion.Builder, ObjectBuilder<ClusterJvmVersion>> fn) {
            return this.versions(fn.apply(new ClusterJvmVersion.Builder()).build(), new ClusterJvmVersion[0]);
        }

        @Override
        @Nonnull
        public ClusterJvm build() {
            this._checkSingleUse();
            return new ClusterJvm(this);
        }
    }
}

